local pipeworks_installed = minetest.global_exists("pipeworks")

local function find_water_supply(pos)
	if not pipeworks_installed then return true end
	local minp = vector.add(pos,vector.new(-1,-1,-1))
	local maxp = vector.add(pos,vector.new(1,1,1))
	local nodes = minetest.find_nodes_in_area(minp,maxp,"group:pipe")
	for _,pipepos in pairs(nodes) do
		local node = minetest.get_node(pipepos)
		if string.match(node.name,"^pipeworks:.*_loaded$") then
			return true
		end
	end
	return false
end

local function set_formspec(meta,enabled,full,water)
	local status
	if enabled then
		if water then
			if full then
				status = "Full Bin"
			else
				status = "Making Ice"
			end
		else
			status = "Water Error"
		end
	else
		status = "Off"
	end
	local fs = "size[3,2]"..
	           "box[-0.15,0;3,1.5;#0000FF]"..
	           "label[0.2,0.3;"..status.."]"..
	           "button[0.5,1.5;2,1;power;Power]"
	meta:set_string("formspec",fs)
end

local function update_status(pos,meta,ice)
	local timer = minetest.get_node_timer(pos)
	local enabled = meta:get_int("enabled")==1
	if not enabled then
		timer:stop()
		set_formspec(meta,false)
	else
		local water = find_water_supply(pos)
		local binpos = vector.add(pos,vector.new(0,-1,0))
		local binnode = minetest.get_node(binpos)
		local binmeta = minetest.get_meta(binpos)
		local bininv = binmeta:get_inventory()
		if binnode.name ~= "icemachine:bin" or not bininv:room_for_item("ice","icemachine:cube") then
			timer:stop()
			set_formspec(meta,true,true,true)
		else
			if water then
				if not timer:is_started() then timer:start(30) end
				if ice then bininv:add_item("ice","icemachine:cube 9") end
				set_formspec(meta,true,false,true)
			else
				timer:stop()
				set_formspec(meta,true,false,false)
			end
		end
	end
end

minetest.register_node("icemachine:machine",{
	description = "Ice Machine",
	paramtype2 = "facedir",
	groups = {cracky=3},
	tiles = {
		"default_steel_block.png",
		"default_steel_block.png",
		"default_steel_block.png^icemachine_machine_sides.png",
		"default_steel_block.png^icemachine_machine_sides.png",
		"default_steel_block.png",
		"default_steel_block.png^icemachine_machine_front.png",
	},
	pipe_connections = {left=1,right=1,front=1,back=1,left_param2=3,right_param2=1,front_param2=2,back_param2=0,},
	after_place_node = (pipeworks_installed and pipeworks.scan_for_pipe_objects),
	after_dig_node = (pipeworks_installed and pipeworks.scan_for_pipe_objects),
	on_construct = function(pos)
		local meta = minetest.get_meta(pos)
		update_status(pos,meta)
	end,
	on_receive_fields = function(pos,_,fields)
		local meta = minetest.get_meta(pos)
		if fields.power then
			meta:set_int("enabled",math.abs(meta:get_int("enabled")-1))
			update_status(pos,meta)
		end
	end,
	on_timer = function(pos)
		local meta = minetest.get_meta(pos)
		update_status(pos,meta,true)
	end,
})

minetest.register_node("icemachine:bin",{
	description = "Ice Bin",
	paramtype2 = "facedir",
	groups = {cracky=3},
	tiles = {
		"default_steel_block.png",
		"default_steel_block.png",
		"default_steel_block.png",
		"default_steel_block.png",
		"default_steel_block.png",
		"default_steel_block.png^icemachine_bin_front.png",
	},
	tube = {input_inventory="ice"},
	on_construct = function(pos)
		local meta = minetest.get_meta(pos)
		local inv = meta:get_inventory()
		inv:set_size("ice",8*3)
		meta:set_string("formspec",
			"size[8,9]"..
			"list[context;ice;0,0;8,4;]"..
			"list[current_player;main;0,5;8,4;]"..
			"listring[]")
	end,
	allow_metadata_inventory_put = function(_,_,_,stack)
		if stack:get_name() == "icemachine:cube" then
			return(stack:get_count())
		else
			return(0)
		end
	end,
	on_metadata_inventory_take = function(pos)
		local machinepos = vector.add(pos,vector.new(0,1,0))
		local machinemeta = minetest.get_meta(machinepos)
		update_status(machinepos,machinemeta)
	end,
	can_dig = function(pos)
		return(minetest.get_meta(pos):get_inventory():is_empty("ice"))
	end,
})

minetest.register_craftitem("icemachine:cube",{
	description = "Ice Cube",
	inventory_image = "icemachine_cube.png",
})

minetest.register_craft({
	output = "icemachine:machine",
	recipe = {
		{"default:steel_ingot",  "bucket:bucket_water",        "default:steel_ingot"},
		{"default:steel_ingot",  "homedecor:fence_chainlink",  "homedecor:motor"},
		{"default:steel_ingot",  "bucket:bucket_empty",        "homedecor:ic"},
	},
})

minetest.register_craft({
	output = "icemachine:bin",
	recipe = {
		{"homedecor:plastic_sheeting",  "",                     "homedecor:plastic_sheeting"},
		{"homedecor:plastic_sheeting",  "",                     "homedecor:plastic_sheeting"},
		{"default:steel_ingot",         "default:steel_ingot",  "default:steel_ingot"},
	},
})

minetest.register_craft({
	output = "default:ice",
	recipe = {
		{"icemachine:cube",  "icemachine:cube",  "icemachine:cube"},
		{"icemachine:cube",  "icemachine:cube",  "icemachine:cube"},
		{"icemachine:cube",  "icemachine:cube",  "icemachine:cube"},
	},
})

minetest.register_craft({
	type = "shapeless",
	output = "icemachine:cube 9",
	recipe = {"default:ice"},
})

if minetest.global_exists("technic") then
	technic.register_grinder_recipe({input={"default:ice 1"},output="default:snowblock 1"})
end
