local C = {}

C.DIMENSION = {
    SEQUENCE_Y = 10000,
    WONDERLAND_Y = 20000,
    CORNERS_Y = 30000,
    HEIGHT = 200,
    VOID_THRESHOLD = 500,
}

C.ENTITY = {
    BASE_SPEED = 2,
    COLLISION_BOX = {-0.4, 0, -0.4, 0.4, 2.5, 0.4},
    VISUAL_SIZE = {x = 2, y = 3, z = 2},
    SPAWN_DISTANCE_MIN = 15,
    SPAWN_DISTANCE_MAX = 30,
    STUCK_THRESHOLD = 5,
    HITS_TO_ESCAPE_MIN = 4,
    HITS_TO_ESCAPE_MAX = 8,
    RESPAWN_TIME_MIN = 60,
    RESPAWN_TIME_MAX = 180,
    KILL_DISTANCE = 2,
    CHASE_TIMEOUT = 15,
    STALK_DISTANCE = 10,
}

C.TIMERS = {
    SPAWN_CHECK = 30,
    DAY_CHECK = 60,
    GOD_MODE_CHECK = 0.3,
    TIME_CONTROL = 1,
    AMBIENT = 60,
    PHASE_EFFECTS = 30,
    NIGHT_EMPOWER = 10,
    SPECIAL_EVENT = 300,
    PORTAL_PARTICLES = 2,
    ABILITY_CHECK = 3,
}

C.ABILITY_COOLDOWNS = {
    whisper = 5,
    teleport = 15,
    invisibility = 20,
    speed_change = 10,
    torch_destroy = 8,
    door_interact = 12,
    sound_distort = 3,
    item_steal = 30,
    inventory_shuffle = 45,
    behind_spawn = 8,
    corner_watch = 15,
    ceiling_hang = 20,
    wall_phase = 12,
    name_whisper = 25,
    light_flicker = 10,
    freeze_player = 25,
    fog_gen = 30,
    jumpscare = 20,
    env_manipulate = 40,
    size_change = 15,
    clone_surround = 600,
    mirror_appear = 18,
    block_decay = 20,
    window_peek = 15,
}

C.LIGHT = {
    DARK_THRESHOLD = 8,
    PORTAL_GLOW = 8,
    RITUAL_GLOW = 5,
}

C.GRID = {
    SEQUENCE_SIZE = 20,
    SEQUENCE_CUBE_HEIGHT = 25,
    WONDERLAND_TREE_SPACING = 15,
    CORNERS_CELL_SIZE = 20,
    CORNERS_PASSAGE_WIDTH = 4,
    CORNERS_WALL_HEIGHT = 30,
}

C.STRUCTURE = {
    HOUSE_SPAWN_CHANCE = 0.05,
    SHRINE_SPAWN_CHANCE = 0.03,
    SIGN_SPAWN_CHANCE = 0.08,
    RITUAL_SPAWN_CHANCE = 0.02,
    GRAVE_SPAWN_CHANCE = 0.04,
    TOWER_SPAWN_CHANCE = 0.02,
    WELL_SPAWN_CHANCE = 0.03,
}

C.FOV_MULTIPLIER = {
    MIN = 0.8,
    MAX = 1.2,
}

C.NIGHT = {
    START = 0.75,
    END = 0.25,
}

C.PHASE = {
    MIN = 1,
    MAX = 5,
    DAYS_PER_ADVANCE = 5,
}

return C
