local oh = obelisk_analog
local C = oh.C

minetest.register_node("obelisk_analog:ritual_stone", {
    description = "Ritual Stone",
    tiles = {"default_obsidian.png"},
    groups = {cracky = 1, not_in_creative_inventory = 1},
    sounds = default.node_sound_stone_defaults(),
    light_source = 3,
})

minetest.register_node("obelisk_analog:warning_sign", {
    description = "Warning Sign",
    tiles = {"default_wood.png"},
    groups = {choppy = 2, not_in_creative_inventory = 1},
    sounds = default.node_sound_wood_defaults(),
    paramtype2 = "facedir",
    on_construct = function(pos)
        local meta = minetest.get_meta(pos)
        meta:set_string("infotext", "DANGER - DO NOT ENTER")
    end,
})

minetest.register_node("obelisk_analog:shrine_block", {
    description = "Shrine Block",
    tiles = {"default_stone_brick.png"},
    groups = {cracky = 2, not_in_creative_inventory = 1},
    sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("obelisk_analog:portal_sequence", {
    description = "Portal to The Sequence",
    tiles = {"default_obsidian.png^[colorize:#0000FF:80"},
    drawtype = "glasslike",
    paramtype = "light",
    light_source = C.LIGHT.PORTAL_GLOW,
    groups = {cracky = 1, not_in_creative_inventory = 1},
    sounds = default.node_sound_glass_defaults(),
    on_rightclick = function(pos, node, player, itemstack, pointed_thing)
        if player and oh.teleport_to_dimension then
            oh.teleport_to_dimension(player, "sequence")
        end
    end,
})

minetest.register_node("obelisk_analog:portal_wonderland", {
    description = "Portal to Wonderland",
    tiles = {"default_obsidian.png^[colorize:#00FF00:80"},
    drawtype = "glasslike",
    paramtype = "light",
    light_source = C.LIGHT.PORTAL_GLOW,
    groups = {cracky = 1, not_in_creative_inventory = 1},
    sounds = default.node_sound_glass_defaults(),
    on_rightclick = function(pos, node, player, itemstack, pointed_thing)
        if player and oh.teleport_to_dimension then
            oh.teleport_to_dimension(player, "wonderland")
        end
    end,
})

minetest.register_node("obelisk_analog:portal_corners", {
    description = "Portal to The Corners",
    tiles = {"default_obsidian.png^[colorize:#FF0000:80"},
    drawtype = "glasslike",
    paramtype = "light",
    light_source = C.LIGHT.PORTAL_GLOW,
    groups = {cracky = 1, not_in_creative_inventory = 1},
    sounds = default.node_sound_glass_defaults(),
    on_rightclick = function(pos, node, player, itemstack, pointed_thing)
        if player and oh.teleport_to_dimension then
            oh.teleport_to_dimension(player, "corners")
        end
    end,
})

minetest.register_node("obelisk_analog:portal_overworld", {
    description = "Portal to Overworld",
    tiles = {"default_obsidian.png^[colorize:#FFFFFF:80"},
    drawtype = "glasslike",
    paramtype = "light",
    light_source = 14,
    groups = {cracky = 1, not_in_creative_inventory = 1},
    sounds = default.node_sound_glass_defaults(),
    on_rightclick = function(pos, node, player, itemstack, pointed_thing)
        if player and oh.teleport_to_overworld then
            oh.teleport_to_overworld(player)
        end
    end,
})

minetest.register_node("obelisk_analog:dead_leaves", {
    description = "Dead Leaves",
    drawtype = "allfaces_optional",
    tiles = {"default_dry_shrub.png"},
    paramtype = "light",
    groups = {snappy = 3, not_in_creative_inventory = 1},
    sounds = default.node_sound_leaves_defaults(),
})

minetest.register_craftitem("obelisk_analog:portal_key_sequence", {
    description = "Key to The Sequence",
    inventory_image = "default_key.png^[colorize:#0000FF:100",
    stack_max = 1,
    groups = {not_in_creative_inventory = 1},
})

minetest.register_craftitem("obelisk_analog:portal_key_wonderland", {
    description = "Key to Wonderland",
    inventory_image = "default_key.png^[colorize:#00FF00:100",
    stack_max = 1,
    groups = {not_in_creative_inventory = 1},
})

minetest.register_craftitem("obelisk_analog:portal_key_corners", {
    description = "Key to The Corners",
    inventory_image = "default_key.png^[colorize:#FF0000:100",
    stack_max = 1,
    groups = {not_in_creative_inventory = 1},
})
