# Craft recipes for Morelights items

Copper = copper ingot (Minetest Game, Hades Revisited) or redstone
(MineClone 2).

Dye = white or dark grey dye, depending on the desired color of the item.
For MineClone 2, use bone meal or grey dye.

Dark Wood = jungle wood planks (Minetest Game), spruce wood (MineClone 2), or
tropical wood planks (Hades Revisited).

Glass = regular, non-stained glass block.

Glass Pane = regular, non-stained glass pane. For Hades Revisited, if
`hades_extensionmods`/`hades_xpanes` is not available, use regular glass
instead.

Steel = steel ingot (Minetest Game, Hades Revisited) or iron ingot
(MineClone 2).

## Basic items

### Light Bulb

Used for most other recipes.

```
+--------+
| Glass  |
+--------+
| Copper |
+--------+
| Steel  |
+--------+
```

### Metal Pole

```
+-----+-------+
| Dye | Steel |
+-----+-------+
|     | Steel |
+-----+-------+
|     | Steel |
+-----+-------+
```

### Metal Chain

```
+-----+-------+
| Dye | Steel |
+-----+-------+
|     |       |
+-----+-------+
|     | Steel |
+-----+-------+
```

## Modern

### Modern Light Block

```
+-------+-------+-------+
|       | Steel |       |
+-------+-------+-------+
| Glass | Bulb  | Glass |
| Pane  |       | Pane  |
+-------+-------+-------+
|       | Steel |       |
+-------+-------+-------+
```

### Modern Light Block (small)

```
+-------+-------+-------+
|       | Steel |       |
+-------+-------+-------+
| Glass | Bulb  | Glass |
| Pane  |       | Pane  |
+-------+-------+-------+
```

### Modern Post Light

```
+-----+-------+
| Dye | Steel |
+-----+-------+
|     | Bulb  |
+-----+-------+
|     | Steel |
+-----+-------+
```

### Street Lamp Post

```
+-----+-------+-------+
| Dye | Steel | Steel |
+-----+-------+-------+
|     | Steel |       |
+-----+-------+-------+
|     | Steel |       |
+-----+-------+-------+
```

### Ceiling Bar Light (connecting)

```
+--------+-------+--------+
| Steel  | Steel | Steel  |
+--------+-------+--------+
| Copper | Glass | Copper |
+--------+-------+--------+
```

Also can be crafted from one straight bar light.

### Ceiling Bar Light (straight)

Craft from one connecting bar light.

### Modern Ceiling Light

```
+-------+-------+-------+
| Steel | Bulb  | Steel |
+-------+-------+-------+
|       | Glass |       |
|       | Pane  |       |
+-------+-------+-------+
```

### Modern Can Light

```
+-------+-------+-------+
|  Dye  | Steel |       |
+-------+-------+-------+
| Steel | Bulb  | Steel |
+-------+-------+-------+
```

### Modern Wall Lamp

```
+-------+-------+-------+
|       | Glass |       |
|       | Pane  |       |
+-------+-------+-------+
| Glass | Bulb  | Steel |
| Pane  |       |       |
+-------+-------+-------+
|       | Dark  | Steel |
|       |  Dye  |       |
+-------+-------+-------+
```

### Modern Table Lamp

```
+------+-------+------+
|      | Steel |      |
+------+-------+------+
| Wool | Bulb  | Wool |
+------+-------+------+
|      | Steel |      |
+------+-------+------+
```

Use light/dark grey wool.

### Modern Path Light

```
+-----+-------+
| Dye | Bulb  |
+-----+-------+
|     | Steel |
+-----+-------+
|     | Steel |
+-----+-------+
```

## Vintage

### Brass Ingot

Minetest Game, Hades Revisited: Craft from one steel and one tin ingot.

MineClone 2: Craft from one iron ingot and one redstone.

If `basic_materials` is installed, its Brass Ingot will be used instead.

### Brass Chain

```
+-------+
| Brass |
+-------+
|       |
+-------+
| Brass |
+-------+
```

### Vintage Light Block

```
+-------+------+-------+
|       | Dark |       |
|       | Wood |       |
+-------+------+-------+
| Glass | Bulb | Glass |
| Pane  |      | Pane  |
+-------+------+-------+
|       | Dark |       |
|       | Wood |       |
+-------+------+-------+
```

### Vintage Light Block (small)

```
+-------+------+-------+
|       | Dark |       |
|       | Wood |       |
+-------+------+-------+
| Glass | Bulb | Glass |
| Pane  |      | Pane  |
+-------+------+-------+
```

### Vintage Lantern (floor, wall, or ceiling)

```
+-------+-------+-------+
|       | Steel |       |
+-------+-------+-------+
| Glass | Bulb  | Glass |
| Pane  |       | Pane  |
+-------+-------+-------+
| Stick | Steel | Stick |
+-------+-------+-------+
```

### Vintage Hanging Light Bulb

```
+--------+
| Steel  |
+--------+
| Copper |
+--------+
|  Bulb  |
+--------+
```

### Vintage Oil Lamp

```
+--------+
| Glass  |
+--------+
| String |
+--------+
| Brass  |
+--------+
```

### Vintage Chandelier

```
+-------+-------+-------+
|       | Brass |       |
+-------+-------+-------+
| Bulb  | Brass | Bulb  |
+-------+-------+-------+
| Steel | Brass | Steel |
+-------+-------+-------+
```

# Extras

### Futuristic Light Block

```
+---------+-------+---------+
| Crystal | Steel | Crystal |
+---------+-------+---------+
|  Glass  | Bulb  |  Glass  |
|  Pane   |       |  Pane   |
+---------+-------+---------+
| Crystal | Steel | Crystal |
+---------+-------+---------+
```

Crystal = mese fragment (Minetest Game, Hades Revisited) or nether quartz
(MineClone 2).

### Grass Light

```
+-------+-------+
|       | Glass |
|       | Pane  |
+-------+-------+
|       | Bulb  |
+-------+-------+
| Grass | Dirt  |
+-------+-------+
```

Note: use regular grass, NOT a grass block.

### Stone Block Light

```
+-------+
| Glass |
| Pane  |
+-------+
| Bulb  |
+-------+
| Stone |
| Block |
+-------+
```

For MineClone 2, use polished stone.

### Sandstone Block Light

```
+-----------+
|   Glass   |
|   Pane    |
+-----------+
|   Bulb    |
+-----------+
| Sandstone |
|   Block   |
+-----------+
```

For MineClone 2, use cut sandstone.

For Hades Revisited, use fine sandstone.

### Stair Light

```
+-------+------+-------+
| Steel | Bulb | Steel |
+-------+------+-------+
```
