--local t = os.clock()

xdecor = {}
local modpath = minetest.get_modpath("xdecor")

dofile(modpath .. "/handlers/animations.lua")
dofile(modpath .. "/handlers/helpers.lua")
dofile(modpath .. "/handlers/nodeboxes.lua")
dofile(modpath .. "/handlers/registration.lua")

dofile(modpath .. "/src/nodes.lua")
dofile(modpath .. "/src/recipes.lua")

local subpart = {
	"chess",
	"cooking",
	"enchanting",
	"hive",
	"itemframe",
	"mailbox",
	"mechanisms",
	"rope",
	"workbench",
}

for _, name in ipairs(subpart) do
	local enable = minetest.settings:get_bool("enable_xdecor_" .. name)
	if enable or enable == nil then
		dofile(modpath .. "/src/" .. name .. ".lua")
	end
end

--print(string.format("[xdecor] loaded in %.2f ms", (os.clock()-t)*1000))

minetest.register_craftitem("xdecor:coin", {
		description = "Coin",
		inventory_image = "coin.png",
		groups = {not_in_creative_inventory = 1}
})
minetest.register_chatcommand("pay", {
	params = "<name>",
	description = "Pays a player",
	privs = {interact = true},
	func = function(name, param)
		local player = minetest.get_player_by_name(param)
		if player then
			if player:get_player_name() ~= name then
				player:get_inventory():add_item("main", "xdecor:coin")
				return true, "Player payed"
			else 
				return false, "NOPE"
			end
		end
end
})
