local creeperdef = minetest.registered_entities["mobs_mc:creeper"]
local old_os = creeperdef.on_step
local cham_texture = "mcl_chameleon_creeper_desat.png"
local update_interval = 0.5

local default_color = "#6dc475"

local colors = {
	"#9fc172",
	"#76b178",
	"#76b178",
	"#6bba6b",
	"#76b178",
	"#5cb677",
	"#5cb677",
	"#5cb677",
	"#5cb677",
	"#76b178",
	"#6dc475",
	"#23af69",
	"#5ebe6b",
	"#5ebe6b",
	"#5ebe6b",
	"#5ebe6b",
	"#9fc172",
	"#4cb054",
	"#a4966e",
	"#a4966e",
	"#a4966e",
	"#a4966e",
	"#9fc172",
	"#5db54c",
	"#5db54c",
	"#5db54c",
	"#5db54c",
	"#4c763c",
	"#5ebe6b",
}

creeperdef.on_step = function(self, dtime, moveresult)
	self._grasstimer = (self._grasstimer or update_interval) - dtime
	if self._grasstimer < 0 then
		self._grasstimer = update_interval
		local b = minetest.get_biome_data(self.object:get_pos())
		local bn = minetest.get_biome_name(b.biome)
		local bd = minetest.registered_biomes[bn]
		local new_color
		if bd._mcl_palette_index and colors[bd._mcl_palette_index] then
			new_color = colors[bd._mcl_palette_index]
		else
			new_color = default_color
		end
		if self._chameleon_color ~= new_color then
			self._chameleon_color = new_color
			self.object:set_properties({
				textures = { cham_texture.."^[multiply:"..self._chameleon_color, "mobs_mc_empty.png" }
			})
		end
	end
	return old_os(self, dtime, moveresult)
end
minetest.registered_entities["mobs_mc:creeper"] = creeperdef
