local use_node_textures = minetest.settings:get_bool("mcl_chameleon_creepers_node_textures", false)
local creeperdef = minetest.registered_entities["mobs_mc:creeper"]
local cham_texture = "mcl_chameleon_creeper_desat.png"
local update_interval = 0.5

local default_color = "#6dc475"

local colors = {
	"#9fc172",
	"#76b178",
	"#76b178",
	"#6bba6b",
	"#76b178",
	"#5cb677",
	"#5cb677",
	"#5cb677",
	"#5cb677",
	"#76b178",
	"#6dc475",
	"#23af69",
	"#5ebe6b",
	"#5ebe6b",
	"#5ebe6b",
	"#5ebe6b",
	"#9fc172",
	"#4cb054",
	"#a4966e",
	"#a4966e",
	"#a4966e",
	"#a4966e",
	"#9fc172",
	"#5db54c",
	"#5db54c",
	"#5db54c",
	"#5db54c",
	"#4c763c",
	"#5ebe6b",
}

local function get_pos_under(pos)
	for i = -1, -5, -1 do
		local p = vector.offset(pos, 0, i, 0 )
		if minetest.get_node(p).name ~= "air" then
			return p
		end
	end
end

local function get_biome_texture(pos)
	local b = minetest.get_biome_data(pos)
	local bn = minetest.get_biome_name(b.biome)
	local bd = minetest.registered_biomes[bn]
	local new_color
	if bd._mcl_palette_index and colors[bd._mcl_palette_index] then
		new_color = colors[bd._mcl_palette_index]
	else
		new_color = default_color
	end
	return cham_texture.."^[multiply:"..new_color
end

local function get_node_top_texture(pos)
	local nn = minetest.get_node(pos).name
	local color
	local def = minetest.registered_nodes[nn]
	if not def or not def.tiles then return "unknown_node.png" end
	local t = def.tiles[1]
	if type(t) == "table" and t.name then
		if t.color then
			color = t.color
		end
		t = t.name
	end
	if def.paramtype2 == "color" then
		if color then
			t = "("..t.."^[multiply:"..color..")"
		else return
		end
	end
	return t
end

local old_oa = creeperdef.on_activate
creeperdef.on_activate = function(self, staticdata, dtime_s)
	local rt = old_oa(self, staticdata, dtime_s)
	self._chameleon_texture = nil
	self._flagetimer = nil
	self.object:set_properties({
		textures = { cham_texture.."^mcl_chameleon_creeper_face.png^[multiply:"..default_color, "mobs_mc_empty.png" }
	})
end

local old_os = creeperdef.on_step
creeperdef.on_step = function(self, dtime, moveresult)
	self._flagetimer = (self._flagetimer or update_interval) - dtime
	local pos = self.object:get_pos()
	if self._flagetimer < 0 then
		self._flagetimer = update_interval
		local tex
		if use_node_textures then
			local pu = get_pos_under(pos)
			if pu then
				local t = get_node_top_texture(pu)
				if t then
					tex = "[combine:64x32:0,0=("..t..")"..
					":17,0=("..t..")"..
					":33,0=("..t..")"..
					":49,0=("..t..")"..
					":0,16=("..t..")"..
					":17,16=("..t..")"..
					":33,16=("..t..")"..
					":49,16=("..t.."):"..
					"^mcl_chameleon_creeper_face.png"
				else
					tex = get_biome_texture(pos)
				end
			else
				tex = get_biome_texture(pos)
			end
		else
			tex = get_biome_texture(pos)
		end

		if tex and tex ~= self._chameleon_texture then
			self._chameleon_texture = tex
			self.object:set_properties({
				textures = { tex, "mobs_mc_empty.png" }
			})
		end
	end
	return old_os(self, dtime, moveresult)
end
minetest.registered_entities["mobs_mc:creeper"] = creeperdef
