local S = minetest.get_translator("mcl_signs")
local F = minetest.formspec_escape

local function is_mcl2_sign(name)
	return name:find("^mcl_signs:wall_sign") or name:find("^mcl_signs:standing_sign")
end

minetest.register_on_mods_loaded(function()
	for name, node in pairs(minetest.registered_nodes) do
		if minetest.get_item_group(name, "sign") > 0 or is_mcl2_sign(name) then
			local old_rc = node.on_rightclick
			minetest.override_item(name, {
				on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
					if minetest.get_item_group(itemstack:get_name(), "dye") == 0 and not mcl_util.check_position_protection(pos, clicker) then
						local old_text = minetest.get_meta(pos):get_string("text")
						if is_mcl2_sign(name) then
							minetest.get_meta(pos):set_string("text","") --for some reason mcl2 checks if the sign is empty when processing the formspec
						end
						minetest.show_formspec(
							clicker:get_player_name(),
							"mcl_signs:set_text_" .. pos.x .. "_" .. pos.y .. "_" .. pos.z,
							"size[6,3]textarea[0.25,0.25;6,1.5;text;"..
							F(S("Enter sign text:")) .. ";"..old_text .."]label[0,1.5;" ..
							F(S("Maximum line length: 15")) .. "\n" ..
							F(S("Maximum lines: 4")) ..
							"]button_exit[0,2.5;6,1;submit;" .. F(S("Done")) .. "]"
						)
					end
					return old_rc(pos, node, clicker, itemstack, pointed_thing)
				end
			})
		end
	end
end)
