local ob_pos = vector.new(0,0,0)
mcl_oneblock = {
	mob_chance = 20,
	counters = {},
	phases = {},
	storage = minetest.get_mod_storage(),
	pr = PseudoRandom(minetest.get_mapgen_setting("seed")),
}
local end_count = 11000
local modname = minetest.get_current_modname()
local modpath = minetest.get_modpath(modname)
local S = minetest.get_translator(modname)
mcl_oneblock.phases = dofile(modpath.."/phases.lua")

minetest.set_mapgen_setting("mgname", "singlenode")

minetest.register_on_mapgen_init(function(mapgen_params)
	minetest.set_mapgen_setting("mgname", "singlenode")
	minetest.set_mapgen_params({ mgname = "singlenode" })
end)

local function save_counter(pl)
	local pn = pl:get_player_name()
	mcl_oneblock.storage:set_int(pn.."_counter", tonumber(mcl_oneblock.counters[pl]) or 0)
end

local function restore_counter(pl)
	local pn = pl:get_player_name()
	mcl_oneblock.counters[pl] = mcl_oneblock.storage:get_int(pn.."_counter")
end

local function save_counters()
	for _, pl in pairs(minetest.get_connected_players()) do
		save_counter(pl)
	end
end

local function player_get_phase(pl)
	for k,v in ipairs(mcl_oneblock.phases) do
		if mcl_oneblock.counters[pl] % end_count < v.dig_count then return k end
	end
end

minetest.register_on_joinplayer(function(player, last_login)
	local name = player:get_player_name()
	assert(name == "singleplayer", "mcl_oneblock currently only works in singleplayer")

	if not last_login then
		minetest.emerge_area(vector.offset(ob_pos, 0, -1, 0), vector.offset(ob_pos, 0, 1, 0), function(blockpos, action, calls_remaining, param)
			if calls_remaining > 0 then return end
			minetest.set_node(vector.offset(ob_pos, 0, -1, 0), {name = "mcl_core:obsidian"})
			minetest.set_node(ob_pos, {name = "mcl_core:dirt"})
			if param.player and param.player:get_pos() then
				param.player:set_pos(vector.offset(ob_pos, 0, 1, 0))
			end
		end, {player = player})
	end
	restore_counter(player)
	mcl_oneblock.phases[player] = player_get_phase(player)
	minetest.after(0, function(player)
		if player and player.get_pos and player:get_pos() then
			mcl_title.set(player, "title", {text=S("Phase @1", mcl_oneblock.phases[mcl_oneblock.phases[digger]].name), color="gold"})
			mcl_title.set(player, "subtitle", { text = "Welcome to mcl_oneblock. Keep digging! Next Phase at: "..tostring(mcl_oneblock.phases[mcl_oneblock.phases[digger]].dig_count), color="gold", stay=120})
		end
	end)
end)

minetest.register_on_leaveplayer(save_counter)

minetest.register_on_dignode(function(pos, oldnode, digger)
	if vector.equals(pos, ob_pos) then
		local items = mcl_oneblock.phases[player_get_phase(digger)].items
		local mobs = mcl_oneblock.phases[player_get_phase(digger)].mobs
		if items then
			local new_node = { name = items[mcl_oneblock.pr:next(1,#items)].itemstring }
			local new_def = minetest.registered_nodes[new_node.name]
			if new_def then
				minetest.set_node(ob_pos, new_node)
				if new_def.on_construct then
					new_def.on_construct(ob_pos)
				end
			end
		end
		if mobs and mcl_oneblock.pr:next(1, mcl_oneblock.mob_chance) == 1 then
			local new_mob = mobs[mcl_oneblock.pr:next(1,#mobs)]
			minetest.add_entity(vector.offset(ob_pos, 0, 1, 0), new_mob)
		end
		mcl_oneblock.counters[digger] = mcl_oneblock.counters[digger] + 1
		if mcl_oneblock.counters[digger] % end_count > mcl_oneblock.phases[mcl_oneblock.phases[digger]].dig_count then
			mcl_title.set(digger, "title", {text=S("Phase @1", mcl_oneblock.phases[mcl_oneblock.phases[digger]].name), color="gold"})
			mcl_oneblock.phases[digger] = player_get_phase(digger)
			mcl_title.set(digger, "subtitle", { text = "Current dig count: "..tostring(mcl_oneblock.counters[digger])..", Next Phase at: "..tostring(mcl_oneblock.phases[mcl_oneblock.phases[digger]].dig_count), color="gold", stay=120})
		end
		save_counter(digger)
	end
end)

minetest.register_chatcommand("ob_set_count", {
	privs = { debug = true },
	func = function(pn, pr)
		local pl = minetest.get_player_by_name(pn)
		if pl and tonumber(pr) then
			mcl_oneblock.counters[pl] = tonumber(pr)
			mcl_oneblock.phases[pl] = player_get_phase(pl)
			return true, "Counter set to "..tostring(pr)
		end
		return false, "Error setting count"
	end,
})
minetest.register_chatcommand("ob_status", {
	func = function(pn, _)
		local pl = minetest.get_player_by_name(pn)
		if pl then
			return true, "Current dig count: "..tostring(mcl_oneblock.counters[pl])
		end
	end,
})
minetest.register_chatcommand("ob_reset", {
	func = function(pn, _)
		local pl = minetest.get_player_by_name(pn)
		if pl then
			if minetest.get_node(ob_pos).name == "air" then
				local items = mcl_oneblock.phases[player_get_phase(digger)].items
				minetest.set_node(ob_pos, { name = items[mcl_oneblock.pr:next(1,#items)].itemstring })
				return true, "Oneblock node reset! Current dig count: "..tostring(mcl_oneblock.counters[pl])
			end
			return false, "Oneblock node still occupied."
		end
		return false, "Error resetting oneblock."
	end,
})
