local modname = minetest.get_current_modname()
local modpath = minetest.get_modpath(modname)
local S = minetest.get_translator(modname)

mcl_oneblock = {
	mob_chance = 20,
	pr = PseudoRandom(minetest.get_mapgen_setting("seed")),
	phases = dofile(modpath.."/phases.lua"),
	storage = minetest.get_mod_storage(),
	counter = 0,
}
local end_count = 11000
mcl_oneblock.counter = mcl_oneblock.storage:get_int("ob_counter")
local ob_pos = vector.new(0,0,0)

minetest.register_on_mapgen_init(function(_)
	minetest.set_mapgen_setting("mgname", "singlenode")
	minetest.set_mapgen_params({ mgname = "singlenode" })
end)

local function get_phase(pl)
	for k,v in ipairs(mcl_oneblock.phases) do
		if mcl_oneblock.counter % end_count < v.dig_count then return k end
	end
	return 1
end
local current_phase = get_phase(mcl_oneblock.counter)

local function place_oneblock()
	local items = mcl_oneblock.phases[current_phase].items
	local mobs = mcl_oneblock.phases[current_phase].mobs
	if items then
		local loot = mcl_loot.get_loot({stacks_min = 1, stacks_max = 1, items = items}, mcl_oneblock.pr)
		if loot and loot[1] then
			local new_node = { name = loot[1]:get_name() }
			local new_def = minetest.registered_nodes[new_node.name]
			if new_def then
				minetest.set_node(ob_pos, new_node)
				if new_def.on_construct then
					new_def.on_construct(ob_pos)
				end
			end
		end
	end
end

local function spawn_mob()
	local mobs = mcl_oneblock.phases[current_phase].mobs
	if mobs and mcl_oneblock.pr:next(1, mcl_oneblock.mob_chance) == 1 then
		minetest.add_entity(vector.offset(ob_pos, 0, 1, 0), mobs[mcl_oneblock.pr:next(1,#mobs)])
	end
end

local function show_phase_title_player(player)
	mcl_title.set(player, "title", {text=S("Phase @1 - @2", tostring(current_phase), mcl_oneblock.phases[current_phase].name), color="gold"})
	mcl_title.set(player, "subtitle", { text = "Current dig count: "..tostring(mcl_oneblock.counter)..", Next Phase at: "..tostring(mcl_oneblock.phases[current_phase].dig_count), color="gold", stay=120})
end

local function show_phase_title(new_phase)
	for _, player in pairs(minetest.get_connected_players()) do
		show_phase_title_player(player)
	end
end

local function progress_to_phase(new_phase)
	current_phase = new_phase
	show_phase_title()
end

local countdown_counter = 9
local countdown_active = false
local function countdown(new_phase, continue)
	if countdown_active and not continue then return end
	if countdown_counter == 9 then
		countdown_active = true
		minetest.set_node(ob_pos, {name = "mcl_core:bedrock"})
	end
	if countdown_counter < 1 then
		countdown_counter = 9
		progress_to_phase(new_phase)
		place_oneblock()
		return
	end
	local pt = {
		pos = vector.offset(ob_pos, 0, 1.4, 0),
		velocity = vector.new(0,0,0),
		acceleration = vector.new(0,-0.3,0),
		size = 2,
		expirationtime = 1.1,
		texture = "_"..countdown_counter..".png^[colorize:orange",
		collision_removal = false,
	}
	minetest.add_particle(pt)
	countdown_counter = countdown_counter - 1
	minetest.after(1, countdown, new_phase, true)
end

local function increase_count()
	mcl_oneblock.counter = mcl_oneblock.counter + 1
	local new_phase = get_phase(mcl_oneblock.counter)
	if new_phase ~= current_phase then
		countdown(new_phase)
		return false
	end
	return true
end

local function save_counter()
	mcl_oneblock.storage:set_int("ob_counter", tonumber(mcl_oneblock.counter) or 0)
end

local function update_old_count()
	local old_count = tonumber(mcl_oneblock.storage:get_int("singleplayer_counter"))
	if old_count ~= 0 then
		mcl_oneblock.counter = old_count
		save_counter()
		mcl_oneblock.storage:set_string("singleplayer_counter", "")
	end
	current_phase = get_phase(mcl_oneblock.counter)
end

minetest.register_on_joinplayer(function(player, last_login)
	if not last_login then
		if tonumber(mcl_oneblock.storage:get_int("ob_counter")) == 0 then
			minetest.emerge_area(vector.offset(ob_pos, 0, -1, 0), vector.offset(ob_pos, 0, 1, 0), function(blockpos, action, calls_remaining, param)
				if calls_remaining > 0 then return end
				minetest.set_node(vector.offset(ob_pos, 0, -1, 0), {name = "mcl_core:obsidian"})
				minetest.set_node(ob_pos, {name = "mcl_core:dirt"})
				if param.player and param.player:get_pos() then
					param.player:set_pos(vector.offset(ob_pos, 0, 1, 0))
				end
			end, {player = player})
		end
		player:set_pos(vector.offset(ob_pos, 0, 1, 0))
	else
		update_old_count()
	end
	show_phase_title_player(player)
end)

minetest.register_on_dignode(function(pos, oldnode, digger)
	if vector.equals(pos, ob_pos) then
		if increase_count() then
			place_oneblock()
			spawn_mob()
		end
		save_counter()
	end
end)

local reset_check_interval = 1
local reset_check_etime = 5
minetest.register_globalstep(function(dtime)
	reset_check_etime = reset_check_etime - dtime
	if reset_check_etime > 0 then return end
	reset_check_etime = reset_check_interval
	if minetest.get_node(ob_pos).name == "air" then
		place_oneblock()
	end
end)

minetest.register_chatcommand("ob_set_count", {
	privs = { debug = true },
	func = function(pn, pr)
		local pl = minetest.get_player_by_name(pn)
		if pl and tonumber(pr) then
			mcl_oneblock.counter = tonumber(pr)
			save_counter()
			current_phase = get_phase(mcl_oneblock.counter)
			return true, "Counter set to "..tostring(pr)
		end
		return false, "Error setting count"
	end,
})
minetest.register_chatcommand("ob_status", {
	func = function(pn, _)
		local pl = minetest.get_player_by_name(pn)
		if pl then
			return true, "Current dig count: "..tostring(mcl_oneblock.counter)..", Current Phase: "..tostring(current_phase).." "..tostring(mcl_oneblock.phases[current_phase].name)
		end
	end,
})

minetest.register_chatcommand("ob_reset", {
	func = function(pn, _)
		local pl = minetest.get_player_by_name(pn)
		if pl then
			if minetest.get_node(ob_pos).name == "air" then
				place_oneblock()
				return true, "Oneblock node reset! Current dig count: "..tostring(mcl_oneblock.counter)
			end
			return false, "Oneblock node still occupied."
		end
		return false, "Error resetting oneblock."
	end,
})
