local modname = minetest.get_current_modname()
local S = minetest.get_translator(modname)

local function LT(itemstring, weight, minstack, maxstack)
	if not minetest.registered_nodes[itemstring] then
		minetest.log("warning", "[mcl_oneblock] item "..tostring(itemstring).." does not exist")
		itemstring = "mcl_core:cobble"
	end
	return { itemstring = itemstring, weight = weight or 1, amount_min = minstack or 1, amount_max=maxstack or 1 }
end

return {
	{
		name = S("Plains"),
		dig_count = 700,
		items = {
			LT("mcl_core:podzol"),
			LT("mcl_core:mycelium"),
			LT("mcl_trees:leaves_birch", 10),
			LT("mcl_core:stone_with_iron"),
			LT("mcl_chests:chest_small"),
			--LT("mcl_beehives:bee_nest"),
			LT("mcl_trees:tree_oak", 3),
			LT("mcl_core:dirt"),
			LT("mcl_core:andesite"),
			LT("mcl_monster_eggs:monster_egg_stone"),
			LT("mcl_trees:tree_dark_oak"),
			LT("mcl_trees:leaves_oak", 20),
			LT("mcl_mushrooms:brown_mushroom_block_cap_111111"),
			LT("mcl_core:diorite"),
			LT("mcl_core:stone_with_coal"),
			LT("mcl_core:gravel"),
			LT("mcl_core:stone_with_diamond"),
			LT("mcl_core:stone_with_gold"),
			LT("mcl_core:dirt_with_grass"),
			LT("mcl_trees:leaves_cherry_blossom"),
			LT("mcl_trees:leaves_dark_oak"),
			LT("mcl_trees:tree_birch", 2),
			LT("mcl_core:cobble", 2),
			LT("mcl_core:sand"),
			LT("mcl_core:granite"),
			LT("mcl_core:coarse_dirt"),
			LT("mcl_core:stone", 2),
			LT("mcl_core:clay"),
			LT("mcl_core:stone_with_emerald"),
			LT("mcl_core:grass_path"),
		},
		mobs = {
			"mobs_mc:cow",
			"mobs_mc:spider",
			"mobs_mc:sheep",
			"mobs_mc:pig",
			"mobs_mc:villager",
			"mobs_mc:chicken",
		}
	},
	{
		name = S("Underground"),
		dig_count = 2000,
		items = {
			LT("mcl_core:stone_with_coal"),
			LT("mcl_core:gravel"),
			LT("mcl_core:stone_with_redstone"),
			LT("mcl_core:stone_with_diamond"),
			LT("mcl_core:stone_with_gold"),
			LT("mcl_core:stone_with_iron"),
			LT("mcl_chests:chest_small"),
			LT("mcl_core:cobble", 5),
			LT("mcl_core:sand"),
			LT("mcl_core:granite"),
			LT("mcl_core:cobweb"),
			LT("mcl_core:dirt"),
			LT("mcl_core:stone", 5),
			LT("mcl_core:obsidian"),
			LT("mcl_core:andesite"),
			LT("mcl_core:sandstone"),
			LT("mcl_core:stone_with_emerald"),
			LT("mcl_core:stone_with_lapis"),
			LT("mcl_core:diorite")
		},
		mobs = {
			"mobs_mc:cave_spider",
			"mobs_mc:zombie",
			"mobs_mc:skeleton",
			"mobs_mc:creeper",
			"mobs_mc:enderman",
			"mobs_mc:bat",
		}
	},
	{
		name = S("Winter"),
		dig_count = 3000,
		items = {
			LT("mcl_core:cobble"),
			LT("mcl_core:sand"),
			LT("mcl_core:dirt"),
			LT("mcl_core:stone"),
			LT("mcl_trees:leaves_spruce"),
			LT("mcl_trees:stripped_spruce"),
			LT("mcl_core:ice"),
			LT("mcl_core:stone_with_gold"),
			LT("mcl_core:stone_with_lapis"),
			LT("mcl_chests:chest_small"),
			LT("mcl_trees:tree_spruce"),
			LT("mcl_core:snowblock")
		},
		mobs = {
			"mobs_mc:cow",
			"mobs_mc:stray",
			"mobs_mc:zombie",
			"mobs_mc:spider",
			"mobs_mc:sheep",
			"mobs_mc:enderman",
			"mobs_mc:wolf",
			"mobs_mc:snowman",
			"mobs_mc:skeleton",
			"mobs_mc:polar_bear",
			"mobs_mc:pig",
			"mobs_mc:creeper",
			"mobs_mc:rabbit",
			"mobs_mc:chicken",
		},
	},
	{
		name = S("Ocean"),
		dig_count = 4000,
		items = {
			LT("mcl_ocean:brain_coral_block"),
			LT("mcl_ocean:bubble_coral_block"),
			LT("mcl_ocean:fire_coral_block"),
			LT("mcl_ocean:horn_coral_block"),
			LT("mcl_ocean:tube_coral_block"),
			LT("mcl_ocean:dead_brain_coral_block"),
			LT("mcl_ocean:dead_bubble_coral_block"),
			LT("mcl_ocean:dead_fire_coral_block"),
			LT("mcl_ocean:dead_horn_coral_block"),
			LT("mcl_ocean:dead_tube_coral_block"),
			LT("mcl_chests:chest_small"),
			LT("mcl_core:dirt"),
			LT("mcl_core:andesite"),
			LT("mcl_core:sandstone"),
			LT("mcl_sponges:sponge_wet"),
			LT("mcl_core:gravel"),
			LT("mcl_ocean:prismarine"),
			--LT("mcl_mobitems:turtle_egg")
			LT("mcl_nether:glowstone"),
			LT("mcl_core:sand"),
			LT("mcl_core:granite"),
			LT("mcl_core:stone"),
			LT("mcl_core:clay"),
			LT("mcl_sponges:sponge"),
			LT("mcl_ocean:sea_lantern"),
			LT("mcl_ocean:prismarine_dark"),
		},
		mobs = {
			"mobs_mc:cod",
			"mobs_mc:tropical_fish",
			"mobs_mc:dolphin",
			"mobs_mc:salmon",
			--"mobs_mc:turtle",
			"mobs_mc:squid",
			--"mobs_mc:drowned",
		},
	},
	{
		name = S("Jungle"),
		dig_count = 5000,
		items = {
			LT("mcl_core:podzol"),
			LT("mcl_core:stone_with_coal"),
			LT("mcl_core:mycelium"),
			LT("mcl_core:gravel"),
			LT("mcl_core:stone_with_diamond"),
			LT("mcl_farming:pumpkin"),
			LT("mcl_core:stone_with_gold"),
			LT("mcl_core:dirt_with_grass"),
			LT("mcl_trees:leaves_jungle"),
			LT("mcl_chests:chest_small"),
			LT("mcl_trees:tree_jungle"),
			LT("mcl_core:cobble"),
			LT("mcl_core:coarse_dirt"),
			LT("mcl_trees:stripped_jungle"),
			LT("mcl_core:dirt"),
			LT("mcl_core:stone"),
			LT("mcl_farming:melon"),
			LT("mcl_core:stone_with_emerald"),
			LT("mcl_core:stone_with_lapis"),
		},
		mobs = {
			"mobs_mc:witch",
			"mobs_mc:parrot",
			"mobs_mc:skeleton",
			"mobs_mc:zombie",
			"mobs_mc:ocelot",
			"mobs_mc:creeper",
			"mobs_mc:enderman",
			--"mobs_mc:panda",
			"mobs_mc_chicken",
		},
	},
	{
		name = S("Swamp"),
		dig_count = 6000,
		items = {
			LT("mcl_core:stone_with_coal"),
			LT("mcl_core:gravel"),
			LT("mcl_core:stone_with_diamond"),
			LT("mcl_core:stone_with_gold"),
			LT("mcl_chests:chest_small"),
			LT("mcl_core:cobble"),
			LT("mcl_core:coarse_dirt"),
			LT("mcl_trees:tree_oak"),
			LT("mcl_core:dirt"),
			LT("mcl_core:stone"),
			LT("mcl_trees:leaves_oak"),
			LT("mcl_core:clay"),
			LT("mcl_mud:mud"),
			LT("mcl_core:stone_with_emerald"),
			LT("mcl_core:stone_with_lapis"),
			LT("mcl_trees:leaves_cherry_mangrove"),
		},
		mobs = {
			"mobs_mc:witch",
			"mobs_mc:skeleton",
			"mobs_mc:villager_zombie",
			"mobs_mc:cat",
			"mobs_mc:slime_big",
			"mobs_mc:villager",
			"mobs_mc:evoker",
			"mobs_mc:chicken",
		},
	},
	{
		name = S("Dungeon"),
		dig_count = 7000,
		items = {
			LT("mcl_core:stone_with_coal"),
			LT("mcl_core:gravel"),
			LT("mcl_core:stone_with_redstone"),
			LT("mcl_core:stone_with_diamond"),
			LT("mcl_monster_eggs:monster_egg_cobble"),
			LT("mcl_core:stone_with_gold"),
			LT("mcl_core:stone_with_iron"),
			LT("mcl_chests:chest_small"),
			LT("mcl_core:cobble"),
			LT("mcl_trees:wood_oak"),
			LT("mcl_core:sand"),
			LT("mcl_core:granite"),
			LT("mcl_core:dirt"),
			LT("mcl_core:stone"),
			LT("mcl_core:andesite"),
			LT("mcl_monster_eggs:monster_egg_stone"),
			LT("mcl_core:sandstone"),
			LT("mcl_core:stone_with_emerald"),
			LT("mcl_mushrooms:brown_mushroom_block_cap_111111"),
			LT("mcl_core:stone_with_lapis"),
			LT("mcl_core:diorite"),
			LT("mcl_mushrooms:red_mushroom_block_cap_111111"),
			LT("mcl_core:mossycobble"),
		},
		mobs = {
			"mobs_mc:cave_spider",
			"mobs_mc:witch",
			"mobs_mc:skeleton",
			"mobs_mc:zombie",
			"mobs_mc:creeper",
			"mobs_mc:enderman",
			"mobs_mc:bat",
		},
	},
	{
		name = S("Desert"),
		dig_count = 7500,
		items = {
			LT("mcl_core:sand"),
			LT("mcl_core:stone"),
			LT("mcl_core:redsandstone"),
			LT("mcl_core:redsand"),
			LT("mcl_chests:chest_small"),
		},
		mobs = {
			"mobs_mc:spider",
			"mobs_mc:husk",
			"mobs_mc:skeleton",
			"mobs_mc:zombie",
			"mobs_mc:creeper",
			"mobs_mc:enderman",
			"mobs_mc:rabbit",
		},
	},
	{
		name = S("Nether"),
		dig_count = 8500,
		items = {
			LT("mcl_core:gravel"),
			LT("mcl_nether:quartz_ore"),
			LT("mcl_nether:netherrack"),
			LT("mcl_nether:soul_sand"),
			LT("mcl_nether:red_nether_brick"),
			LT("mcl_nether:nether_brick"),
			LT("mcl_chests:chest_small"),
			LT("mcl_nether:glowstone"),
			LT("mcl_nether:magma"),
		},
		mobs = {
			"mobs_mc:magma_cube_big",
			"mobs_mc:ghast",
			"mobs_mc:skeleton",
			"mobs_mc:zombiefied_piglin",
			"mobs_mc:enderman",
			"mobs_mc:blaze",
			"mobs_mc:witherskeleton",
		},
	},
	{
		name = S("Plenty"),
		dig_count = 9500,
		items = {
			LT("mcl_core:podzol"),
			LT("mcl_core:stone_with_redstone"),
			LT("mcl_honey:honeycomb_block"),
			LT("mcl_colorblocks:hardened_clay"),
			LT("mcl_core:stone_with_iron"),
			LT("mcl_chests:chest_small"),
			LT("mcl_core:andesite"),
			LT("mcl_trees:tree_spruce"),
			LT("mcl_trees:tree_jungle"),
			LT("mcl_trees:tree_oak"),
			LT("mcl_trees:tree_dark_oak"),
			LT("mcl_core:stone_with_lapis"),
			LT("mcl_core:stone_with_coal"),
			LT("mcl_core:stone_with_diamond"),
			LT("mcl_farming:pumpkin"),
			LT("mcl_farming:pumpkin_face_light"),
			LT("mcl_core:stone_with_gold"),
			LT("mcl_core:dirt_with_grass"),
			LT("mcl_farming:hay_block"),
			LT("mcl_core:stone"),
			LT("mcl_farming:melon"),
			LT("mcl_core:diorite"),
			LT("mcl_core:stone_with_emerald"),
			LT("mcl_core:grass_path"),
			LT("mcl_flowers:tallgrass"),
		},
		mobs = {
			"mobs_mc:cow",
			"mobs_mc:sheep",
			"mobs_mc:donkey",
			"mobs_mc:wolf",
			--"mobs_mc:fox",
			--"mobs_mc:bee",
			"mobs_mc:horse",
			"mobs_mc:pig",
			"mobs_mc:rabbit",
			"mobs_mc:chicken",
			"mobs_mc:villager",
			"mobs_mc:cat",
		},
	},
	{
		name = S("Desolation"),
		dig_count = 10500,
		items = {
			LT("mcl_core:podzol"),
			LT("mcl_core:mycelium"),
			LT("mcl_trees:wood_oak"),
			LT("mcl_trees:tree_oak"),
			LT("mcl_trees:tree_spruce"),
			LT("mcl_chests:chest_small"),
			LT("mcl_core:stonebrick"),
			LT("mcl_core:stonebrickmossy"),
			LT("mcl_core:stonebrickcarved"),
			LT("mcl_core:stonebrickcracked"),
			LT("mcl_colorblocks:hardened_clay"),
			LT("mcl_anvils:anvil_damage_2"),
			LT("mcl_monster_eggs:monster_egg_stone"),
			LT("mcl_monster_eggs:monster_egg_cobble"),
			LT("mcl_monster_eggs:monster_egg_stonebrick"),
			LT("mcl_monster_eggs:monster_egg_stonebrickcarved"),
			LT("mcl_monster_eggs:monster_egg_stonebrickcracked"),
			LT("mcl_monster_eggs:monster_egg_stonebrickmossy"),
			LT("mcl_deepslate:infested_deepslate"),
			LT("mcl_ocean:dead_brain_coral_block"),
			LT("mcl_ocean:dead_bubble_coral_block"),
			LT("mcl_ocean:dead_fire_coral_block"),
			LT("mcl_ocean:dead_horn_coral_block"),
			LT("mcl_ocean:dead_tube_coral_block"),
			LT("mcl_core:obsidian"),
			LT("mcl_core:andesite"),
			LT("mcl_colorblocks:concrete_black"),
			LT("mcl_core:diorite"),
			LT("mcl_core:gravel"),
			LT("mcl_core:cobble"),
			LT("mcl_core:granite"),
			LT("mcl_core:coarse_dirt"),
			LT("mcl_core:stone"),
			LT("mcl_trees:tree_dark_oak"),
			LT("mcl_core:glass_black"),
			LT("mcl_core:bone_block"),
			LT("mcl_core:mossycobble"),
			LT("mcl_colorblocks:concrete_grey"),
		},
		mobs = {
			"mobs_mc:cave_spider",
			"mobs_mc:pillager",
			"mobs_mc:skeleton",
			"mobs_mc:vex",
			--"mobs_mc:ravager",
			--"mobs_mc:bee",
			"mobs_mc:illusioner",
			"mobs_mc:creeper",
			"mobs_mc:zombie_horse",
			"mobs_mc:evoker",
			"mobs_mc:endermite",
			"mobs_mc:witherskeleton",
		},
	},
	{
		name = S("The End"),
		dig_count = 11000,
		items = {
			LT("mcl_end:purpur_pillar"),
			LT("mcl_end:purpur_block"),
			LT("mcl_end:end_bricks"),
			LT("mcl_wool:purple"),
			LT("mcl_core:obsidian"),
			LT("mcl_end:end_stone"),
			LT("mcl_chests:chest_small"),
			LT("mcl_colorblocks:hardened_clay"),

		},
		mobs = {
			"mobs_mc:enderman",
			"mobs_mc:shulker",
		},
	},

}
