local chulen = 80
local ch = chulen / 2

local c_stone = minetest.get_content_id("mcl_core:stone")
local c_water = minetest.get_content_id("mcl_core:water_source")
local start_loot = mcl_bonus_chest.bonus_loot

mcl_mapgen_core.register_generator("stoneblock", function(vm, data, data2, emin, emax, area, minp, maxp, blockseed)
	if not (minp.y <= mcl_vars.mg_overworld_max and maxp.y >= mcl_vars.mg_overworld_min) then return end
	local ni = 1
	for z = minp.z, maxp.z do
	for y = minp.y, maxp.y do
	for x = minp.x, maxp.x do
		local vi = area:index(x, y, z)
		if data[vi] == minetest.CONTENT_AIR or data[vi] == c_water then
			data [vi] = c_stone
		end
		ni = ni + 1
	end
	end
	end
	if minetest.generate_ores then
		minetest.generate_ores(vm, minp, maxp)
		--minetest.generate_decorations(vm, minp, maxp)
	end
	return true
end)

minetest.register_on_joinplayer(function(player, last_login)
	if last_login == nil then
		local pr = PseudoRandom(os.time())
		local spos = vector.new(pr:next(-64, 64),pr:next(-64, 64),pr:next(-64,64))
		local air = {}
		for x=-5,5 do
		for y=0,5 do
		for z=-5,5 do
			table.insert(air, vector.offset(spos,x,y,z))
		end
		end
		end
		minetest.emerge_area(vector.offset(spos, -5, 0, -5), vector.offset(spos, 5, 5, 5), function(blockpos, action, calls_remaining, param)
			if calls_remaining > 0 then return end
			if param.player and param.player:get_pos() then
				minetest.bulk_set_node(param.air, {name = "air"})
				mcl_bonus_chest.place_chest(vector.offset(spos,0,0,1), start_loot, pr)
				player:set_pos(spos)
			end
		end, {player = player, air = air})
	end
end)
