mcla_music_api.register_song({
	name = "Bernhard_Romberg_-_Flute_Quintet_in_G_Major_-_Minuet",
	title = "Bernhard Romberg - Flute Quintet in G Major (European Archive)",
	ymin = (mcl_vars and mcl_vars.mg_overworld_min) or -10,
	length = 256
})
mcla_music_api.register_song({
	name = "Jaan_Patterson_-_06_-_Toccata_and_Fugue_Johann_Sebastian_Bach",
	title = "J.S. Bach - Toccata and Fugue performed by Jaan Patterson",
	ymin = (mcl_vars and mcl_vars.mg_nether_min) or -31000,
	ymax = (mcl_vars and mcl_vars.mg_nether_max) or -1024,
	length = 534
})
mcla_music_api.register_song({
	name = "John_Harrison_with_the_Wichita_State_University_Chamber_Players_-_03_-_Spring_Mvt_3_Allegro_pastorale",
	title = "Antonio Vivaldi - Spring Mvt. 3 Allegro pastorale performed by John Harrison with the Wichita State University Chamber Players",
	ymin = (mcl_vars and mcl_vars.mg_overworld_min) or -10,
	length = 254
})
mcla_music_api.register_song({
	name = "Kevin_MacLeod_-_Canon_in_D_Major",
	title = "Johann Pachelbel - Canon in D Major performed by Kevin MacLeod",
	length = 355,
	ymin = (mcl_vars and mcl_vars.mg_overworld_min) or -64,
	ymax = -10,
})
mcla_music_api.register_song({
	name = "Kevin_MacLeod_-_Danse_Macabre",
	title = "Camille Saint Saens - Danse Macabre performed by Kevin MacLeod",
	ymin = (mcl_vars and mcl_vars.mg_nether_min) or -31000,
	ymax = (mcl_vars and mcl_vars.mg_nether_max) or -1024,
	length = 406
})
mcla_music_api.register_song({
	name = "Kevin_MacLeod_-_Prelude_in_C_-_BWV_846",
	title = "J.S. Bach Prelude in C Major (BWV 846) performed by Kevin MacLeod",
	ymin = (mcl_vars and mcl_vars.overworld_min) or -10,
	length = 178
})
mcla_music_api.register_song({
	name = "Kevin_MacLeod_-_The_Endless",
	title = "Kevin_MacLeod - The_Endless",
	length = 210,
	ymin = (mcl_vars and mcl_vars.mg_end_min) or -31000,
	ymax = (mcl_vars and mcl_vars.mg_end_max) or -1024,
})
mcla_music_api.register_song({
	name = "badinerie",
	title = "J.S. Bach - Suite °2 in B Minor - Badinerie (European Archive)",
	ymin = (mcl_vars and mcl_vars.mg_overworld_min) or -10,
	length = 83
})
mcla_music_api.register_song({
	name = "bouree",
	title = "J.S. Bach - Suite °2 in E Minor - Bouree (European Archive)",
	ymin = (mcl_vars and mcl_vars.mg_overworld_min) or -10,
	length = 96
})
mcla_music_api.register_song({
	name = "The_Good_China_-_14_-_From_the_New_World_Theme_from_Dvoraks_9th_Symphony",
	title = "The Good China - From the New World (Theme from Dvorak's 9th Symphony)",
	ymin = (mcl_vars and mcl_vars.mg_end_min) or -31000,
	ymax = (mcl_vars and mcl_vars.mg_overworld_max) or 31000,
	length = 141
})

mcla_music_api.register_song({
	name = "Chopin_-_Nocturne-op-55-no-1",
	title = "Frederic Chopin - Nocturne Op 55 no. 1 - Performed by Luke Faulkner",
	length = 316,
})


local startsong = {
	name = "Ivan_Ilic_Chopin_Prelude_Opus_28_no_4",
	title = "Ivan Ilić - Chopin: Prelude op. 28",
	length = 109,
	ymin = (mcl_vars and mcl_vars.mg_overworld_min) or -10,
}
mcla_music_api.register_song(startsong)

local endsong = {
	name = "The_Good_China_-_42_-_The_End_Chopin_Prelude_4",
	title = "The Good China - The End (Chopin Prelude #4)",
	length = 99,
	hidden = minetest.global_exists("mcl_inventory"),
	ymax = minetest.global_exists("mcl_inventory") and -31000, --endsong, never play regularly
}
mcla_music_api.register_song(endsong)

minetest.register_on_joinplayer(function(player, last)
	if not last then
		minetest.after(1, function(player)
			if player and player:get_pos() then
				mcla_music_api.play_song(player, startsong)
			end
		end, player)
	end
end)

if minetest.global_exists("mcl_portals") then
	if mcl_portals.register_on_beat_game then
		mcl_portals.register_on_beat_game(function(player)
			minetest.after(1, function(player)
				if player and player:get_pos() then
					mcla_music_api.play_song(player, endsong)
				end
			end, player)
		end)
	end
end
