openai_api = {}
local http_api = core.request_http_api()
assert(http_api, "The openai_api mod needs access to the HTTP API by it's nature. Please add openai_api to secure.http_mods")

local api_base = tostring(core.settings:get("openai_api_url")) or "https://api.openai.com/v1"
local api_key = tostring(core.settings:get("openai_api_key"))
local system_prompt = tostring(core.settings:get("openai_api_system_prompt")) or "You are a very cute assistant that ends all messages with <3"

local headers = { "Accept-Charset: utf-8" }

if api_key then
	table.insert(headers, "Authorization: Bearer "..api_key)
end

local function make_oa_request(prompt)
	local req = prompt
	if type(req) == "string" then
		req = {
			messages = {
				{role = "system", content = system_prompt },
				{role = "user", content = prompt }
			},
			--model = "gpt-3.5-turbo", -- this is the default model
			temperature = 0.5
		}
	end
	return req
end

local function make_request(prompt)
	local req = {
		url = api_base.."/chat/completions",
		timeout = 100,
		method = "POST",
		data = core.write_json(make_oa_request(prompt)),
		user_agent = "Luanti/openai_api",
		extra_headers = headers,
		multipart = false,
	}
	return req
end

function openai_api.send_request(req, callback, callback_error)
	http_api.fetch(make_request(req), function(res)
		if res.code == 200 then
			return callback(core.parse_json(res.data))
		end
		return callback_error and callback_error(res)
	end)
end

core.register_chatcommand("openai_test", {
	privs = { server = true },
	func = function(pn, pr)
		core.chat_send_player(pn, "> " .. pr)
		openai_api.send_request(tostring(pr), function(answer)
			core.chat_send_player(pn, tostring(answer.choices[1].message.content))
		end, function(res)
			core.chat_send_player(pn, "openai request failed: "..tostring(res.data))
		end)
	end
})
