# openai_api
This is a simple mod for making requests to the openai API which is supported by most AI providers and local AI systems.

To use this mod, you'll need to add it to the secure.http_mods setting as it relies on making external HTTP requests.

## Usage
### Settings
You'll need to configure your API URL, API Key (if needed) and system prompt in the settings section for this mod.

### Chatcommand
A simple chatcommand /openai_test is included to send questions to the API using the configured system prompt.

Just try /openai_test Tell me a joke

### API usage

Basic usage of the API is as follows:
```lua
openai_api.send_request(request, callback, callback_error)
```

`request` can be either:
* A simple string representing your question to the AI, in this case the configured system prompt and default values will be used
* A table representing the openai request object e.g.
```lua
{
    messages = {
        {role = "system", content = "You are a Lua programmer" },
        {role = "user", content = "Write a Lua program that can calculate PI to arbitrary precision." }
    },
    model = "gpt-3.5-turbo", -- this is the default model
    temperature = 0.5
}
```

`callback_error`: if the request was not successful this is called with the HTTPAPI response as argument

`callback`: if the request was successful this is called with the openai response object as argument e.g.
```lua
{
choices = {
    {
        finish_reason = "stop",
        index = 0,
        message = {
            role = "assistant",
            content = "
                -- This is a simple Lua program that prints \"Hello, world!\" to the console.\
                print(\"Hello, world!\")"
        },
    },
    created = 12345,
    id = "xxxxx",
    model = "gpt-3.5-turbo",
    object = "chat.completion",
    system_fingerprint = "xxxxxxxx",
    timings = {
    --...
    },
    usage = {
    --...
    },
}

```
