
--- Registered armors.
--
--  @topic armor


-- support for i18n
local S = minetest.get_translator(minetest.get_current_modname())

--- Steel
--
--  Requires setting `armor_material_steel`.
--
--  @section steel

--[[
if armor.materials.steel then
	--- Steel Helmet
	--
	--  @helmet 3d_armor:helmet_steel
	--  @img 3d_armor_inv_helmet_steel.png
	--  @grp armor_head 1
	--  @grp armor_heal 0
	--  @grp armor_use 800
	--  @grp physics_speed -0.01
	--  @grp physica_gravity 0.01
	--  @armorgrp fleshy 10
	--  @damagegrp cracky 2
	--  @damagegrp snappy 3
	--  @damagegrp choppy 2
	--  @damagegrp crumbly 1
	--  @damagegrp level 2
	armor:register_armor(":3d_armor:helmet_steel", {
		description = S("Steel Helmet"),
		inventory_image = "3d_armor_inv_helmet_steel.png",
		groups = {armor_head=1, armor_heal=0, armor_use=800,
			physics_speed=-0.01, physics_gravity=0.01},
		armor_groups = {fleshy=10},
		damage_groups = {cracky=2, snappy=3, choppy=2, crumbly=1, level=2},
	})
	--- Steel Chestplate
	--
	--  @chestplate 3d_armor:chestplate_steel
	--  @img 3d_armor_inv_chestplate_steel.png
	--  @grp armor_torso 1
	--  @grp armor_heal 0
	--  @grp armor_use 800
	--  @grp physics_speed
	--  @grp physics_gravity
	--  @armorgrp fleshy
	--  @damagegrp cracky 2
	--  @damagegrp snappy 3
	--  @damagegrp choppy 2
	--  @damagegrp crumbly 1
	--  @damagegrp level 2
	armor:register_armor(":3d_armor:chestplate_steel", {
		description = S("Steel Chestplate"),
		inventory_image = "3d_armor_inv_chestplate_steel.png",
		groups = {armor_torso=1, armor_heal=0, armor_use=800,
			physics_speed=-0.04, physics_gravity=0.04},
		armor_groups = {fleshy=15},
		damage_groups = {cracky=2, snappy=3, choppy=2, crumbly=1, level=2},
	})
	--- Steel Leggings
	--
	--  @leggings 3d_armor:leggings_steel
	--  @img 3d_armor_inv_leggings_steel.png
	--  @grp armor_legs 1
	--  @grp armor_heal 0
	--  @grp armor_use 800
	--  @grp physics_speed -0.03
	--  @grp physics_gravity 0.03
	--  @armorgrp fleshy 15
	--  @damagegrp cracky 2
	--  @damagegrp snappy 3
	--  @damagegrp choppy 2
	--  @damagegrp crumbly 1
	--  @damagegrp level 2
	armor:register_armor(":3d_armor:leggings_steel", {
		description = S("Steel Leggings"),
		inventory_image = "3d_armor_inv_leggings_steel.png",
		groups = {armor_legs=1, armor_heal=0, armor_use=800,
			physics_speed=-0.03, physics_gravity=0.03},
		armor_groups = {fleshy=15},
		damage_groups = {cracky=2, snappy=3, choppy=2, crumbly=1, level=2},
	})
	--- Steel Boots
	--
	--  @boots 3d_armor:boots_steel
	--  @img 3d_armor_inv_boots_steel.png
	--  @grp armor_feet 1
	--  @grp armor_heal 0
	--  @grp armor_use 800
	--  @grp physics_speed -0.01
	--  @grp physics_gravity 0.01
	--  @armorgrp fleshy 10
	--  @damagegrp cracky 2
	--  @damagegrp snappy 3
	--  @damagegrp choppy 2
	--  @damagegrp crumbly 1
	--  @damagegrp level 2
	armor:register_armor(":3d_armor:boots_steel", {
		description = S("Steel Boots"),
		inventory_image = "3d_armor_inv_boots_steel.png",
		groups = {armor_feet=1, armor_heal=0, armor_use=800,
			physics_speed=-0.01, physics_gravity=0.01},
		armor_groups = {fleshy=10},
		damage_groups = {cracky=2, snappy=3, choppy=2, crumbly=1, level=2},
	})

	--- Crafting
	--
	--  @section craft

	--- Craft recipes for helmets, chestplates, leggings, boots, & shields.
	--
	--  @craft armor
	--  @usage
	--  Key:
	--  - m: material
	--    - wood:    group:wood
	--    - cactus:  default:cactus
	--    - steel:   default:steel_ingot
	--    - bronze:  default:bronze_ingot
	--    - diamond: default:diamond
	--    - gold:    default:gold_ingot
	--    - mithril: moreores:mithril_ingot
	--    - crystal: ethereal:crystal_ingot
	--    - nether:  nether:nether_ingot
	--
	--  helmet:        chestplate:    leggings:
	--  ┌───┬───┬───┐  ┌───┬───┬───┐  ┌───┬───┬───┐
	--  │ m │ m │ m │  │ m │   │ m │  │ m │ m │ m │
	--  ├───┼───┼───┤  ├───┼───┼───┤  ├───┼───┼───┤
	--  │ m │   │ m │  │ m │ m │ m │  │ m │   │ m │
	--  ├───┼───┼───┤  ├───┼───┼───┤  ├───┼───┼───┤
	--  │   │   │   │  │ m │ m │ m │  │ m │   │ m │
	--  └───┴───┴───┘  └───┴───┴───┘  └───┴───┴───┘
	--
	--  boots:         shield:
	--  ┌───┬───┬───┐  ┌───┬───┬───┐
	--  │   │   │   │  │ m │ m │ m │
	--  ├───┼───┼───┤  ├───┼───┼───┤
	--  │ m │   │ m │  │ m │ m │ m │
	--  ├───┼───┼───┤  ├───┼───┼───┤
	--  │ m │   │ m │  │   │ m │   │
	--  └───┴───┴───┘  └───┴───┴───┘

	local s = "steel"
	local m = armor.materials.steel
	minetest.register_craft({
		output = "3d_armor:helmet_"..s,
		recipe = {
			{m, m, m},
			{m, "", m},
			{"", "", ""},
		},
	})
	minetest.register_craft({
		output = "3d_armor:chestplate_"..s,
		recipe = {
			{m, "", m},
			{m, m, m},
			{m, m, m},
		},
	})
	minetest.register_craft({
		output = "3d_armor:leggings_"..s,
		recipe = {
			{m, m, m},
			{m, "", m},
			{m, "", m},
		},
	})
	minetest.register_craft({
		output = "3d_armor:boots_"..s,
		recipe = {
			{m, "", m},
			{m, "", m},
		},
	})
end

]]



-- Full sets

armor:register_armor(":armor_addons:helmet_aviator", {
	description = S("Aviator cap"),
	inventory_image = "armor_addons_inv_helmet_aviator.png",
	groups = {armor_head=1, armor_heal=0, armor_use=500},
	armor_groups = {fleshy=5, fall_damage_add_percent = 25,},
	damage_groups = {cracky=2, snappy=2, choppy=3, crumbly=1, level=2},
})

armor:register_armor(":armor_addons:chestplate_aviator", {
	description = S("Aviator Jacket"),
	inventory_image = "armor_addons_inv_chestplate_aviator.png",
	groups = {armor_torso=1, armor_heal=0, armor_use=500},
	armor_groups = {fleshy=12, fall_damage_add_percent = 25,},
	damage_groups = {cracky=1, snappy=1, choppy=2, level=2},
})

armor:register_armor(":armor_addons:helmet_conductor", {
	description = S("Conductor cap"),
	inventory_image = "armor_addons_inv_helmet_conductor.png",
	groups = {armor_head=1, armor_heal=0, armor_use=500},
	armor_groups = {fleshy=5},
	damage_groups = {cracky=2, snappy=2, choppy=3, crumbly=1, level=2},
})

armor:register_armor(":armor_addons:chestplate_conductor", {
	description = S("Conductor Vest"),
	inventory_image = "armor_addons_inv_chestplate_conductor.png",
	groups = {armor_torso=1, armor_heal=0, armor_use=500},
	armor_groups = {fleshy=12},
	damage_groups = {cracky=1, snappy=1, choppy=2, level=2},
})

armor:register_armor(":armor_addons:chestplate_mesetech", {
	description = S("Mese Tech Chestplate"),
	inventory_image = "armor_addons_inv_chestplate_mesetech.png",
	groups = {armor_torso=1, armor_heal=0, armor_use=300},
	armor_groups = {fleshy=18},
	damage_groups = {cracky=2, snappy=1, choppy=1, level=3},
})

armor:register_armor(":armor_addons:leggings_mesetech", {
	description = S("Mese Tech Leggings"),
	inventory_image = "armor_addons_inv_leggings_mesetech.png",
	groups = {armor_legs=1, armor_heal=0, armor_use=300},
	armor_groups = {fleshy=18},
	damage_groups = {cracky=2, snappy=1, choppy=1, level=3},
})



-- Individuals

armor:register_armor(":armor_addons:chestplate_adventure", {
	description = S("Blue Adventurer Tunic"),
	inventory_image = "armor_addons_inv_chestplate_adventure.png",
	groups = {armor_torso=1, armor_heal=8, armor_use=600},
	armor_groups = {fleshy=15},
	damage_groups = {cracky=2, snappy=1, choppy=2, level=3},
})

armor:register_armor(":armor_addons:chestplate_adventure2", {
	description = S("Green Adventurer Tunic"),
	inventory_image = "armor_addons_inv_chestplate_adventure2.png",
	groups = {armor_torso=1, armor_heal=8, armor_use=600},
	armor_groups = {fleshy=15},
	damage_groups = {cracky=2, snappy=1, choppy=2, level=3},
})

armor:register_armor(":armor_addons:leggings_bluejeans", {
	description = S("Blue Jeans"),
	inventory_image = "armor_addons_inv_leggings_bluejeans.png",
	groups = {armor_legs=1, armor_heal=0, armor_use=500,
		physics_speed=-0.03, physics_gravity=0.03},
	armor_groups = {fleshy=10},
	damage_groups = {cracky=2, snappy=3, choppy=2, crumbly=1, level=2},
})

armor:register_armor(":armor_addons:boots_joggers", {
	description = S("Sneakers"),
	inventory_image = "armor_addons_inv_boots_joggers.png",
	groups = {armor_feet=1, armor_heal=0, armor_use=500,
		physics_speed=0.5},
	armor_groups = {fleshy=3},
	damage_groups = {cracky=1, snappy=1, choppy=1, crumbly=1, level=1},
})

armor:register_armor(":armor_addons:gloves",{
  description = "Leather Gloves",
  inventory_image = "armor_addons_inv_gloves.png",
  groups = {
    armor_accessory = 1,
    armor_heal = 0,
    armor_use = 300,
  },
  armor_groups = {fleshy=3},
  damage_groups = {choppy=1, level=1},
})







-- Full sets

core.register_craft({
	output = "armor_addons:helmet_aviator",
	recipe = {
		{"xpanes:pane_flat", "animalia:leather", "xpanes:pane_flat"},
		{"animalia:leather", "", "animalia:leather"},
	},
})

core.register_craft({
	output = "armor_addons:chestplate_aviator",
	recipe = {
		{"wool:white", "", "wool:white"},
		{"animalia:leather", "animalia:leather", "default:bronze_ingot"},
		{"animalia:leather", "animalia:leather", "animalia:leather"},
	},
})

core.register_craft({
	output = "armor_addons:helmet_conductor",
	recipe = {
		{"wool:blue", "default:gold_ingot", "wool:blue"},
		{"wool:blue", "", "wool:blue"},
	},
})

core.register_craft({
	output = "armor_addons:chestplate_conductor",
	recipe = {
		{"wool:blue", "", "wool:blue"},
		{"wool:blue", "default:gold_ingot", "wool:blue"},
		{"wool:blue", "default:gold_ingot", "wool:blue"},
	},
})

core.register_craft({
	output = "armor_addons:chestplate_mesetech",
	recipe = {
		{"default:mese_crystal", "", "default:mese_crystal"},
		{"default:coal_lump", "default:mese_crystal", "default:coal_lump"},
		{"default:mese_crystal", "default:coal_lump", "default:mese_crystal"},
	},
})

core.register_craft({
	output = "armor_addons:leggings_mesetech",
	recipe = {
		{"default:mese_crystal", "default:coal_lump", "default:mese_crystal"},
		{"default:coal_lump", "", "default:coal_lump"},
		{"default:mese_crystal", "", "default:mese_crystal"},
	},
})


-- Individuals

core.register_craft({
	output = "armor_addons:chestplate_adventure",
	recipe = {
		{"default:diamond", "", "default:diamond"},
		{"default:diamond", "animalia:leather", "default:diamond"},
		{"animalia:leather", "default:gold_ingot", "animalia:leather"},
	},
})

core.register_craft({
	output = "armor_addons:chestplate_adventure2",
	recipe = {
		{"too_many_stones:vivianite_crystal", "", "too_many_stones:vivianite_crystal"},
		{"too_many_stones:vivianite_crystal", "animalia:leather", "too_many_stones:vivianite_crystal"},
		{"animalia:leather", "default:gold_ingot", "animalia:leather"},
	},
})

core.register_craft({
	output = "armor_addons:leggings_bluejeans",
	recipe = {
		{"wool:blue", "default:gold_ingot", "wool:blue"},
		{"wool:blue", "", "wool:blue"},
		{"wool:blue", "", "wool:blue"},
	},
})

core.register_craft({
	output = "armor_addons:boots_joggers",
	recipe = {
		{"farming:string", "", "farming:string"},
		{"default:snowblock", "", "default:snowblock"},
	},
})

core.register_craft({
	output = "armor_addons:gloves",
	recipe = {
		{"animalia:leather", "", "animalia:leather"},
	},
})




