
local S = core.get_translator(core.get_current_modname())
local mod = core.get_modpath("mcl_travelpack")

dofile(mod .. "/crafting.lua")

core.register_craftitem("mcl_travelpack:basicpack", {
	description = S("Travellers Pack"),
	_doc_items_longdesc = S("Create a traveller's pack by crafting a bed and crafting table with leather. Use this for maximising your inventory capacity while travelling long distances. Items can easily be unpacked and packed again in your crafting grid"),
    _tt_help = S("Carrying a chest as well is recommended"),
	inventory_image = "mcl_travelpack_basicpack.png",
	groups = {tool=1},
	stack_max = 1,
})
core.register_craftitem("mcl_travelpack:basicpack_1", {
	description = S("Travellers Pack (unpacked)"),
    _tt_help = S("Carrying a chest as well is recommended"),
	inventory_image = "mcl_travelpack_basicpack1.png",
	groups = {tool=1, not_in_creative_inventory=1},
	stack_max = 1,
})
core.register_craftitem("mcl_travelpack:cookpack", {
	description = S("Travellers Cooking Pack"),
	_doc_items_longdesc = S("Create a traveller's pack by crafting a bed, crafting table and smoker with leather. Use this for maximising your inventory capacity while travelling long distances. Items can easily be unpacked and packed again in your crafting grid (add the crafting table afterwards)"),
    _tt_help = S("Carrying a chest as well is recommended"),
	inventory_image = "mcl_travelpack_cookpack.png",
	groups = {tool=1},
	stack_max = 1,
})
core.register_craftitem("mcl_travelpack:cookpack_1", {
	description = S("Travellers Cooking Pack (unpacked)"),
    _tt_help = S("Carrying a chest as well is recommended"),
	inventory_image = "mcl_travelpack_cookpack1.png",
	groups = {tool=1, not_in_creative_inventory=1},
	stack_max = 1,
})
core.register_craftitem("mcl_travelpack:cookpack_2", {
	description = S("Travellers Cooking Pack (unpacked)"),
    _tt_help = S("Carrying a chest as well is recommended"),
	inventory_image = "mcl_travelpack_cookpack2.png",
	groups = {tool=1, not_in_creative_inventory=1},
	stack_max = 1,
})

