Mogue created by covertiii.

A game for luanti

## About

Hello adventurer!  Welcome to Mogue, a Brogue-like realtime dungeon crawler built in Luanti.  You're on a quest to retrieve the Crystal of Yendor, rumored to be somewhere in depth 12 of the dungeons.  Bring it back up to the surface, place it on the pedestal and your name will forever be remembered.  Along the way, try to collect as much gold as possible to show off to future explorers of the dungeon.  But beware! The dungeon and its inhabitants do not take kindly to intruders. There will be traps you must avoid and monsters to sneak around, to fight, or to run away from.  If you die on your quest, you will lose any items you find, your stats will reset, and you'll need to start again at the top.  The dungeon itself will change its shape, and you will need to explore it anew.  But do not despair, as you explore the dungeon, there will be many chests containing items to help you on your way to retrieve the fabled crystal.

## Items

In the chests you will find weapons, armor, staves, wands, charms, rings, potions, and scrolls.  There are three very important items you especially need to be on the look out for: potions of life, potions of strength and scrolls of enchanting.  

  - The potion of life will permanently update your max health and fill it to the top.  
  - The potion of strength will make you stronger.  You will be able to wield heavy weapons more effectively and wear heavier armor to your advantage.
  - The scroll of enchantment can be used to permanently upgrade weapons, armor, staves, wands, charms or rings.  You pick what you want to upgrade.

### Weapons

Weapons are used to hit monsters.  Some weapons will do more damage than others, but those weapons will require you to be stronger to use.  If you do use them without the required strength, you may find your hits missing monsters more often than not.  You can lower the strength requirement of a weapon by enchanting it.  Pay attention to the messages the game sends you when you first wield a weapon, it'll tell the strength requirement of the weapon.  If you spam the weapon and don't wait for the weapon to reset, you will miss monsters more often than not as well.  Some weapons have a longer hit range.  These are useful so you don't have to get up so close to the monsters to fight them.  Weapons spawn in the dungeon with positive, negative or no enchantments.  These are hidden from you.  You can identify what they are by either killing 20 monsters with the weapon or using a scroll of identification on the weapon.  Watch out for monsters that will degrade your weapons if you hit them.  A scroll of protect weapon will protect your weapon from this fate.

### Armor

Good armor reduces the chance that a monster will hit you.  Higher armor class (AC) is better.  Heavier armor requires more strength.  You can also lower the strength requirement of armor by enchanting it.  Better protection comes at a cost; It makes you more noisy and increases the range at which monsters notice you (this is your stealth stat).  These will also spawn in the dungeon with positive, negative or no enchantments.  These will be hidden as well.  If you wear your armor for 500 seconds or more, you will become familiar with it and know what it's intrinsic enchantments are.  There are monsters that can degrade your armor if they hit you.  A scroll of protect armor will protect your armor from this fate.

### Staves

Staves are powerful magical items that shoot magical bolts.  There is a staff of fire that will shoot bolts of fire, catch terrain on fire, and catch the monster it hits on fire as well.  There is a staff of blinking that will teleport you to where the bolt goes.  Staves start with 2-5 charges and recharge over time.  Enchanting a staff will increase it's maximum charges, increase the effect of the bolt, increase the range of the staff and decrease the time it takes to recharge.  For example, a bolt of fire will go further, do more damage when it hits and burn enemies longer the more it's enchanted.  The staff of blinking will have a longer ranger.  There are other types of staves that have different effects to be found in the dungeons.

### Wands

At the moment, there's only 2 wands to be found in the dungeons.  A wand of polymorph and a wand of teleportation.  A wand starts with 2-5 charges and does not recharge over time.  Extra charges can be added by enchanting the wand.  Some people question the wisdom in doing this through.  A wand of teleportation will teleport any creature it hits to a random place in the depth of the current dungeon you are on.  A wand of polymorph will change one monster into a different type of monster.  It's best not to use a wand of polymorph on a rat, cat or wolf.

### Charms

Charms are like staves in which they are rechargeable, but they only have one charge and they effect you in different ways instead of shooting to effect a monster.  For example, a charm of health will heal you for a percentage of your health.  A charm of protection will put a magical shield around you that monsters need to break through before they start getting at your health.  A charm of teleport can be used for a quick escape and teleport you to a random place in the level.  A charm of shattering will turn the walls around you into crystal that will then dissipate when touching air.  Enchanting a charm will increase the duration and potency of its magical effect and decrease the time it takes to recharge. 

### Rings

Rings increase some internal effect on the player.  Wearing a ring of regeneration will increase the players regeneration allowing them to heal more quickly.  Wearing a ring of stealth will decrease the range at which monsters notice the player. Wearing a ring of wisdom will decrease the time it takes all your staves to recharge.  Wearing a ring of transference will heal you a percentage of the damage that you deal to monsters.  Wearing a ring of reaping will decrease the time to recharge a stave each time you hit a monster.  Enchanting the ring will increase the potency of its effect.  Only one ring can be worn at a time.  Rings can spawn with positive or negative enchantments.  Negative enchantments will make worsen the effect of the ring.  For example a negative ring of regeneration will slow the regeneration time even more than wearing no ring.  Rings can be identified by wearing them for more than 500 seconds or by using a scroll of identity.

### Scrolls

Scrolls are one time use items that have some magical effect.  There are scrolls of enchantment, identity, protect armor, protect weapon, shattering, and teleport.  Since they are one time use, they cannot be enchanted.

### Potions

There are two type of potions - those that can be thrown and those that can be drunk.  Throwable potions will have some negative impact on when thrown.  A potion of descent will open up the current depth and drop monsters down to the next depth, then close back up.  A potion of incineration will explode in a giant ball of fire.  There are more to find and try out.  Drinkable potions include the potions life, strength, invisibility, haste, and levitation.  There are others as well.  Since these are one time use, they cannot be enchanted.


## Player Stats

At the bottom of the screen you can see your character's stats.  There's Satiation, Health, Stealth, AC, Str, Depth, Dmg, Acc and Breath.  

### Satiation

This is how hungry you are.  Eating ration of food will increase your satiation by 20 points and an apple 10.  Once your satiation is 2 or below, you start losing health points.  

### Health

This is how much health you have.  When monsters successfully hit you, your health goes down.  When you health is 0 your character is dead and you need to restart your quest with a new character.

### Stealth

Monster need to be in the radius of your stealth range to have a chance to notice you.  Each second monsters are within your stealth range, they have a 49 percent chance to notice you.  If you hit a monster, they'll notice you right away and attack you.  Not moving will cut your stealth range in half.  Heavier armor will increase your stealth range.  A ring of stealth will reduce you stealth range.  When you are invisible your stealth range is 1.  If you are not invisible the lowest your stealth range can be is 2. 

### AC

This is your armor class.  Higher is better.  A higher armor class will reduce the chance that a monster will land a hit on you.  This stat is effected by the current armor you are wearing.

### Str

This is your strength.  It can only go up by drinking a potion of strength.  There are certain monsters that can temporarily weaken you when they hit you.  Drinking a potion of strength or life will clear any weakness the player has.

### Depth

This is the dungeon level you are on.  The crystal is on level 12.  However, there are deeper levels than 12.  If you desire an extra challenge, try to go deeper to collect more gold than a previous successful run.  Beware, there are more fearsome monsters under depth 12 and it can get harder to see the lower you go.

### Dmg

This is the average damage the weapon you are wielding will do to a monster when you hit it.

### Acc

This is the accuracy at which you will hit a monster with the weapon you are wielding.  If you are wielding a weapon with a higher strength requirement than what you current have, it will decrease your accuracy.  Monsters have a defense stat which get applied against your accuracy which can make some of them hard to hit than it would appear.

### Breath

You do have a breath stat, but its hidden.  Breath is not a major mechanic in this game.  If for some reason you're under water for longer than 20 seconds you will lose 1 HP per second you stay underwater.

## Monsters

There are many different types of monsters in the dungeons of doom.  Most will mind their own business if they do not see you.  The lower you go the harder they get.  They will hit harder, be harder to hit, work in groups and have access to magic.

## Multiplayer

Host a server and have a friend or two team up with you to get the crystal.  Beware, if any of your party dies, all of you will be reset to the beginning.  The game isn't balanced for multiplayer, but it can be good fun.  I'm open to ideas to make the game more multiplayer friendly while still retaining the singleplayer experience.

## Credits

 - Brogue - Brain Walker and other contributors for Brogue.  I ported some of the level generation code in Brogue from C to Lua.  I also used a lot of the mechanics of the game in this one.  The ported level generation code is in the mg_arch mode.
 - Shattered Pixel Dungeon - some textures were used from this game for the scrolls and traps.
 - Minipeli - I started with this game based to make this game.  Many thanks to paramat for providing this example.
 - Minetest Game - Chests, doors, fire, ladders, torches and some sounds, textures and node definitions were used from MTG.
 - MineClone2, now LibreVoxe - mcl_burning and many of the mob models, textures and sounds were taken from this game.
 - VoxelDungeon - noodlemire's work to build Shattered Pixel Dungeon in Minetest.  I used the weapon, armor and scroll textures and studied some of the source code for inspiration for some of the effect mechanics.  
 - Animalia - I used a few of the models, textures and sounds as mobs for Mogue.  
 - Goblins - I used the models, textures and sounds of the goblins mod for the goblins in Mogue
 - Mobkit - A good mob framework to build mob behaviors off of.  I modified it to suit some of my needs.
 - 3d_armor - used for equipping and unequipping armor.  However, the combat mechanics are taken from Brogue.
 - Mescons - used pressure plate code to build traps.  I'll likely revisit this mod to get wall buttons/levels for when I add puzzle rooms later.
 - player_monoids, player_effects (Wuzzy), player effect potions (Wuzzy) for some of the potions.  This will likely get reworked into a custom Mogue effect mod.  mg_poisons is a mod that has a handleful of effects for mobs and players.
 - Capture the Flag - I used the grenades mod from CTF to make throwable potions.  
 - bows - from TenPlus1.  Used for the arrows in the game and the arrows code was used as a base for mg_bolts for staves and wands.
 - hbhunger - used for hunger and health.  Modified to support Mogues's regeneration and poisoning system
 - signs_lib - used to show high scores to the player before they enter the dungeon
 - skinsdb - used to let player choose their skin.  
 - Lord of the Test - for the orc textures.
 - Exile - used the cobble rocks from this game
 - Goops Rings - used a little of the code and textures to get mg_rings started







