local path=minetest.get_modpath("mg_bolts")
local charm = dofile(path..'/charms.lua')
local recharge = dofile(path..'/recharge.lua')

local get_charm_enchant = recharge.get_charm_enchant
local use_charge = recharge.use_charge
local calc_staff_duration = recharge.calc_staff_duration


mg_bolts.register_bolt("fire",{
	description = "Fire Bolt",
	texture = "mg_bolts_fire.png",
	damage = 3,
  calc_damage = function(enchant)
    enchant = enchant or 1
    local dmg_min = math.floor(0.75 * (enchant + 2))
    local dmg_max = math.floor(2.5 * enchant + 4)
    local dmg = math.random(dmg_min, dmg_max)
    return dmg
  end,
  stop_on_node = 1,
  stop_on_object = 1,
	on_hit_sound = "bows_arrow_hit",
	on_hit_node = function(_self, _pos, _user, oldpos)
    -- Find a nearby air node and light it on fire
    local p = minetest.find_node_near(oldpos, 1, {"air"})
    if p then
      minetest.set_node(p, {name = 'fire:basic_flame'})
    end
  end,
  -- Fire bolt sets the air it passes through on fire
  -- If it passes near flammable terrain
	on_step = function(_self, pos, _user, _oldpos)
    local pf = minetest.find_node_near(pos, 1, {"group:flammable"})
    local flame = minetest.find_node_near(pos, 1, {'fire:basic_flame'})
    -- Light on fire if near flammable terrain and not yet near fire
    if pf and not flame then
      local pa = minetest.find_node_near(pf, 1, {"air"})
      if pa then
        minetest.set_node(pa, {name = 'fire:basic_flame'})
      end
    end
  end,
	on_hit_object = function(_self, target, _hp, _user, pos)
    -- Find a nearby air node and light it on fire
    local p = minetest.find_node_near(pos, 1, {"air"})
    if p then
      minetest.set_node({x = p.x, y = p.y, z = p.z}, {name = 'fire:basic_flame'})
    end

    -- set the target on fire
    mcl_burning.set_on_fire(target, 7)
	end
})

mg_bolts.register_bolt("blinking",{
	description = "Blinking Bolt",
	texture = "mg_bolts_light.png",
	damage = 0,
	drop_chance = 0,
  stop_on_object = 0,
  stop_on_node = 1,
	on_hit_sound = "bows_arrow_hit",
	on_remove = function(_self, player, oldpos)
    local p = minetest.find_node_near(oldpos, 1, {"air"})
    local prop = player:get_properties()
    local adjust = (prop.eye_height or 1.23)
    player:set_pos(vector.add(p, {x = 0, y = -1*adjust, z = 0}))
    minetest.sound_play("enderpearl_teleport", {max_hear_distance = 10, pos = player:get_pos()})
  end,
})

mg_bolts.register_bolt("tunneling",{
	description = "Tunneling Bolt",
	texture = "mg_bolts_light.png",
	damage = 0,
  stop_on_object = 0,
  stop_on_node = 0,
	on_hit_sound = "bows_arrow_hit",
  -- Fire bolt sets the air it passes through on fire
	on_hit_node = function(_self, pos, _user, _oldpos)
    minetest.set_node({x = pos.x, y=pos.y, z=pos.z}, {name = 'air'})
    minetest.set_node({x = pos.x, y=pos.y - 1, z=pos.z}, {name = 'air'})
  end
})

-- TODO only apply damage once per entity
mg_bolts.register_bolt("lightning",{
	description = "Lightning Bolt",
	texture = "mg_bolts_light.png",
	damage = 1,
  -- This is the same as the firebolt as well
  calc_damage = function(enchant)
    enchant = enchant or 1
    local dmg_min = math.floor(0.75 * (enchant + 2))
    local dmg_max = math.floor(2.5 * enchant + 4)
    local dmg = math.random(dmg_min, dmg_max)
    return dmg
  end,
	drop_chance = 0,
  stop_on_object = 0,
  stop_on_node = 0,
  reflection = 1,
	on_hit_sound = "bows_arrow_hit"
})

mg_bolts.register_bolt("poison",{
	description = "Poison Bolt",
	texture = "mg_bolts_poison.png",
	damage = 1,
	drop_chance = 0,
  stop_on_object = 1,
  stop_on_node = 1,
  reflection = 0,
	on_hit_sound = "bows_arrow_hit",
	on_hit_object = function(self, target, _hp, _user, _pos)
    local enchant = self.enchant
    local duration = math.floor(5 * 1.3^ (enchant-2))
    mg_poison.start_poison(target, 1, duration)
	end
})

mg_bolts.register_bolt("protection",{
	description = "Protection Bolt",
	texture = "mg_bolts_light.png",
	damage = 0,
	drop_chance = 0,
  stop_on_object = 1,
  stop_on_node = 1,
  reflection = 0,
	on_hit_sound = "bows_arrow_hit",
	on_hit_object = function(self, target, _hp, _user, _pos)
    local enchant = self.enchant
    local shield = math.ceil(13 * 1.4^(enchant-2))
    mg_protection.start_protection(target, shield, 20)
	end
})

mg_bolts.register_bolt("web",{
	description = "Web Bolt",
	texture = "mg_bolts_light.png",
	damage = 0,
	drop_chance = 0,
  stop_on_object = 1,
  stop_on_node = 1,
  reflection = 0,
	on_hit_sound = "bows_arrow_hit",
	on_hit_object = function(_self, _target, _hp, _user, pos)
    mg_effects.net({pos=pos})
	end,
	on_hit_node = function(_self, pos, _user, _oldpos)
    mg_effects.net({pos=pos})
  end
})

mg_bolts.register_bolt("teleportation",{
	description = "Teleportation Bolt",
	texture = "mg_bolts_light.png",
	damage = 0,
	drop_chance = 0,
  stop_on_object = 1,
  stop_on_node = 1,
  reflection = 0,
	on_hit_sound = "enderpearl_teleport",
	on_hit_object = function(_self, target, _hp, _user, _pos)
    mg_effects.teleport(target)
	end
})

mg_bolts.register_bolt("polymorph",{
	description = "Polymorph Bolt",
	texture = "mg_bolts_light.png",
	damage = 0,
	drop_chance = 0,
  stop_on_object = 1,
  stop_on_node = 1,
  reflection = 0,
	on_hit_sound = "enderpearl_teleport",
	on_hit_object = function(_self, target, _hp, _user, pos)
    -- won't work on players...
    if target:is_player() then
      return
    end
    -- get current hp percentage of target
    local old_mob = target:get_luaentity()
    local percent = old_mob.hp / old_mob.max_hp

    -- remove the old mob
		target:remove()

    -- pick a random monster
    local m_list = mg_arch.monsters.name_list
    local new_monster_name = m_list[math.random(1, #m_list)]
    print('try to spawn: ' .. new_monster_name)
    -- spawn a new one with current velociy
    local obj = mg_mobs.spawn(pos, new_monster_name)
    local mob = obj:get_luaentity()
    -- hp should get percentage
    mob.hp = mob.max_hp * percent
	end
})

mg_bolts.register_bolt("obstruction",{
	description = "Obstruction Bolt",
	texture = "mg_bolts_light.png",
	damage = 0,
	drop_chance = 0,
  stop_on_object = 1,
  stop_on_node = 1,
  reflection = 0,
	on_hit_sound = "bows_arrow_hit",
	on_hit_node = function(self, _pos, _user, arrow_pos)
    mg_effects.obstruction({pos = arrow_pos, radius = self.enchant})
  end,
	on_hit_object = function(self, _target, _hp, _user, arrow_pos)
    mg_effects.obstruction({pos = arrow_pos, radius = self.enchant})
	end,
	on_remove = function(self, _player, oldpos)
    mg_effects.obstruction({pos = oldpos, radius = self.enchant})
  end
})


minetest.register_craftitem("mg_bolts:wand_teleportation", {
  description = "Wand of Teleportation",
  inventory_image = "mg_wand_teleport.png",
  stack_max = 1,
  _enchant = 0,
  _recharge_inc = 2,
  _base_duration = 0,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)

    local enchant = get_charm_enchant(itemstack)
    local range = 1
    local meta = itemstack:get_meta()
    local max_charges = meta:get_int("recharge_max_charges")

    return use_charge(
      max_charges,
      0,
      itemstack,
      user,
      function()
        mg_bolts.shoot('mg_bolts:teleportation', user, range, enchant)
      end
    )
  end
})


minetest.register_craftitem("mg_bolts:wand_polymorph", {
  description = "Wand of Polymorph",
  inventory_image = "mg_wand_teleport.png",
  stack_max = 1,
  _enchant = 0,
  _recharge_inc = 2,
  _base_duration = 0,
  on_use = function(itemstack, user, _pointed_thing)
    local enchant = get_charm_enchant(itemstack)
    local range = 1
    local meta = itemstack:get_meta()
    local max_charges = meta:get_int("recharge_max_charges")

    return use_charge(
      max_charges,
      0,
      itemstack,
      user,
      function()
        mg_bolts.shoot('mg_bolts:polymorph', user, range, enchant)
      end
    )
  end
})



--- Staves
--
minetest.register_craftitem("mg_bolts:fire_staff", {
  description = "A fire staff",
  inventory_image = "mg_staff_fire.png",
  stack_max = 1,
  _enchant = 2,
  _base_duration = 500,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    local enchant = get_charm_enchant(itemstack)
    local recharge_duration = calc_staff_duration(user, itemstack)
    -- range is in seconds - we travel 10 blocks per second
    local range = (2 + (2 * enchant))/10
    local max_charges = enchant
    return recharge.use_charge(
      max_charges,
      recharge_duration,
      itemstack,
      user,
      function()
        mg_bolts.shoot('mg_bolts:fire', user, range, enchant)
      end
    )
  end
})


minetest.register_craftitem("mg_bolts:blinking_staff", {
  description = "Staff of Blinking",
  inventory_image = "mg_staff_blinking.png",
  stack_max = 1,
  _enchant = 2,
  _base_duration = 1000,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)

    local enchant = get_charm_enchant(itemstack)
    local recharge_duration = calc_staff_duration(user, itemstack)
    -- range is in seconds - we travel 10 blocks per second
    local range = (2 + (2 * enchant))/10
    local max_charges = enchant

    return use_charge(
      max_charges,
      recharge_duration,
      itemstack,
      user,
      function()
        mg_bolts.shoot('mg_bolts:blinking', user, range, enchant)
      end
    )
  end
})


minetest.register_craftitem("mg_bolts:tunneling_staff", {
  description = "A staff of tunneling",
  inventory_image = "mg_staff_tunneling.png",
  stack_max = 1,
  _enchant = 1,
  _base_duration = 500,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    local enchant = get_charm_enchant(itemstack)
    local max_charges = enchant
    local recharge_duration = calc_staff_duration(user, itemstack)
    -- range is in seconds - we travel 10 blocks per second
    local range = enchant/10
    return use_charge(
      max_charges,
      recharge_duration,
      itemstack,
      user,
      function()
        mg_bolts.shoot('mg_bolts:tunneling', user, range, enchant)
      end
    )
  end
})

minetest.register_craftitem("mg_bolts:lightning_staff", {
  description = "A staff of lightning",
  inventory_image = "magic_materials_enchanted_staff.png",
  stack_max = 1,
  _enchant = 2,
  _base_duration = 500,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    local enchant = get_charm_enchant(itemstack)
    local max_charges = enchant
    local recharge_duration = calc_staff_duration(user, itemstack)
    -- range is in seconds - we travel 10 blocks per second
    local range = (2 + (2 * enchant))/10
    return use_charge(
      max_charges,
      recharge_duration,
      itemstack,
      user,
      function()
        mg_bolts.shoot('mg_bolts:lightning', user, range, enchant)
      end
    )
  end
})

minetest.register_craftitem("mg_bolts:poison_staff", {
  description = "A staff of poison",
  inventory_image = "mg_staff_poison.png",
  stack_max = 1,
  _enchant = 2,
  _base_duration = 500,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    local enchant = get_charm_enchant(itemstack)
    local max_charges = enchant
    local recharge_duration = calc_staff_duration(user, itemstack)
    local range = (2 + (2 * enchant))/10
    return use_charge(
      max_charges,
      recharge_duration,
      itemstack,
      user,
      function()
        mg_bolts.shoot('mg_bolts:poison', user, range, enchant)
      end
    )
  end
})

minetest.register_craftitem("mg_bolts:protection_staff", {
  description = "A staff of protection",
  inventory_image = "mg_staff_protection.png",
  stack_max = 1,
  _enchant = 2,
  _base_duration = 500,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    local enchant = get_charm_enchant(itemstack)
    local max_charges = enchant
    local recharge_duration = calc_staff_duration(user, itemstack)
    local range = (2 + (2 * enchant))/10
    return use_charge(
      max_charges,
      recharge_duration,
      itemstack,
      user,
      function()
        mg_bolts.shoot('mg_bolts:protection', user, range, enchant)
      end
    )
  end
})

minetest.register_craftitem("mg_bolts:obstruction_staff", {
  description = "A staff of obstruction",
  inventory_image = "mg_staff_obstruction.png",
  stack_max = 1,
  _enchant = 2,
  _base_duration = 1000,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    local enchant = get_charm_enchant(itemstack)
    local max_charges = enchant
    local recharge_duration = calc_staff_duration(user, itemstack)
    local range = (2 + (2 * enchant))/10
    -- need to update the radius of the obstrution
    -- to depend on enchant
    return use_charge(
      max_charges,
      recharge_duration,
      itemstack,
      user,
      function()
        mg_bolts.shoot('mg_bolts:obstruction', user, range, enchant)
      end
    )
  end
})


-- Charms that use the recharging logic
--
--

minetest.register_craftitem("mg_bolts:health_charm", {
  description = "A charm of health",
  inventory_image = "mg_charm_health.png",
  stack_max = 1,
  _enchant = 1,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    local max_charges = 1
    local enchant = get_charm_enchant(itemstack)
    local recharge_duration = charm.calc_charm_recharge('health', enchant)
    local health_percent = charm.calc_charm_healing(enchant)
    return use_charge(
      max_charges,
      recharge_duration,
      itemstack,
      user,
      function()
        local hp = user:get_hp()
        local props = user:get_properties()
        local hp_delta = math.floor(props.hp_max * health_percent / 100)
        local new_hp = hp + hp_delta
        print('old hp '..hp..' new hp '..new_hp .. ' percent ' .. health_percent)
        user:set_hp(new_hp)
      end
    )
  end
})

minetest.register_craftitem("mg_bolts:haste_charm", {
  description = "A charm of Haste",
  inventory_image = "magic_materials_light_rune.png",
  stack_max = 1,
  _enchant = 1,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    local max_charges = 1
    local enchant = get_charm_enchant(itemstack)
    local recharge_duration = charm.calc_charm_recharge('haste', enchant)
    local duration = charm.calc_charm_duration('haste', enchant)
    return use_charge(
      max_charges,
      recharge_duration,
      itemstack,
      user,
      function()
        playereffects.apply_effect_type("pepspeedplus", duration, user)
      end
    )
  end
})

minetest.register_craftitem("mg_bolts:levitation_charm", {
  description = "Charm of Levitation",
  inventory_image = "magic_materials_ice_rune.png",
  stack_max = 1,
  _enchant = 1,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    local max_charges = 1
    local enchant = get_charm_enchant(itemstack)
    local recharge_duration = charm.calc_charm_recharge('levitation', enchant)
    local duration = charm.calc_charm_duration('levitation', enchant)
    return use_charge(
      max_charges,
      recharge_duration,
      itemstack,
      user,
      function()
        playereffects.apply_effect_type("pepgrav0", duration, user)
      end
    )
  end
})

minetest.register_craftitem("mg_bolts:shattering_charm", {
  description = "A charm of shattering",
  inventory_image = "magic_materials_storm_rune.png",
  stack_max = 1,
  _enchant = 1,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    local max_charges = 1
    local enchant = get_charm_enchant(itemstack)
    local recharge_duration = charm.calc_charm_recharge('shattering', enchant)
    local radius = charm.calc_charm_shattering(enchant)
    return use_charge(
      max_charges,
      recharge_duration,
      itemstack,
      user,
      function()
        local pos = user:getpos()
        mg_effects.shattering({pos = pos, radius = radius})
      end
    )
  end
})

minetest.register_craftitem("mg_bolts:recharging_charm", {
  description = "A charm of recharging",
  inventory_image = "magic_materials_earth_rune.png",
  stack_max = 1,
  _enchant = 1,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    local max_charges = 1
    local enchant = get_charm_enchant(itemstack)
    local recharge_duration = charm.calc_charm_recharge('recharging', enchant)
    return use_charge(
      max_charges,
      recharge_duration,
      itemstack,
      user,
      function()
        recharge.recharge_staves(user)
      end
    )
  end
})

minetest.register_craftitem("mg_bolts:teleportation_charm", {
  description = "Charm of Teleportation",
  inventory_image = "magic_materials_void_rune.png",
  stack_max = 1,
  _enchant = 1,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    local enchant = get_charm_enchant(itemstack)
    local recharge_duration = charm.calc_charm_recharge('teleportation', enchant)
    local max_charges = 1
    return use_charge(
      max_charges,
      recharge_duration,
      itemstack,
      user,
      function()
        mg_effects.teleport(user)
      end
    )
  end
})

minetest.register_craftitem("mg_bolts:fire_immunity_charm", {
  description = "Charm of Fire Immunity",
  inventory_image = "magic_materials_fire_rune.png",
  stack_max = 1,
  _enchant = 1,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    local max_charges = 1
    local enchant = get_charm_enchant(itemstack)
    local recharge_duration = charm.calc_charm_recharge('fire_immunity', enchant)
    local duration = charm.calc_charm_duration('fire_immunity', enchant)
    return use_charge(
      max_charges,
      recharge_duration,
      itemstack,
      user,
      function()
        playereffects.apply_effect_type("fire_immunity", duration, user)
      end
    )
  end
})

minetest.register_craftitem("mg_bolts:invisibility_charm", {
  description = "Charm of Invisibility",
  inventory_image = "magic_materials_invisible_rune.png",
  stack_max = 1,
  _enchant = 1,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    local max_charges = 1
    local enchant = get_charm_enchant(itemstack)
    local recharge_duration = charm.calc_charm_recharge('invisibility', enchant)
    local duration = charm.calc_charm_duration('invisibility', enchant)
    return use_charge(
      max_charges,
      recharge_duration,
      itemstack,
      user,
      function()
        playereffects.apply_effect_type("invisibility", duration, user)
      end
    )
  end
})

minetest.register_craftitem("mg_bolts:protection_charm", {
  description = "Charm of Protection",
  inventory_image = "mg_charm_protection.png",
  stack_max = 1,
  _enchant = 1,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    local max_charges = 1
    local enchant = get_charm_enchant(itemstack)
    local recharge_duration = charm.calc_charm_recharge('protection', enchant)
    local duration = charm.calc_charm_duration('protection', enchant)
    return use_charge(
      max_charges,
      recharge_duration,
      itemstack,
      user,
      function()
        mg_protection.start_protection(user, duration, 20)
      end
    )
  end
})

local function set_enchant_staff(itemstack, enchant)
  enchant = enchant or 2
  local meta = itemstack:get_meta()
  meta:set_int("recharge_max_charges", enchant)
  meta:set_int('enchant', enchant)
  return recharge.recharge_item(itemstack)
end

local function enchant_staff(itemstack, number)
  number = number or 1
  local meta = itemstack:get_meta()
  local enchant = get_charm_enchant(itemstack) + number
  -- max charges is always enchantment value
  meta:set_int("recharge_max_charges", enchant)
  meta:set_int('enchant', enchant)
  return recharge.recharge_item(itemstack)
end

local function set_enchant_charm(itemstack, enchant)
  enchant = enchant or 1
  local meta = itemstack:get_meta()
  meta:set_int('enchant', enchant)
  meta:set_int("recharge_max_charges", 1)
  return recharge.recharge_item(itemstack)
end

local function enchant_charm (itemstack, number)
  number = number or 1
  local meta = itemstack:get_meta()
  local enchant = get_charm_enchant(itemstack) + number
  meta:set_int('enchant', enchant)
  meta:set_int("recharge_max_charges", 1)
  return recharge.recharge_item(itemstack)
end

local function enchant_wand(itemstack)
  local meta = itemstack:get_meta()
  local def = itemstack:get_definition()
  local enchant = get_charm_enchant(itemstack) + 1
  local recharge_inc = def._recharge_inc or 1

  local max_charges = meta:get_int("recharge_max_charges")
  local wear = itemstack:get_wear() or 0
  local charges_remaining = max_charges - wear
  local total_charges = charges_remaining + recharge_inc

  -- wands only recharge by certain increments when recharged
  itemstack:set_wear(0)
  meta:set_int("recharge_max_charges", total_charges)
  -- does enchant actually mean anything here?
  meta:set_int('enchant', enchant)
  recharge.set_desc(itemstack, total_charges)
  return itemstack
end


mg_bolts.recharge_staves = recharge.recharge_staves
mg_bolts.recharge_charms = recharge.recharge_charms
mg_bolts.apply_player_reaping = recharge.apply_player_reaping

mg_bolts.enchant_charm = enchant_charm
mg_bolts.enchant_staff = enchant_staff
mg_bolts.set_enchant_charm = set_enchant_charm
mg_bolts.set_enchant_staff = set_enchant_staff
mg_bolts.enchant_wand = enchant_wand
