minetest.register_entity("mg_mobs:wolf",{
  -- common props
  physical = true,
  stepheight = 0.1,				--EVIL!
  collide_with_objects = true,
  collisionbox = {-0.3, -0.01, -0.3, 0.3, 0.84, 0.3},
  visual = "mesh",
  mesh = "mobs_mc_wolf.b3d",
  textures = {"mobs_mc_wolf_angry.png"},
  visual_size = {x = 1, y = 1},
  static_save = true,
  makes_footstep_sound = true,
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.75,					-- portion of hitbox submerged
  max_speed = 10,
  jump_height = 1.26,
  view_range = 24,
  lung_capacity = 10, 		-- seconds
  max_hp = 8,
  regen = 20,
  defense = 0,
  accuracy = 70,
  attack={range=0.5,damage_groups={fleshy=2, fleshy_max=4}},
  sounds = {
    attack='dogbite',
    warn = 'angrydog',
    hurt = 'mobs_mc_wolf_hurt',
  },
  animation = {
    sit={range={x=45,y=45},speed=1},
    run={range={x=0,y=40},speed=100,loop=true},
    walk={range={x=0,y=40},speed=50,loop=true},
    stand={range={x=0,y=0},speed=1,loop=true},
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch = mg_mobs.handle_on_punch,

  behaviors = { },
})

mg_mobs.register_egg("mg_mobs:wolf", "Wolf", 1);
