-- what about weakness buffs that apply over time?
--
-- Should probably have a common lib that I can pass around instead of copy/past everywhere ...
local function min(x, y)
  if x < y then
    return x
  else
    return y
  end
end

local function max(x, y)
  if x > y then
    return x
  else
    return y
  end
end

local function clamp(x, low, high)
  return min(high, max(x, low))
end

mg_strength = {}

local get_weakness = function(player)
  local meta = player:get_meta()

  if not player:is_player() then
    return 0
  end

  local weakness = meta:get_int("mg_weakness") or 0

  return weakness
end

local set_weakness = function(player, amount)
  local meta = player:get_meta()

  if not player:is_player() then
    return 0
  end

   meta:set_int("mg_weakness", amount)
end

local get_strength_raw = function(player)
  local meta = player:get_meta()

  if not meta then
    -- Probably a mob
    -- just assume default strength for now
    return 12
  end

  local strength = meta:get_int("mg_strength") or 0

  if strength == 0 then
    strength = 12
    meta:set_int("mg_strength", strength)
  end

  return strength
end

local get_strength = get_strength_raw

local set_strength_raw = function(player, strength)
  local meta = player:get_meta()
  meta:set_int("mg_strength", strength)
	return true
end

local increase = function(player)
  local meta = player:get_meta()
  local strength = meta:get_int("mg_strength") or 12
  meta:set_int("mg_strength", strength + 1)
  -- todo cancel any weakness effects as well
	return true
end


local function strengthDiff(strengthRequired, strength, weaknessAmount)
  local difference = strength - weaknessAmount - strengthRequired;
  return difference
end

local function player_strength_diff(player, strengthRequired)
  local strength = get_strength(player)
  local weaknessAmount = 0
  return strengthDiff(strengthRequired, strength, weaknessAmount)
end

local function strengthModifier(strengthRequired, strength, weaknessAmount)
  local difference = strengthDiff(strengthRequired, strength, weaknessAmount)
  if (difference > 0) then
    return difference / 4; -- 0.25x
  else
    return difference * 5/2; -- 2.5x
  end
end

local function netEnchant(enchant1, strengthRequired, strength, weakness)
    local retval = enchant1 + strengthModifier(strengthRequired, strength, weakness);
    -- Clamp all net enchantment values to [-20, 50].
    return clamp(retval, -20, 50);
end

local function damageFraction(bonus)
  return 1.065^bonus
end

local function accuracyFraction(bonus)
  return 1.065^bonus
end

local function calcDamage(enchant, str_required, min_dmg, max_dmg, player_str, player_weakness)
  local bonus = netEnchant(enchant, str_required, player_str, player_weakness or 0)
  local multiplier = damageFraction(bonus)
  local lower_dmg = min_dmg * multiplier
  local upper_dmg = max_dmg * multiplier
  if lower_dmg < 1 then lower_dmg = 1 end
  if upper_dmg < 1 then upper_dmg = 1 end
  local dmg = math.random(lower_dmg, upper_dmg)
  return dmg
end


core.register_on_respawnplayer(function(player)
  set_strength_raw(player, 12)
end)

mg_strength.get_strength_raw = get_strength_raw
mg_strength.get_strength = get_strength
mg_strength.set_strength_raw = set_strength_raw
mg_strength.player_strength_diff = player_strength_diff
mg_strength.increase = increase

mg_strength.strengthModifier = strengthModifier
mg_strength.netEnchant = netEnchant
mg_strength.damageFraction = damageFraction
mg_strength.accuracyFraction = accuracyFraction
mg_strength.calcDamage = calcDamage

mg_strength.get_weakness = get_weakness
mg_strength.set_weakness = set_weakness


