local function clamp(x, low, high)
  return math.min(high, math.max(x, low))
end

local function rand_percent(percent)
  return math.random(0,99) < clamp(percent, 0, 100)
end

local nbDirs = {{0,-1}, {0,1}, {-1,0}, {1, 0}, {-1,-1}, {-1,1}, {1,-1}, {1,1}};

local function find_node(x, y, nodes)
  for _, node in ipairs(nodes) do
    if node.x == x and node.y == y then
      return node
    end
  end
  local node = {x = x, y = y, value = 0}
  table.insert(nodes, node)
  return node
end

-- Rewrite of brogue's code to support things outside of the dungeon limits
local function spawn_map_df(start_x, start_y, startProb, probDec)
  local nodes = {}

  local function get_node(x, y)
    for _, node in ipairs(nodes) do
      if node.x == x and node.y == y then
        return node
      end
    end
    local node = {x = x, y = y, value = 0}
    table.insert(nodes, node)
    return node
  end

  local function set_node(x, y, value)
    local node = get_node(x, y)
    node.value = value
  end

  local t = 1
  set_node(start_x, start_y, t)

  local madeChange = true
  local x2, y2

  while madeChange and startProb > 0 do
    madeChange = false
    t = t + 1
    for _, node in ipairs(nodes) do
      if node.value == t - 1 then
        for dir = 1, 4 do
          x2 = node.x + nbDirs[dir][1]
          y2 = node.y + nbDirs[dir][2]
          if rand_percent(startProb) then
            set_node(x2, y2, t)
            madeChange = true
          end
        end
      end
    end
    startProb = startProb - probDec

    if t > 100 then
      for _, node in ipairs(nodes) do
        if node.value == t then
          set_node(node.x, node.y, 2)
        elseif node.value > 0 then
          set_node(node.x, node.y, 1)
        end
      end
      t = 2
    end
  end
  return nodes
end

local stone_block = "mapgen:stone_block"
local sand = "mapgen:sand"
local water = "mapgen:water_source"
local air = "air"

local function flood(params)
  local pos = params.pos or {x = 0, y = 0, z = 0}

  local shallowFlood = spawn_map_df(pos.x, pos.z, 255, 37)
  local deepFlood = spawn_map_df(pos.x, pos.z, 175, 37)
  local baseY = pos.y - 1

  for _, df_node in ipairs(shallowFlood) do
    local df = df_node.value
    local x = df_node.x
    local z = df_node.y
    local node = core.get_node({ x = x, y = baseY + 1, z = z })
    if (df > 0) and node.name ~= stone_block then
      local base = sand
      local deep1 = sand
      local deep2 = sand
      local shallow = sand
      local ground = water
      local middle1 = air
      local middle2 = air

      local deep_node = find_node(x, z, deepFlood)

      if deep_node.value > 0 then
        base = sand
        deep1 = water
        deep2 = water
        shallow = water
        ground = water
        middle1 = air
        middle2 = air
      end

      local list = {
        {{ x = x, y = baseY + 0, z = z }, ground},
        {{ x = x, y = baseY - 1, z = z }, shallow},
        {{ x = x, y = baseY - 2, z = z }, deep1},
        {{ x = x, y = baseY - 3, z = z }, deep2},
        {{ x = x, y = baseY - 4, z = z }, base}
      }

      local middle_list = {
        {{ x = x, y = baseY + 2, z = z }, middle2},
        {{ x = x, y = baseY + 1, z = z }, middle1},
      }

      for _, item in ipairs(middle_list) do
        local node_pos = item[1]
        local name = item[2]
        local rnode = core.get_node(node_pos)
        -- only replace if it would have been replaced by lichen
        if core.get_item_group(rnode.name, 'replaced_by_lichen') > 0 then
          core.set_node(node_pos, {name=name})
        end
      end

      -- For the ground, just turn it to water and sand :-)
      for _, item in ipairs(list) do
        local node_pos = item[1]
        local name = item[2]
        core.set_node(node_pos, {name=name})
      end
    end
  end

  core.after(0.1, function()
    -- 3 squids, hehe
    minetest.add_entity(pos, 'mg_mobs:squid')
    minetest.add_entity({x = pos.x + 1, y = pos.y, z = pos.z}, 'mg_mobs:squid')
    minetest.add_entity({x = pos.x - 1, y = pos.y, z = pos.z}, 'mg_mobs:squid')
  end)
end

local function net(params)
  local pos = params.pos or {x = 0, y = 0, z = 0}

  --local featureMap = spawnMapDF(pos.x, pos.z, 175, 37)
  local featureNodes = spawn_map_df(pos.x, pos.z, 175, 37)
  local baseY = pos.y - 1

  for _, df_node in ipairs(featureNodes) do
    local df = df_node.value
    local x = df_node.x
    local z = df_node.y
    local node = core.get_node({ x = x, y = baseY + 1, z = z })
    -- Not a wall and shallow flood or deep flodd
    if (df > 0) and node.name ~= stone_block then
      local middle1 = "mapgen:cobweb"

      local list = {
        {{ x = x, y = baseY + 1, z = z }, middle1},
        {{ x = x, y = baseY + 2, z = z }, middle1},
      }

      for _, item in ipairs(list) do
        local node_pos = item[1]
        local name = item[2]
        local old_node = core.get_node(node_pos)
        if (old_node.name == 'air' or core.get_item_group(old_node.name, 'replaced_by_lichen') > 0) then
          core.set_node(node_pos, {name=name})
        end
      end
    end
  end
end

return {
  spawn_map_df = spawn_map_df,
  net = net,
  flood = flood,
}

