local function node_ok(pos, fallback)
	fallback = fallback or "air"
	local node = minetest.get_node_or_nil(pos)

	if not node then
		return fallback
	end

	if minetest.registered_nodes[node.name] then
		return node.name
	end

	return fallback
end

local function get_player_nodes(player_pos)
	local work_pos = table.copy(player_pos)

	-- what is around me?
	work_pos.y = work_pos.y - 0.1 -- standing on
	local node_stand = node_ok(work_pos)
	local node_stand_below = node_ok({x=work_pos.x, y=work_pos.y-1, z=work_pos.z})

	work_pos.y = work_pos.y + 1.5 -- head level
	local node_head = node_ok(work_pos)
	work_pos.y = work_pos.y + 0.5 -- top of head level, at collision box height
	local node_head_top = node_ok(work_pos)
	work_pos.y = work_pos.y - 0.5

	work_pos.y = work_pos.y - 1.2 -- feet level
	local node_feet = node_ok(work_pos)

	return node_stand, node_stand_below, node_head, node_feet, node_head_top
end

-- I'm going to put suffocation in here as well for now
-- Also taken from MCL2
local time = 0
core.register_globalstep(function(dtime)

	time = time + dtime

  if time < 0.5 then
    return
  end

  time = 0

	for _, player in pairs(core.get_connected_players()) do
		-- who am I?
		local name = player:get_player_name()

		-- where am I?
		local pos = player:get_pos()

		-- what is around me?
		local node_stand, node_stand_below, node_head, node_feet, node_head_top = get_player_nodes(pos)
		if not node_stand or not node_stand_below or not node_head or not node_feet or not node_head_top then
			return
		end
		-- Is player suffocating inside node? (Only for solid full opaque cube type nodes
		-- without group disable_suffocation=1)
		-- if swimming, check the feet node instead, because the head node will be above the player when swimming
		local ndef = minetest.registered_nodes[node_head]
		if (ndef.walkable == nil or ndef.walkable == true)
		and (ndef.collision_box == nil or ndef.collision_box.type == "regular")
		and (ndef.node_box == nil or ndef.node_box.type == "regular")
		and (ndef.groups.disable_suffocation ~= 1)
		and (ndef.groups.opaque == 1)
		and (node_head ~= "ignore")
		-- Check privilege, too
		and (not core.check_player_privs(name, {noclip = true})) then
      local hp = player:get_hp()
      if hp > 0 then
        player:set_hp(hp - 1, {_mcl_reason = {type = "in_wall"}})
      end
		end
  end
end)

