-- Maybe borrow the below code when play drinks a potion
-- core.sound_play("mcl_potions_drinking", {pos = pos, max_hear_distance = 6, gain = 1})


-- Updating max hp doesn't presist for some reason
minetest.register_on_joinplayer(function(player)
	local storage = {}
	local data = player:get_meta():get_string("mg_potions:data")
	if data ~= "" then
		storage = minetest.deserialize(data) or storage
	end
	if storage.max_hp then
    player:set_properties({
      hp_max = storage.max_hp,
    })
	end
end)

local function reset_max_hp(player)
  local hp = 30
  local storage = { max_hp = hp }
  player:get_meta():set_string("mg_potions:data", minetest.serialize(storage))
  player:set_properties({
    hp_max = hp
  })
  player:set_hp(hp)
end

-- after player dies set back to 30
core.register_on_respawnplayer(function(player)
  reset_max_hp(player)
end)

core.register_on_newplayer(function(player)
  reset_max_hp(player)
end)

local function increase_hp (itemstack, user)
  mg_poison.cure_poison(user)
  itemstack:set_wear(itemstack:get_wear() + 65535*2)
  local props = user:get_properties()
  local new_hp = math.floor(props.hp_max * 1.33)
  user:set_properties({
    hp_max = new_hp,
  })
  user:set_hp(new_hp)
  local storage = { max_hp = new_hp }
  user:get_meta():set_string("mg_potions:data", minetest.serialize(storage))
  local player_name = user:get_player_name()
  local message = "Your max HP is increased by 33% and your HP is completely restored."
  mg_strength.set_weakness(user, 0)
  minetest.chat_send_player(player_name, message)
  return itemstack
end

local function increase_strength (itemstack, user)
  itemstack:set_wear(itemstack:get_wear() + 65535*2)
  mg_strength.increase(user)
  local player_str = mg_strength.get_strength_raw(user)
  local player_name = user:get_player_name()
  local message = "New found strength surges through your body.  Your strength is now " .. player_str .. "."
  minetest.chat_send_player(player_name, message)
  return itemstack
end

minetest.register_craftitem("mg_potions:strength", {
  description = "A potion of strength - increase strength to wield better weapons",
  inventory_image = "pep_jumpplus.png",
  stack_max = 1,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    return increase_strength(itemstack, user)
  end,
  on_place = function(itemstack, user, _pointed_thing)
    return increase_strength(itemstack, user)
  end
})

minetest.register_craftitem("mg_potions:life", {
  description = "A potion of life - restore all health and increase max HP 30%",
  inventory_image = "pep_regen2.png",
  stack_max = 1,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    return increase_hp(itemstack, user)
  end,
  on_place = function(itemstack, user, _pointed_thing)
    return increase_hp(itemstack, user)
  end
})




dofile(core.get_modpath("mg_potions") .. "/throwable.lua")
