-- most of this code was adapted from
-- https://github.com/minetest-mods/mesecons/blob/master/mesecons_pressureplates/init.lua
-- whats different here is the trap is the floor node and it senses for a for the node above it
-- this is so grass and lichen can cover and obscure a trap
-- I also use node meta data to store trap state instead
-- of having different nodes

local function obj_touching_plate_pos(obj_ref, plate_pos)
	local obj_pos = obj_ref:get_pos()
	local props = obj_ref:get_properties()
	if not (props and obj_pos and not obj_ref:get_attach()) then
		return false
	end

	local collisionbox = props.collisionbox
	local physical = props.physical
	local is_player = obj_ref:is_player()
	local luaentity = obj_ref:get_luaentity()
	local is_item = luaentity and luaentity.name == "__builtin:item"
	if not (collisionbox and physical or is_player or is_item) then
		return false
	end

	local plate_x_min = plate_pos.x - 7 / 16
	local plate_x_max = plate_pos.x + 7 / 16
	local plate_z_min = plate_pos.z - 7 / 16
	local plate_z_max = plate_pos.z + 7 / 16
	local plate_y_min = plate_pos.y - 8 / 16
	local plate_y_max = plate_pos.y - 6.5 / 16

	local obj_x_min = obj_pos.x + collisionbox[1]
	local obj_x_max = obj_pos.x + collisionbox[4]
	local obj_z_min = obj_pos.z + collisionbox[3]
	local obj_z_max = obj_pos.z + collisionbox[6]
	local obj_y_min = obj_pos.y + collisionbox[2]
	local obj_y_max = obj_pos.y + collisionbox[5]

	if
		obj_y_min < plate_y_max and
		obj_y_max > plate_y_min and
		obj_x_min < plate_x_max and
		obj_x_max > plate_x_min and
		obj_z_min < plate_z_max and
		obj_z_max > plate_z_min
	then
		return true
	end
	return false
end

local function mk_trap_timer(cb)
  return function(pos)
    -- This is a workaround for a strange bug that occurs when the server is started
    -- For some reason the first time on_timer is called, the pos is wrong
    local meta = core.get_meta(pos)
    local trap_state = meta:get_int("trap_state") or 0

    local trigger_pos = {x = pos.x, y = pos.y + 1, z = pos.z}

    local objs = minetest.get_objects_inside_radius(trigger_pos, 1)
    local obj_touching = false
    for _, obj in pairs(objs) do
      if obj_touching_plate_pos(obj, trigger_pos) then
        obj_touching = true
        break
      end
    end

    if not obj_touching and trap_state == 1 then
      -- Turn trap state off
      meta:set_int("trap_state", 0)

    elseif obj_touching and trap_state == 0 then
      -- Turn trap state on
      meta:set_int("trap_state", 1)
      -- set in node metadata
      -- activate trap effect
      cb(trigger_pos)
      minetest.sound_play("mg_traps_click", {
        pos = pos,
        gain = 1.0,
        max_hear_distance = 32,
      })
    end
    return true
  end
end


core.register_node("mg_traps:fire_trap", {
	description = "Fire Trap",
	tiles = {"mapgen_cobble.png^fire_trap.png"},
	groups = {cracky = 3, trap = 1},
	sounds = mapgen.hard_sounds,
  on_timer = mk_trap_timer(function(pos)
    mg_effects.fireball({radius = 5, pos=pos})
  end),
  on_construct = function(pos)
    core.get_node_timer(pos):start(0.1)
  end,
})

core.register_node("mg_traps:descent_trap", {
	description = "Descent Trap",
	tiles = {"mapgen_cobble.png^descent_trap.png"},
	groups = {cracky = 3, trap = 1},
	sounds = mapgen.hard_sounds,
  on_timer = mk_trap_timer(function(pos)
    mg_effects.descent({pos=pos, upper_radius=2})
  end),
  on_construct = function(pos)
    core.get_node_timer(pos):start(0.1)
  end,
})



core.register_node("mg_traps:flood_trap", {
	description = "Flood Trap",
	tiles = {"mapgen_cobble.png^flood_trap.png"},
	groups = {cracky = 3, trap = 1},
	sounds = mapgen.hard_sounds,
  on_timer = mk_trap_timer(function(pos)
    mg_effects.flood({pos=pos})
  end),
  on_construct = function(pos)
    core.get_node_timer(pos):start(0.1)
  end,
})


core.register_node("mg_traps:net_trap", {
	description = "Net Trap",
	tiles = {"mapgen_cobble.png^net_trap.png"},
	groups = {cracky = 3, trap = 1},
	sounds = mapgen.hard_sounds,
  on_timer = mk_trap_timer(function(pos)
    mg_effects.net({pos=pos})
  end),
  on_construct = function(pos)
    core.get_node_timer(pos):start(0.1)
  end,
})

core.register_node("mg_traps:gas_trap", {
	description = "Gas Trap",
	tiles = {"mapgen_cobble.png^gas_trap.png"},
	groups = {cracky = 3, trap = 1},
	sounds = mapgen.hard_sounds,
  on_timer = mk_trap_timer(function(pos)
    mg_effects.poison_explode(pos)
  end),
  on_construct = function(pos)
    core.get_node_timer(pos):start(0.1)
  end,
})
