-- idea is to show strength, weakness, armor class, stealth and damage
--
--

local hud_refs = {}
local hud_players = {}

local function init_hud(player)
  local player_hud_ref = {}

  player_hud_ref.stealth = player:hud_add({
    hud_elem_type = "text",
    position  = {x = 0.5, y = 1},
    offset    = {x = 100, y = -100},
    text      = "Stealth: ",
    alignment = -1,
    scale     = { x = 50, y = 10},
    number    = 0xFFFFFF,
  })

  player_hud_ref.depth = player:hud_add({
    hud_elem_type = "text",
    position  = {x = 0.5, y = 1},
    offset    = {x = 100, y = -75},
    text      = "Depth: ",
    alignment = -1,
    scale     = { x = 50, y = 10},
    number    = 0xFFFFFF,
  })

  hud_refs[player:get_player_name()] = player_hud_ref
end

local function update_hud(player)
  local player_hud_ref = hud_refs[player:get_player_name()]

  if not player_hud_ref then
    return
  end

  local stealth = mg_stealth.get_stealth(player)
  local ac = mg_armor.get_player_ac(player, false)
  local strength = mg_strength.get_strength(player)
  local weakness = mg_strength.get_weakness(player)
  local str_hud = 'Str: ' .. strength
  if(weakness > 0) then
    str_hud = 'Str: ' .. (strength - weakness) .. ' (' .. strength .. ')'
  end
  player:hud_change(player_hud_ref.stealth, "text", "Stealth: " .. stealth .. '  AC: ' .. ac .. '  ' .. str_hud)



  local meta = player:get_meta()
  local depth = meta:get_int("current_level")
  local info = mg_tools.get_weapon_info(player)
  local avg_dmg = string.format("%.1f", info.avg_dmg)
  player:hud_change(player_hud_ref.depth, "text", "Depth: " .. depth .. "  Dmg: " .. avg_dmg .. "  Acc: " .. info.accuracy)
end


core.register_on_joinplayer(function(player)
	hud_players[player:get_player_name()] = player
  init_hud(player)
end)

core.register_on_leaveplayer(function(player)
	hud_players[player:get_player_name()] = nil
	hud_refs[player:get_player_name()] = nil
end)

local timer = 0
minetest.register_globalstep(function(dtime)
	timer = timer + dtime
	if timer > 1 then
    timer = 0
    for _, player in pairs(hud_players) do
      -- update all hud elements
      update_hud(player)
		end
	end
end)
