if mg_arch == nil then
  mg_arch = {}
end

local DCOLS = 79 -- width
local DROWS = 27 -- height

-- grid procedures

local function allocGrid()
  local grid = {}
  for i=1, DCOLS do
    grid[i] = {}
    for j=1, DROWS do
      grid[i][j] = 0
    end
  end
  return grid
end

local function copyNewGrid(origGrid)
  local grid = {}
  for i=1, DCOLS do
    grid[i] = {}
    for j=1, DROWS do
      grid[i][j] = origGrid[i][j]
    end
  end
  return grid
end

local function fillGrid(grid, fillValue)
  for i, col in ipairs(grid) do
    for j, row in ipairs(col) do
      grid[i][j] = fillValue
    end
  end
end

mg_arch.allocGrid = allocGrid
mg_arch.copyNewGrid = copyNewGrid
mg_arch.fillGrid = fillGrid
mg_arch.DCOLS = DCOLS
mg_arch.DROWS = DROWS
