minetest.register_node("mg_mobs:statue", {
  description = "Statue",
  drawtype = "mesh",
  inventory_image = "regulus_crystal.png",
  pointable = true,
  walkable = true,
  groups = {},
  paramtype = "light",
  paramtype2 = "facedir",
  mesh = "extra_mobs_sword_piglin.b3d",
  tiles = {"mapgen_stone.png", "default_tool_steelsword.png"},
  --mesh = "mobs_mc_vex.b3d",
  --tiles = {"default_tool_steelsword.png", "mobs_mc_vex.png"},
})

minetest.register_entity("mg_mobs:ogre",{
  physical = true,
  stepheight = 0.1,				--EVIL!
  collide_with_objects = true,
  collisionbox = {-0.3, -0.01, -0.3, 0.3, 1.84, 0.3},
  visual = "mesh",
  mesh = "extra_mobs_sword_piglin.b3d",
  textures = {
    "extra_mobs_piglin.png",
    "voxeldungeon_tool_weapon_mace.png"
  },
  visual_size = {x=1, y=1},
  static_save = true,
  makes_footstep_sound = true,
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.9,
  max_speed = 5,
  jump_height = 1.26,
  view_range = 24,
  lung_capacity = 10,			-- seconds
  max_hp = 55,
  regen=20,
  defense = 60,
  accuracy = 125,
  attack={range=0.5,damage_groups={fleshy=9, fleshy_max=13}},
  sounds = {
    warn='mobs_mc_zombiepig_war_cry',
    hurt = 'mobs_mc_zombiepig_hurt',
  },
  animation = {
    stand={range={x=0,y=79},speed=30,loop=true},
    walk={range={x=168,y=187},speed=30,loop=true},
    run={range={x=440,y=459},speed=30,loop=true},
  },

  bolts = { },
  behaviors = { },
  abilities = {
    avoids_corridors = 1,
    attacks_stagger = 1
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch= mg_mobs.handle_on_punch,
})

minetest.register_entity("mg_mobs:ogre_shaman",{
  physical = true,
  stepheight = 0.1,				--EVIL!
  collide_with_objects = true,
  collisionbox = {-0.3, -0.01, -0.3, 0.3, 1.94, 0.3},
  visual = "mesh",
  mesh = "extra_mobs_sword_piglin.b3d",
  textures = {
    "extra_mobs_piglin_brute.png",
    "voxeldungeon_tool_weapon_mace.png"
  },
  visual_size = {x=1, y=1},
  static_save = true,
  makes_footstep_sound = true,
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.9,
  max_speed = 5,
  jump_height = 1.26,
  view_range = 24,
  lung_capacity = 10,			-- seconds
  max_hp = 55,
  attack={range=1,damage_groups={fleshy=13}},
  sounds = {
    warn='mobs_mc_zombiepig_war_cry',
    hurt = 'mobs_mc_zombiepig_hurt',
  },
  animation = {
    stand={range={x=0,y=79},speed=30,loop=true},
    walk={range={x=168,y=187},speed=30,loop=true},
    run={range={x=440,y=459},speed=30,loop=true},
  },

  bolts = { },
  behaviors = { },
  abilities = {
    avoids_corridors = 1,
    attacks_stagger = 1
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch= mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:ogre", "Ogre", 1);

mg_mobs.register_egg("mg_mobs:ogre_shaman", "Ogre Shaman", 1);
