-- TODO: want to rename this to mg_dungeon
-- This is more of a utility mod in pure lua,
-- it does not interact with luanti core
mg_arch = {}

local mod_path = minetest.get_modpath("mg_arch")

dofile(mod_path.."/globals.lua")
dofile(mod_path.."/grid.lua")
dofile(mod_path.."/dijkstra.lua")
dofile(mod_path.."/arch.lua")
dofile(mod_path.."/items.lua")
dofile(mod_path.."/monsters.lua")
dofile(mod_path.."/fov.lua")

core.register_async_dofile(mod_path .. "/globals.lua")
core.register_async_dofile(mod_path .. "/grid.lua")
core.register_async_dofile(mod_path .. "/dijkstra.lua")
core.register_async_dofile(mod_path .. "/arch.lua")
core.register_async_dofile(mod_path .. "/items.lua")
core.register_async_dofile(mod_path .. "/monsters.lua")
core.register_async_dofile(mod_path .. "/fov.lua")


local default_dungeon = {
  seed = 0,
  MAX_LEVELS = 17,
  AMULET_LEVEL = 12,
  NUMBER_GENERATED_LEVELS = 0,
  worldData = {},
  levels = {},
  pmaps = {}
}

mg_arch.default_dungeon = default_dungeon

mg_arch.dungeon = table.copy(default_dungeon)

function mg_arch.save_dungeon(d)
	local file = io.open(minetest.get_worldpath().."/dungeon.txt", "w")
	if file then
		file:write(core.serialize(d))
		file:close()
	end
end

function mg_arch.load_dungeon()
	local file = io.open(minetest.get_worldpath().."/dungeon.txt", "r")
	if file then
		local table = core.deserialize(file:read("*all"))
		if type(table) == "table" then
			return table
		end
	end
  return table.copy(default_dungeon)
end

core.register_on_mods_loaded(function()
  print('load up saved levels if any')
  mg_arch.dungeon = mg_arch.load_dungeon()
end)
