local charm_data = {
  health = {
    duration_factor = 3,
    duration_base = 1,
    recharge_factor = 2500,
    recharge_base = 55,
  },
  protection = {
    duration_factor = 20,
    duration_base = 1.2,
    recharge_factor = 1000,
    recharge_base = 60
  },
  haste = {
    duration_factor = 7,
    duration_base = 1.25,
    recharge_factor = 800,
    recharge_base = 65
  },
  fire_immunity = {
    duration_factor = 10,
    duration_base = 1.25,
    recharge_factor = 800,
    recharge_base = 60
  },
  invisibility = {
    duration_factor = 5,
    duration_base = 1.20,
    recharge_factor = 800,
    recharge_base = 65
  },
  telepathy = {
    duration_factor = 25,
    duration_base = 1.25,
    recharge_factor = 800,
    recharge_base = 65,
  },
  levitation = {
    duration_factor = 10,
    duration_base = 1.25,
    recharge_factor = 800,
    recharge_base = 65,
  },
  shattering = {
    duration_factor = 0,
    duration_base = 1,
    recharge_factor = 2500,
    recharge_base = 60,
  },
  guardian = {
    duration_factor = 18,
    duration_base = 1,
    recharge_factor = 700,
    recharge_base = 70,
  },
  teleportation = {
    duration_factor = 0,
    duration_base = 1,
    recharge_factor = 920,
    recharge_base =60
  },
  recharging = {
    duration_factor = 0,
    duration_base = 1,
    recharge_factor = 10000,
    recharge_base = 55,
  },
  negation = {
    duration_factor = 0,
    duration_base = 1,
    recharge_factor = 2500,
    recharge_base = 60,
  },
}

local function calc_charm_duration(kind, enchant)
  local data = charm_data[kind]
  local base = data.duration_base
  local factor = data.duration_factor
  return math.floor(factor * base^(enchant - 1))
end

local function calc_charm_recharge(kind, enchant)
  local data = charm_data[kind]
  local base = data.recharge_base / 100
  local factor = data.recharge_factor
  local duration = calc_charm_duration(kind, enchant)
  return math.floor(duration + factor * base^enchant)
end

local function clamp(value, min, max)
  if value < min then
    return min
  elseif value > max then
    return max
  end
  return value
end

-- returns a percentage
local function calc_charm_healing(enchant)
  return clamp(20 * enchant, 0, 100)
end

local function calc_charm_shattering(enchant)
  return 4 + enchant
end

-- To compare to the brogue wiki
-- looks good
local function print_charm_tables()
  for name, _ in pairs(charm_data) do
    print('charm data for '..name)
    print('enchant | duration | recharge time')
    for i=1,20 do
      local duration = math.floor(calc_charm_duration(name, i))
      local recharge = math.floor(calc_charm_recharge(name, i))
      print(i..'      | '.. duration ..'       | '.. recharge ..'         ')
    end
    print('\n\n')
  end
end

--print_charm_tables()

return {
  calc_charm_duration = calc_charm_duration,
  calc_charm_recharge = calc_charm_recharge,
  calc_charm_healing = calc_charm_healing,
  calc_charm_shattering = calc_charm_shattering
}

