local game_api = require './api'

local nodes = {}

local function get_node(pos)
  for _, node in ipairs(nodes) do
    if node.pos.x == pos.x and node.pos.y == node.pos.y and node.pos.z == pos.z then
      return node
    end
  end
end

local function set_node(pos, opts)
  local node = get_node(pos)
  if node then
    node.pos = pos
    node.opts = opts
    node.name = opts.name
    return
  end
  table.insert(nodes, {pos=pos, opts=opts, name=opts.name})
end

local function print_nodes(x, z, end_x, end_z, y)
  local message = ""
  for j=1, end_z-z do
    for i=1, end_x-x do
      local px = i + x - 1
      local pz = j + z - 1
      local node = get_node({x=px, y=y, z=pz})
      if node then
        if node.name=="downstair" then
          message = message .. ">"
        elseif node.name=="upstair" then
          message = message .. "<"
        else
          message = message .. "#"
        end
      else
        message = message .. "."
      end
    end
    message = message .. "\n"
  end
  print(message)
end

local test = {
  {{downStair = {x = 0, y = 0}}, {upStair = {x = 5, y = 0}}},
  {{downStair = {x = 0, y = 0}}, {upStair = {x = 5, y = 5}}},
  {{downStair = {x = 0, y = 0}}, {upStair = {x = 0, y = 5}}},
  {{downStair = {x = 0, y = 0}}, {upStair = {x =-5, y = 5}}},
  {{downStair = {x = 0, y = 0}}, {upStair = {x =-5, y = 0}}},
  {{downStair = {x = 0, y = 0}}, {upStair = {x =-5, y =-5}}},
  {{downStair = {x = 0, y = 0}}, {upStair = {x = 0, y =-5}}},
  {{downStair = {x = 0, y = 0}}, {upStair = {x = 5, y =-5}}},
}

local testup = {
  {{downStair = {x = 5, y = 0}}, {upStair = {x = 0, y = 0}}},
  {{downStair = {x = 5, y = 5}}, {upStair = {x = 0, y = 0}}},
  {{downStair = {x = 0, y = 5}}, {upStair = {x = 0, y = 0}}},
  {{downStair = {x =-5, y = 5}}, {upStair = {x = 0, y = 0}}},
  {{downStair = {x =-5, y = 0}}, {upStair = {x = 0, y = 0}}},
  {{downStair = {x =-5, y =-5}}, {upStair = {x = 0, y = 0}}},
  {{downStair = {x = 0, y =-5}}, {upStair = {x = 0, y = 0}}},
  {{downStair = {x = 5, y =-5}}, {upStair = {x = 0, y = 0}}},
}

local function main ()
  for _,levels in ipairs(test) do
    nodes = {}
    set_node({x=levels[1].downStair.x, y=0, z=levels[1].downStair.y}, {name="downstair"})
    set_node({x=levels[2].upStair.x, y=0, z=levels[2].upStair.y}, {name="upstair"})

    game_api.connectLevels(levels, 1,2, set_node)
    print_nodes(-10, -10, 10, 10, 0)
  end

  print('\n\ntest moving downstairs')
  for _,levels in ipairs(testup) do
    nodes = {}
    set_node({x=levels[1].downStair.x, y=0, z=levels[1].downStair.y}, {name="downstair"})
    set_node({x=levels[2].upStair.x, y=0, z=levels[2].upStair.y}, {name="upstair"})

    game_api.connectLevels(levels, 1,2, set_node)
    print_nodes(-10, -10, 10, 10, 0)
  end
end

print('test')
main()
