-- wooden bow
bows.register_bow("bow_wood",{
  description = "Wooden bow",
  texture = "bows_bow.png",
  texture_loaded = "bows_bow_loaded.png",
  uses = 50,
  level = 1,
  craft = {
    {"", "group:stick", "farming:string"},
    {"group:stick", "", "farming:string"},
    {"", "group:stick", "farming:string"}
  }
})



-- wooden arrow
bows.register_arrow("arrow",{
  description = "Arrow",
  texture = "bows_arrow_wood.png",
  damage = 2,
  damage_max = 4,
  craft_count = 4,
  drop_chance = 40,
  craft = {
    {"mapgen:stone", "group:stick", "mapgen:leaves"}
  },
  on_hit_sound = "bows_arrow_hit"
})

bows.register_arrow("steel_arrow",{
  description = "Steel Arrow",
  texture = "bows_arrow_steel.png",
  damage = 3,
  damage_max = 11,
  craft_count = 4,
  drop_chance = 40,
  craft = {
    {"mapgen:steel", "group:stick", "mapgen:leaves"}
  },
  on_hit_sound = "bows_arrow_hit"
})

bows.register_arrow("fire_arrow",{
  description = "Fire Arrow",
  texture = "bows_arrow_wood.png",
  damage = 1,
  damage_max = 2,
  craft_count = 4,
  drop_chance = 40,
  craft = {
    {"mapgen:stone", "group:stick", "mapgen:leaves"}
  },
  on_hit_sound = "bows_arrow_hit",
  on_hit_node = function(_self, pos, _user, _oldpos)
    -- find a nearby air node and turn it into fire
    local pa = minetest.find_node_near(pos, 1, {"air"})
    if pa then
      minetest.set_node(pa, {name = 'fire:basic_flame'})
    end
  end,
  on_hit_object = function(_self, target, _hp, _user, pos)
    -- set the target on fire
    -- if they are near flammable nodes
    -- those will light up too
    mcl_burning.set_on_fire(target, 7)

    -- Also light a near by air node on fire too
    local pa = minetest.find_node_near(pos, 1, {"air"})
    if pa then
      minetest.set_node(pa, {name = 'fire:basic_flame'})
    end
  end
})


-- I used these to test - they don't spawn in the game
bows.register_arrow("shattering_arrow",{
  description = "Shattering Arrow",
  texture = "bows_arrow_wood.png",
  damage = 1,
  craft_count = 4,
  drop_chance = 90,
  craft = {
    {"mapgen:stone", "group:stick", "mapgen:leaves"}
  },
  on_hit_sound = "bows_arrow_hit",
  on_hit_node = function(_self, pos, _user, _arrow_pos)
    mg_effects.shattering({pos = pos, radius = 5})
  end,
  on_hit_object = function(_self, _target, _hp, _user, arrow_pos)
    mg_effects.shattering({pos = arrow_pos, radius = 5})
    minetest.add_particle({
      pos = arrow_pos,
      velocity = {x=0, y=0, z=0},
      acceleration = {x=0, y=0, z=0},
      expirationtime = 1,
      size = 4,
      collisiondetection = false,
      vertical = false,
      texture = "heart.png",
    })
  end
})

bows.register_arrow("descent_arrow",{
  description = "Descent Arrow",
  texture = "bows_arrow_wood.png",
  damage = 1,
  craft_count = 4,
  drop_chance = 90,
  craft = {
    {"mapgen:stone", "group:stick", "mapgen:leaves"}
  },
  on_hit_sound = "bows_arrow_hit",
  on_hit_node = function(_self, pos, _user, _arrow_pos)
    mg_effects.descent({pos = pos, radius = 4})
  end,
  on_hit_object = function(_self, _target, _hp, _user, arrow_pos)
    mg_effects.descent({pos = arrow_pos, radius = 5})
  end
})

bows.register_arrow("fireball_arrow",{
  description = "Fireball Arrow",
  texture = "bows_arrow_wood.png",
  damage = 1,
  craft_count = 4,
  drop_chance = 90,
  craft = {
    {"mapgen:stone", "group:stick", "mapgen:leaves"}
  },
  on_hit_sound = "bows_arrow_hit",
  on_hit_node = function(_self, _pos, _user, arrow_pos)
    mg_effects.fireball({pos = arrow_pos, radius = 2})
  end,
  on_hit_object = function(_self, _target, _hp, _user, arrow_pos)
    mg_effects.fireball({pos = arrow_pos, radius = 2})
  end
})

bows.register_arrow("lichen_arrow",{
  description = "Lichen Arrow",
  texture = "bows_arrow_wood.png",
  damage = 1,
  craft_count = 4,
  drop_chance = 90,
  craft = {
    {"mapgen:stone", "group:stick", "mapgen:leaves"}
  },
  on_hit_sound = "bows_arrow_hit",
  on_hit_node = function(_self, _pos, _user, arrow_pos)
    mg_effects.lichen({pos = arrow_pos})
  end,
  on_hit_object = function(_self, _target, _hp, _user, arrow_pos)
    mg_effects.lichen({pos = arrow_pos})
  end
})

bows.register_arrow("obstruction_arrow",{
  description = "Obstruction Arrow",
  texture = "bows_arrow_wood.png",
  damage = 1,
  craft_count = 4,
  drop_chance = 90,
  craft = {
    {"mapgen:stone", "group:stick", "mapgen:leaves"}
  },
  on_hit_sound = "bows_arrow_hit",
  on_hit_node = function(_self, _pos, _user, arrow_pos)
    mg_effects.obstruction({pos = arrow_pos})
  end,
  on_hit_object = function(_self, _target, _hp, _user, arrow_pos)
    mg_effects.obstruction({pos = arrow_pos})
  end
})

