-- def.name
-- def.instruction
-- def.button
-- def.error_message_no_scroll
-- def.error_message_no_item
-- def.error_message_no_type
-- def.apply_scroll
-- def.description
-- def.image

local _contexts = {}

local function get_context(ctx_name)
  local context = _contexts[ctx_name] or {}
  _contexts[ctx_name] = context
  return context
end

local function register_enhancement_scroll(name, def)
  def.name = name


  local function get_formspec(ctx)
    local formspec =
    "size[8,10]" ..
    "label[0,0;"..def.instruction.."]" ..
    "list[current_player;"..name..";0,1;8,4;]" ..
    "button[0,2;3,1;"..name..";"..def.button.."]" ..
    "label[0,3;".. (ctx.error or '') .."]" ..
    "list[current_player;main;0,4.85;8,1;]" ..
    "list[current_player;main;0,6.08;8,3;8]" ..
    "listring[current_player;"..name.."]" ..
    "listring[current_player;main]"
    return formspec
  end

  local function show_form(user)
    local cn = user:get_player_name()
    local ctx = get_context(cn)
    core.show_formspec(cn, "mg_scrolls:"..def.name, get_formspec(ctx))
  end

  local function get_scroll(player)
    local inv = player:get_inventory()
    local size = inv:get_size("main")
    for i=1, size do
      local stack = inv:get_stack("main", i)
      local item_name = stack:get_name()
      if item_name == "mg_scrolls:"..def.name then
        return i
      end
    end
    return 0, def.error_message_no_scroll
  end

  local function apply_scroll(player)
    local inv = player:get_inventory()
    local stack = inv:get_stack(name, 1)
    local stack_name = stack:get_name()

    if not stack_name or stack_name == '' then
      return nil, def.error_message_no_item
    end

    local result = def.apply_scroll(stack_name, stack)

    if result then
      return result
    end

    return nil, def.error_message_no_type
  end

  core.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= "mg_scrolls:"..def.name then
      return
    end

    if not fields[def.name] then
      return
    end


    local inv = player:get_inventory()
    local cn = player:get_player_name()
    local ctx = get_context(cn)


    local idx, err2 = get_scroll(player)
    if err2 then
      ctx.error = err2
      show_form(player)
      return
    end

    local source, err1 = apply_scroll(player)
    if err1 then
      ctx.error = err1
      show_form(player)
      return
    end

    -- remove protect weapon scroll from main inventory
    inv:set_stack("main", idx, nil)
    -- remove item from protect inventory
    inv:set_stack(def.name, 1, nil)
    -- add protected weapon to main inventory
    inv:add_item("main", source)


    -- clear any errors
    ctx.error = ""
    core.close_formspec(cn, "mg_scrolls:"..def.name)
  end)

  core.register_craftitem("mg_scrolls:"..def.name, {
    description = def.description,
    inventory_image = def.image,
    stack_max = 1,
    range = 1.5,
    on_use = function(_itemstack, user, _pointed_thing)
      show_form(user)
    end
  })

  core.register_on_joinplayer(function(player)
    local pn = player:get_player_name()
    local inv = core.get_inventory({type = 'player', name = pn})
    inv:set_size(def.name, 1)
  end)
end


register_enhancement_scroll("protect_weapon", {
  description = "Scroll of Protect Weapon",
  image = "voxeldungeon_item_scroll_yngvi.png",

  instruction = "Place a weapon below to protect it.",
  button = "Protect Weapon",
  error_message_no_scroll = "Protection failed.  You need a scroll of protect weapon in your inventory.",
  error_message_no_item = "Protect weapon failed. You need to put something in the slot to protect it.",
  error_message_no_type = "Protect weapon failed. This scroll only protects weapons.",
  apply_scroll = function(name, stack)
    if string.find(name, "mg_tools") then
      return mg_tools.protect_weapon(stack)
    end
    return nil
  end,
})

register_enhancement_scroll("protect_armor", {
  description = "Scroll of Protect Armor",
  image = "voxeldungeon_item_scroll_raido.png",

  instruction = "Place armor below to protect it.",
  button = "Protect Armor",
  error_message_no_scroll = "Protection failed.  You need a scroll of protect armor in your inventory.",
  error_message_no_item = "Protect armor failed. You need to put something in the slot to protect it.",
  error_message_no_type = "Protect armor failed. This scroll only protects armor.",
  apply_scroll = function(name, stack)
    if string.find(name, "mg_armor") then
      return mg_armor.protect_armor(stack)
    end
    return nil
  end,
})

register_enhancement_scroll("enchant", {
  description = "Scroll of Enchantment",
  image = "voxeldungeon_item_scroll_tiwaz.png",

  instruction = "Place an item below to enchant it and permanently upgrade it. \nYou can enchant weapons, armor, staves, wands, charms and rings.",
  button = "Enchant",
  error_message_no_scroll = "Enchantment failed. You need an enchantment scroll in your inventory to enchant an item.",
  error_message_no_item = "Enchantment failed. You need to put something in the enchantment slot to enchant.",
  error_message_no_type = "Enchantment failed. You can only enchant weapons, armor, staves, wands, charms and rings.",
  apply_scroll = function(name, stack)
    if string.find(name, "mg_tools") then
      return mg_tools.enchant_weapon(stack, 1, true)
    end

    if string.find(name, "mg_armor") then
      return mg_armor.enchant_armor(stack, 1, true)
    end

    if string.find(name, "charm") then
      return mg_bolts.enchant_charm(stack)
    end

    if string.find(name, "staff") then
      return mg_bolts.enchant_staff(stack)
    end

    if string.find(name, "wand") then
      return mg_bolts.enchant_wand(stack)
    end

    if string.find(name, "mg_rings") then
      return mg_rings.enchant_ring(stack, 1, true)
    end

    return nil
  end,
})

local function identify(stack)
  local meta = stack:get_meta()
  local is_identified = meta:get_int("identified")

  -- don't want player to waste a scroll on something already identified
  -- though - error message will be wrong...
  if is_identified > 0 then
    return nil
  end

  meta:set_int("identified", 1)

  return stack
end

register_enhancement_scroll("identity", {
  description = "Scroll of Identity",
  image = "voxeldungeon_item_scroll_isaz.png",

  instruction = "Place an object below to identify it",
  button = "Identify",
  error_message_no_scroll = "Identification failed.  You need a scroll of identity in your inventory.",
  error_message_no_item = "Identification failed. You need to put something in the slot to identify it.",
  error_message_no_type = "Identification failed. This item is already identified.",
  apply_scroll = function(name, stack)
    if string.find(name, "mg_tools") then
      return mg_tools.update_desc(identify(stack))
    elseif string.find(name, "mg_armor") then
      -- mg armor update desc returns the desc not the stack...
      mg_armor.update_desc(identify(stack))
      return stack
    elseif string.find(name, "mg_rings") then
      -- mg armor update desc returns the desc not the stack...
      mg_rings.update_desc(identify(stack))
      return stack
    end
    return nil
  end,
})
