local startY = 0

local function uuid()
  local template ='xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'
  return string.gsub(template, '[xy]', function (c)
    local v = (c == 'x') and math.random(0, 0xf) or math.random(8, 0xb)
    return string.format('%x', v)
  end)
end


local function spawn(pos, monster, id)
  local obj = core.add_entity(pos, 'mg_mobs:'..monster)
  local mob = obj:get_luaentity()
  mob.mg_id = id or uuid()
  return obj
end


local function spawnMonsters(depth, monsters)
  local baseY = -11 * (depth - 1) + startY + 6

  for _,monst in pairs(monsters) do
    local pos = {x=monst.x, y = baseY, z = monst.y}
    if monst.monsterType then
      core.after(0.5, function()
        local message = 'spawn monster at depth '.. depth .. ' of type ' .. monst.monsterType
        local obj = spawn(pos, monst.monsterType, monst.monsterId)
        local mob = obj:get_luaentity()
        mob.leader_id = monst.leaderId
        local id = mob.mg_id
        message = message .. ' added entity - id ' .. id .. ', leader id: ' .. mob.leader_id
        print(message)
      end)
    end
  end
end


-- This is dependant on the level
local function summon_horde(self)
  -- see if current summoned members are less than 5 then can summon more

  local minion_count = 0
	for _,obj in ipairs(self.nearby_objects) do
    local mob = obj:get_luaentity()
    if mob and mob.leader_id == self.mg_id then
      minion_count = minion_count + 1
    end
  end

  print('current minion count: ' .. minion_count)

  if minion_count >= 5 then
    print('no summon, too many minions')
    return
  end



  -- there's some logic that needs to be applies about how many
  -- minions are currently summoned and if monster can summon more
  local pos = mobkit.get_stand_pos(self)
  local depth = math.floor((pos.y - startY - 10) / (-11) + 1)
  local pmap = mg_arch.dungeon.pmaps[depth]

  local summoner = {
    monsterId = self.mg_id or uuid(),
    name = self.name:gsub("mg_mobs:", ""),
    x = math.floor(pos.x + 0.5),
    y = math.floor(pos.z + 0.5),
  }
  self.mg_id = summoner.monsterId

  local minions = mg_arch.monsters.summon_minions(pmap, summoner)

  spawnMonsters(depth, minions)
  mobkit.make_sound(self,'warn')
end

return {
  uuid = uuid,
  spawn = spawn,
  spawn_monsters = spawnMonsters,
  summon_horde = summon_horde
}

