-- dijkstraScan

local DCOLS = mg_arch.DCOLS
local DROWS = mg_arch.DROWS
local tf = mg_arch.terrainFlags

local PDS_OBSTRUCTION = -2
local PDS_FORBIDDEN = -1

local function createPdsLink()
  return {
    distance = 0,
    cost = 0,
    left = nil,
    right = nil
  }
end

local function createPdsLinkList()
  local links = {}
  for i=1, DCOLS*DROWS do
    links[i] = createPdsLink()
  end
  return links
end

local function createPdsMap()
  return {
    front = createPdsLink(),
    links = createPdsLinkList()
  }
end

local function getCell(links, x, y)
  return links[x + (y - 1) * DCOLS];
end

local function indexOf(array, value)
    for i, v in ipairs(array) do
        if v == value then
            return i
        end
    end
    return -1
end


local function printIdxCoor (idx)
  print('idx: ' .. idx)
  local x = idx % DCOLS
  local y = math.ceil(idx / DCOLS)
  print('x: ' .. x)
  print('y: ' .. y)
end

local function printLink (links, link)
  local linkIdx = indexOf(links, link)
  local leftIdx = indexOf(links, link.left)
  local rightIdx = indexOf(links, link.right)
  print('link idx: ' .. linkIdx)
  print('cost: ' .. link.cost)
  print('distance:  ' .. link.distance)
  print('left idx: ' .. leftIdx)
  print('right idx: ' .. rightIdx)
end


local function printLinks(links, x, y)
  local _link;
  local _i;
  local _j;
  for j=1, DROWS do
    local row = ""
    for i=1, DCOLS do
      local link = getCell(links, i, j)
      local cost = link.cost
      local char = '-'
      if cost == PDS_OBSTRUCTION then
        char = '.'
      elseif cost == PDS_FORBIDDEN then
        char = 'F'
      elseif cost == 0 then
        char = '#'
      elseif cost == 1 then
        char = ' '
      elseif cost == 2 then
        char = '+'
      end
      if link.distance == 0 then
        char = 'D'
      end
      if link.left ~=nil and link.right ~=nil then
        _link = link
        _i = i
        _j = j
        char = 'B'
      elseif link.left ~= nil then
        _link = link
        _i = i
        _j = j
        char = 'L'
      elseif link.right ~= nil then
        _link = link
        _i = i
        _j = j
        char = 'R'
      end
      if x == i and y == j then
        char = 'H'
      end
      row = row .. char
    end
    print(row)
  end
  -- print('link coor: ')
  -- printIdxCoor(indexOf(links, _link))
  -- print('i: ' .. _i)
  -- print('j: ' .. _j)
  -- if _link.left ~= nil then
    -- print('left coor')
    -- printIdxCoor(indexOf(links, _link.left))
  -- end
end

-- How do I test this????
-- I guess I could just run what I have through it
-- seems to work?
-- maybe I could require this one in?
local function pdsBatchInput(distanceMap, costMap, maxDistance)
  local map = createPdsMap();
  local left = nil
  local right = nil
  map.front.right = nil
  for i=1, DCOLS do
    for j=1, DROWS do
      local link = getCell(map.links, i, j)
      if distanceMap ~= nil then
        link.distance = distanceMap[i][j]
      else
        if costMap ~= nil then
          link.distance = maxDistance
        end
      end
      local cost
      if i == 1 or j == 1 or i == DCOLS or j == DROWS then
        cost = PDS_OBSTRUCTION
      elseif costMap == nil then
        -- TODO figure this out
        -- for now passing in a costmap
        -- so don't have to worry about cellHasTerrainFlag
        local hasFlags = false
        if hasFlags then
          cost = PDS_OBSTRUCTION
        else
          cost = PDS_FORBIDDEN
        end
      else
        cost = costMap[i][j]
      end
      link.cost = cost
      if cost > 0 then
        if link.distance < maxDistance then
          if right == nil or right.distance > link.distance then
            left = map.front
            right = map.front.right
          end
          while right ~= nil and right.distance < link.distance do
            left = right
            right = right.right
          end
          link.right = right
          link.left = left
          left.right = link
          if right ~= nil then
            right.left = link
          end
          left = link
        else
          link.right = nil
          link.left = nil
        end
      else
        link.right = nil
        link.left = nil
      end
    end
  end
  return map
end

local function processLink (map, dir, headIdx, head)
  local linkIdx = headIdx + (mg_arch.nbDirs[dir][1] + DCOLS * mg_arch.nbDirs[dir][2])
  -- test if out of range
  if (linkIdx < 1 or linkIdx > #map.links) then
    return
  end
  local link = map.links[linkIdx]

  -- verify passability
  if link.cost < 0 then
    return
  end
  if dir > 4 then
    local wayIdx1 = headIdx + mg_arch.nbDirs[dir][1]
    local wayIdx2 = headIdx + DCOLS * mg_arch.nbDirs[dir][2]
    local way1 = map.links[wayIdx1]
    local way2 = map.links[wayIdx2]
    if way1.cost == PDS_OBSTRUCTION and way2.cost == PDS_OBSTRUCTION then
      return
    end
  end
  if head.distance + link.cost < link.distance then
    link.distance = head.distance + link.cost
    if link.right ~= nil then
      link.right.left = link.left
    end
    if link.left ~= nil then
      link.left.right = link.right
    end
    local left = head
    local right = head.right
    while right ~= nil and right.distance < link.distance do
      left = right
      right = right.right
    end
    if left ~= nil then
      left.right = link
    end
    link.right = right
    link.left = left
    if right ~= nil then
      right.left = link
    end
  end
end

-- There's a bug somewhere in this because it gets in an infinte loop
-- not sure how to get out - it matches up the C code pretty well as far as I can tell
local function pdsUpdate(map, useDiagonals)
  local dirs = mg_arch.tern(useDiagonals, 8, 4)
  local head = map.front.right
  map.front.right = nil
  -- The c code uses pointer arithmatic -
  -- I can do the same with index values
  while head ~= nil do
    local headIdx = indexOf(map.links, head)
    local x = (headIdx - 1) % DCOLS + 1
    local y = math.ceil(headIdx / DCOLS)
    for dir = 1, dirs do
      processLink(map, dir, headIdx, head)
    end
    local right = head.right
    head.left = nil
    head.right = nil
    head = right
  end
end

local function pdsBatchOutput(map, distanceMap, useDiagonals)
  pdsUpdate(map, useDiagonals)
  for i=1, DCOLS do
    for j=1, DROWS do
      distanceMap[i][j] = getCell(map.links, i, j).distance
    end
  end
end

local function pdsClear(map, maxDistance)
  for i=1, DCOLS*DROWS do
    local link = map.links[i]
    link.distance = maxDistance
    link.right = nil
    link.left = nil
  end
end

local function calculateDistances(pmap, distanceMap,
  destinationX, destinationY,
  blockingTerrainFlags,
  eightWays)
  local costMap = mg_arch.allocGrid()
  for i=1, DCOLS do
    for j=1, DROWS do
      local cost
      if mg_arch.cellHasTerrainFlag(pmap, i, j, tf.T_OBSTRUCTS_PASSABILITY) then
        cost = mg_arch.tern(mg_arch.cellHasTerrainFlag(pmap, i, j, tf.T_OBSTRUCTS_DIAGONAL_MOVEMENT),
                            PDS_OBSTRUCTION, PDS_FORBIDDEN)
      elseif mg_arch.cellHasTerrainFlag(pmap, i, j, blockingTerrainFlags) then
        cost = PDS_FORBIDDEN
      else
        cost = 1
      end
      costMap[i][j] = cost
    end
  end

  mg_arch.fillGrid(distanceMap, 30000)
  distanceMap[destinationX][destinationY] = 0

  local map = pdsBatchInput(distanceMap, costMap, 30000)
  pdsBatchOutput(map, distanceMap, eightWays)
end

local function dijkstraScan(distanceMap, costMap, useDiagonals)
  local map = pdsBatchInput(distanceMap, costMap, 30000)
  pdsBatchOutput(map, distanceMap, useDiagonals)
end

local function pathingDistance(pmap, x1, y1, x2, y2, blockingTerrainFlags)
  local distanceMap = mg_arch.allocGrid()
  calculateDistances(pmap, distanceMap, x2, y2, blockingTerrainFlags, nil, true, true)
  local retval = distanceMap[x1][y1]
  return retval
end

mg_arch.dijkstra = {}
mg_arch.dijkstra.scan = dijkstraScan
mg_arch.dijkstra.pathingDistance = pathingDistance
