

How monster states are displayed:
```
} else if (monst->bookkeepingFlags & MB_CAPTIVE && y < ROWS - 1) {
    printString("     (Captive)      ", 0, y++, (dim ? &darkGray : &gray), &black, 0);
} else if ((monst->info.flags & MONST_RESTRICTED_TO_LIQUID)
           && !cellHasTMFlag(monst->loc.x, monst->loc.y, TM_ALLOWS_SUBMERGING)) {
    printString("     (Helpless)     ", 0, y++, (dim ? &darkGray : &gray), &black, 0);
} else if (monst->creatureState == MONSTER_SLEEPING && y < ROWS - 1) {
    printString("     (Sleeping)     ", 0, y++, (dim ? &darkGray : &gray), &black, 0);
} else if ((monst->creatureState == MONSTER_ALLY) && y < ROWS - 1) {
    printString("       (Ally)       ", 0, y++, (dim ? &darkGray : &gray), &black, 0);
} else if (monst->creatureState == MONSTER_FLEEING && y < ROWS - 1) {
    printString("     (Fleeing)      ", 0, y++, (dim ? &darkGray : &gray), &black, 0);
} else if ((monst->creatureState == MONSTER_WANDERING) && y < ROWS - 1) {
    if ((monst->bookkeepingFlags & MB_FOLLOWER) && monst->leader && (monst->leader->info.flags & MONST_IMMOBILE)) {
        // follower of an immobile leader -- i.e. a totem
        printString("    (Worshiping)    ", 0, y++, (dim ? &darkGray : &gray), &black, 0);
    } else if ((monst->bookkeepingFlags & MB_FOLLOWER) && monst->leader && (monst->leader->bookkeepingFlags & MB_CAPTIVE)) {
        // actually a captor/torturer
        printString("     (Guarding)     ", 0, y++, (dim ? &darkGray : &gray), &black, 0);
    } else {
        printString("    (Wandering)     ", 0, y++, (dim ? &darkGray : &gray), &black, 0);
    }
} else if (monst->ticksUntilTurn > max(0, player.ticksUntilTurn) + player.movementSpeed) {
    printString("   (Off balance)    ", 0, y++, (dim ? &darkGray : &gray), &black, 0);
} else if ((monst->creatureState == MONSTER_TRACKING_SCENT) && y < ROWS - 1) {
    printString("     (Hunting)      ", 0, y++, (dim ? &darkGray : &gray), &black, 0);
```

If monster is aware of you
```
boolean awareOfTarget(creature *observer, creature *target) {
    short perceivedDistance = awarenessDistance(observer, target);
    short awareness = rogue.stealthRange * 2;
    boolean retval;

    brogueAssert(perceivedDistance >= 0 && awareness >= 0);

    if (observer->info.flags & MONST_ALWAYS_HUNTING) {
        retval = true;
    } else if (observer->info.flags & MONST_IMMOBILE) {
        // Turrets and totems are aware of you iff they are within stealth range.
        // The only exception is mirror totems; they're always ready to shoot because they have "always hunting" set.
        retval = perceivedDistance <= awareness;
    } else if (perceivedDistance > awareness * 3) {
        // out of awareness range, even if hunting
        retval = false;
    } else if (observer->creatureState == MONSTER_TRACKING_SCENT) {
        // already aware of the target, lose track 3% of the time if outside of stealth range.
         if (perceivedDistance > awareness) {
             retval = rand_percent(97);
         } else {
            retval = true;
         }
    } else if (target == &player
        && !(pmap[observer->loc.x][observer->loc.y].flags & IN_FIELD_OF_VIEW)) {
        // observer not hunting and player-target not in field of view
        retval = false;
    } else if (perceivedDistance <= awareness) {
        // within range but currently unaware
        retval = rand_percent(25);
    } else {
        retval = false;
    }
    return retval;
}
```


Look here: `void updateMonsterState(creature *monst) {` for monster state transitions
Another good one: `void monstersTurn(creature *monst) {` for how situations within states are handled




-- Light code
rogue.minersLightRadius = (DCOLS - 1) * FP_FACTOR;
for (i = 0; i < rogue.depthLevel; i++) {
    rogue.minersLightRadius = rogue.minersLightRadius * DEPTH_ACCELERATOR * 85 / 100;
}
rogue.minersLightRadius += FP_FACTOR * 225 / 100;
