--
-- Tree
-- Need to fix to work with this mod and game

minetest.register_node("mg_mapgen:tree", {
	description = "Apple Tree",
	tiles = {"mapgen_tree_top.png", "mapgen_tree_top.png", "mapgen_tree.png"},
	paramtype2 = "facedir",
	is_ground_content = false,
	groups = {tree = 1, choppy = 2, flammable = 2, opaque = 1},
	sounds = mg_media.node_sound_wood_defaults(),

	on_place = minetest.rotate_node
})


minetest.register_node("mg_mapgen:wood", {
	description = "Apple Wood Planks",
	paramtype2 = "facedir",
	place_param2 = 0,
	tiles = {"mapgen_wood.png"},
	is_ground_content = false,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 2, wood = 1, opaque = 1},
	drop = "",
	sounds = mg_media.node_sound_wood_defaults(),
})

minetest.register_node("mg_mapgen:carve", {
	description = "Dungeon Start",
	paramtype2 = "facedir",
	place_param2 = 0,
	tiles = {"mcl_enchanting_table_top.png"},
	is_ground_content = false,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 2, wood = 1, opaque = 1},
	sounds = mg_media.node_sound_wood_defaults(),
})

minetest.register_node("mg_mapgen:sapling", {
	description = "Apple Tree Sapling",
	drawtype = "plantlike",
	tiles = {"mapgen_sapling.png"},
	inventory_image = "mapgen_sapling.png",
	wield_image = "mapgen_sapling.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	on_timer = grow_sapling,
	selection_box = {
		type = "fixed",
		fixed = {-4 / 16, -0.5, -4 / 16, 4 / 16, 7 / 16, 4 / 16}
	},
	groups = {snappy = 2, dig_immediate = 3, flammable = 2,
		attached_node = 1, sapling = 1},
	sounds = mg_media.node_sound_leaves_defaults(),

	on_construct = function(pos)
		minetest.get_node_timer(pos):start(math.random(300, 1500))
	end,
})

minetest.register_node("mg_mapgen:leaves", {
	description = "Apple Tree Leaves",
	drawtype = "allfaces_optional",
	waving = 1,
	tiles = {"mapgen_leaves.png"},
	special_tiles = {"mapgen_leaves_simple.png"},
	paramtype = "light",
	is_ground_content = false,
	groups = {snappy = 3, leafdecay = 3, flammable = 2, leaves = 1},
	drop = "",
	sounds = mg_media.node_sound_leaves_defaults(),

	after_place_node = after_place_leaves,
})

minetest.register_node("mg_mapgen:apple", {
	description = "Apple",
	drawtype = "plantlike",
	tiles = {"mapgen_apple.png"},
	inventory_image = "mapgen_apple.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	is_ground_content = false,
	selection_box = {
		type = "fixed",
		fixed = {-3 / 16, -7 / 16, -3 / 16, 3 / 16, 4 / 16, 3 / 16}
	},
	groups = {fleshy = 3, dig_immediate = 3, flammable = 2,
		leafdecay = 3, leafdecay_drop = 1, food_apple = 1},
	on_use = minetest.item_eat(10),
	sounds = mg_media.node_sound_leaves_defaults(),

	after_place_node = function(pos, placer, itemstack)
		minetest.set_node(pos, {name = "mg_mapgen:apple", param2 = 1})
	end,

	after_dig_node = function(pos, oldnode, oldmetadata, digger)
		if oldnode.param2 == 0 then
			minetest.set_node(pos, {name = "mg_mapgen:apple_mark"})
			minetest.get_node_timer(pos):start(math.random(300, 1500))
		end
	end,
})

minetest.register_node("mg_mapgen:apple_mark", {
	description = "Apple Marker",
	inventory_image = "mapgen_apple.png^mapgen_invisible_node_overlay.png",
	wield_image = "mapgen_apple.png^mapgen_invisible_node_overlay.png",
	drawtype = "airlike",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	drop = "",
	groups = {not_in_creative_inventory = 1},
	on_timer = function(pos, elapsed)
		if not minetest.find_node_near(pos, 1, "mg_mapgen:leaves") then
			minetest.remove_node(pos)
		elseif minetest.get_node_light(pos) < 11 then
			minetest.get_node_timer(pos):start(200)
		else
			minetest.set_node(pos, {name = "mg_mapgen:apple"})
		end
	end
})


minetest.register_craftitem("mg_mapgen:food_ration", {
	description = "Ration of Food",
	inventory_image = "farming_bread.png",
	groups = {book = 1, flammable = 3},
	on_use = core.item_eat(20),
  range = 1.5,
})


minetest.register_craft({
	output = "mg_mapgen:wood 4",
	recipe = {
		{"mg_mapgen:tree"}
	}
})


minetest.register_node("mg_mapgen:pedistal",{
    description="crystal pedistal original empty",
    tiles={"mcl_blackstone_basalt_smooth.png"},
    drawtype="mesh",
    mesh="regulus_pedistal.obj",
    --groups={undiggable=1,not_in_creative_inventory=1},
    paramtype="light",
    light_source=14,
})


minetest.register_node("mg_mapgen:gold_pile_1", {
  description = "Gold Pile",
  drawtype = "mesh",
  inventory_image = "default_gold_block.png",
  pointable = true,
  walkable = false,
	groups = {crumbly = 3},
  mesh = "coins.obj",
  paramtype = "light",
  paramtype2 = "facedir",
  sunlight_propagates = true,
  tiles = {"default_gold_block.png"},
  on_dig = function(pos, _node, player)
    local meta = core.get_meta(pos)
    local gold_count = meta:get_int("gold")
    local inv = player:get_inventory()
    local stack = ItemStack('mg_mapgen:coins')
    stack:set_count(gold_count)
    inv:add_item('main', stack)

    -- Saved the total gold a player has in their
    -- metadata to save in the high score list later
    local stack_list = inv:get_list("main")

    local total_gold = 0
    for _, inner_stack in ipairs(stack_list) do
      if inner_stack:get_name() == "mg_mapgen:coins" then
        total_gold = total_gold + inner_stack:get_count()
      end
    end

    local pmeta = player:get_meta()
    pmeta:set_int("gold", total_gold)

    core.remove_node(pos)
  end
})

minetest.register_craftitem("mg_mapgen:coins", {
	description = "Coins",
	inventory_image = "coin.png",
	stack_max = 9999,
	groups = { coinvalue=1 },
  range = 1.5,
})

local function reg_rocks(index)
	local rocks_groups = {attached_node = 1, replaced_by_lichen = 1}

  minetest.register_node("mg_mapgen:loose_rocks_"..index, {
    description = "Loose Rocks",
    drawtype = "mesh",
    drop = "mg_mapgen:loose_rocks_1",
    groups = rocks_groups,
    inventory_image = "loose_rocks_inv.png",
	  pointable = false,
    mesh = "loose_rocks_" .. index ..".obj",
    paramtype = "light",
    paramtype2 = "facedir",
    selection_box = {
      type = "fixed",
      fixed = {-0.5, -0.5, -0.5, 0.5, -0.3125, 0.5},
    },
    sunlight_propagates = true,
    tiles = {"mapgen_cobble.png"},
    walkable = false,
  })
end

reg_rocks(1)
reg_rocks(2)

local dirs = {
  {1, 0},
  {0, 1},
  {-1, 0},
  {0, -1},
}

minetest.register_node("mg_mapgen:deadly_lichen", {
	description = "Deadly Lichen",
	drawtype = "plantlike",
	tiles = { "mcl_crimson_crimson_roots.png" },
	inventory_image = "mcl_crimson_crimson_roots.png",
	sunlight_propagates = true,
	walkable = false,
	paramtype = "light",
	light_source = 6,
  pointable = false,
	buildable_to = true,
	groups = {flammable = 2, poisons = 5, flora = 1},
	sounds = mg_media.node_sound_leaves_defaults(),
	selection_box = {
		type = "fixed",
		fixed = { -6/16, -0.5, -6/16, 6/16, -4/16, 6/16 },
	},
  on_timer = function(pos)
    local ct = 0
    for i=1,4 do
      local dir = dirs[i]
      local test_pos = {x = dir[1] + pos.x, y = pos.y, z = pos.z + dir[2]}
      local ground_pos = {x = dir[1] + pos.x, y = pos.y - 1, z = pos.z + dir[2]}
      local node = core.get_node(test_pos)
      local ground_node = core.get_node(ground_pos)
      if (node.name == 'air' or core.get_item_group(node.name, 'replaced_by_lichen') > 0) and
          core.get_item_group(ground_node.name, 'cracky') > 0 then
        core.set_node(test_pos, {name = 'mg_mapgen:deadly_lichen'})
      else
        ct = ct + 1
      end
    end
    if ct < 4 then
      return true
    end
    return false
  end,
  on_construct = function(pos)
    minetest.get_node_timer(pos):start(math.random(5, 10))
  end
})


minetest.register_node("mg_mapgen:crimson_roots", {
	description = "Crimson Roots",
	drawtype = "plantlike",
	tiles = { "mcl_crimson_warped_roots.png" },
	inventory_image = "mcl_crimson_warped_roots.png",
	sunlight_propagates = true,
	walkable = false,
	paramtype = "light",
	light_source = 6,
  pointable = false,
	buildable_to = true,
	groups = {flammable = 2, replaced_by_lichen = 1, flora = 1},
	sounds = mg_media.node_sound_leaves_defaults(),
	selection_box = {
		type = "fixed",
		fixed = { -6/16, -0.5, -6/16, 6/16, -4/16, 6/16 },
	},
	node_placement_prediction = ""
})


-- Taken from MCL2 code base
local function add_large_plant(name, desc, longdesc, bottom_img, top_img, inv_img, selbox_radius, selbox_top_height, drop, shears_drop, is_flower, grass_color, fortune_drop)
	if not inv_img then
		inv_img = top_img
	end
	local create_entry, paramtype2, palette
	if is_flower == nil then
		is_flower = true
	end

	local bottom_groups = {
		attached_node = 1, deco_block = 1,
		dig_by_water = 1, destroy_by_lava_flow = 1, dig_by_piston = 1,
		flammable = 2, fire_encouragement = 60, fire_flammability = 100,
		plant = 1, double_plant = 1, non_mycelium_plant = 1, compostability = 65, grass_palette = nil,
    replaced_by_lichen = 1
	}

  bottom_groups.place_flowerlike = 2
  bottom_groups.handy = 1
  bottom_groups.shearsy = 1
  bottom_groups.flora = 1

  paramtype2 = "color"
  palette = "mcl_core_palette_grass.png"
  bottom_groups.grass_palette = grass_color

	minetest.register_node("mg_mapgen:"..name, {
		description = desc,
		drawtype = "plantlike",
		tiles = { bottom_img },
		inventory_image = inv_img,
		wield_image = inv_img,
		sunlight_propagates = true,
		paramtype = "light",
		paramtype2 = paramtype2,
		palette = palette,
		walkable = false,
    pointable = false,
		buildable_to = true,
		node_placement_prediction = "",
    param2 = grass_color or 1,
		selection_box = {
			type = "fixed",
			fixed = { -selbox_radius, -0.5, -selbox_radius, selbox_radius, 0.5, selbox_radius },
		},
		on_place = function(itemstack, placer, pointed_thing)
			-- We can only place on nodes
			if pointed_thing.type ~= "node" then
				return
			end

			local itemstring = "mg_mapgen:"..name

			-- Call on_rightclick if the pointed node defines it
			local node = minetest.get_node(pointed_thing.under)
			if placer and not placer:get_player_control().sneak then
				if minetest.registered_nodes[node.name] and minetest.registered_nodes[node.name].on_rightclick then
					return minetest.registered_nodes[node.name].on_rightclick(pointed_thing.under, node, placer, itemstack) or itemstack
				end
			end

			-- Check for a floor and a space of 1×2×1
			local ptu_node = minetest.get_node(pointed_thing.under)
			local bottom
			if not minetest.registered_nodes[ptu_node.name] then
				return itemstack
			end
			if minetest.registered_nodes[ptu_node.name].buildable_to then
				bottom = pointed_thing.under
			else
				bottom = pointed_thing.above
			end
			if not minetest.registered_nodes[minetest.get_node(bottom).name] then
				return itemstack
			end
			local top = { x = bottom.x, y = bottom.y + 1, z = bottom.z }
			local bottom_buildable = minetest.registered_nodes[minetest.get_node(bottom).name].buildable_to
			local top_buildable = minetest.registered_nodes[minetest.get_node(top).name].buildable_to
			local floor = minetest.get_node({x=bottom.x, y=bottom.y-1, z=bottom.z})
			if not minetest.registered_nodes[floor.name] then
				return itemstack
			end

			local light_night = minetest.get_node_light(bottom, 0.0)
			local light_day = minetest.get_node_light(bottom, 0.5)
			local light_ok = false
			if (light_night and light_night >= 8) or (light_day and light_day >= minetest.LIGHT_MAX) then
				light_ok = true
			end

			-- Placement rules:
			-- * Allowed on dirt or grass block
			-- * If not a flower, also allowed on podzol and coarse dirt
			-- * Only with light level >= 8
			-- * Only if two enough space
			if (floor.name == "mg_mapgen:grass" or floor.name == "mg_mapgen:dirt") and bottom_buildable and top_buildable and light_ok then
				local param2
				if grass_color then
					param2 = grass_color
				end
				-- Success! We can now place the flower
				minetest.sound_play(minetest.registered_nodes[itemstring].sounds.place, {pos = bottom, gain=1}, true)
				minetest.set_node(bottom, {name=itemstring, param2=param2})
				minetest.set_node(top, {name=itemstring.."_top", param2=param2})
				if not minetest.is_creative_enabled(placer:get_player_name()) then
					itemstack:take_item()
				end
			end
			return itemstack
		end,
		after_destruct = function(pos, oldnode)
			-- Remove top half of flower (if it exists)
			local bottom = pos
			local top = { x = bottom.x, y = bottom.y + 1, z = bottom.z }
			if minetest.get_node(bottom).name ~= "mg_mapgen:"..name and minetest.get_node(top).name == "mg_mapgen:"..name.."_top" then
				minetest.remove_node(top)
			end
		end,
		groups = bottom_groups,
		sounds = mg_media.node_sound_leaves_defaults(),
	})

	local top_groups = table.copy(bottom_groups)
	top_groups.not_in_creative_inventory=1
	top_groups.double_plant=2
	top_groups.attached_node=nil

	-- Top
	minetest.register_node("mg_mapgen:"..name.."_top", {
		description = desc.." " .. "(Top Part)",
		_doc_items_create_entry = false,
		drawtype = "plantlike",
		tiles = { top_img },
		sunlight_propagates = true,
		paramtype = "light",
		paramtype2 = paramtype2,
		palette = palette,
		walkable = false,
    pointable = false,
		buildable_to = true,
    param2 = grass_color or 1,
		selection_box = {
			type = "fixed",
			fixed = { -selbox_radius, -0.5, -selbox_radius, selbox_radius, selbox_top_height, selbox_radius },
		},
		drop = drop_top,
		after_destruct = function(pos, oldnode)
			-- Remove bottom half of flower (if it exists)
			local top = pos
			local bottom = { x = top.x, y = top.y - 1, z = top.z }
        if minetest.get_node(top).name ~= "mg_mapgen:"..name.."_top" and minetest.get_node(bottom).name == "mg_mapgen:"..name then
				minetest.remove_node(bottom)
			end
		end,
		groups = top_groups,
		sounds = mg_media.node_sound_leaves_defaults(),
	})
end

add_large_plant("double_fern", "Large Fern", "", "mcl_flowers_double_plant_fern_bottom.png", "mcl_flowers_double_plant_fern_top.png", "mcl_flowers_double_plant_fern_inv.png", 5/16, 5/16, "", {"mg_mapgen:fern 2"}, false, nil, "")

add_large_plant("double_grass", "Large Grass", "", "mcl_flowers_double_plant_grass_bottom.png", "mcl_flowers_double_plant_grass_top.png", "mcl_flowers_double_plant_grass_inv.png", 5/16, 5/16, "", {"mg_mapgen:grass 2"}, false, 20, "")


core.register_node("mg_mapgen:cobweb_old", {
	description = "Cobweb",
	drawtype = "plantlike",
	tiles = {"mcl_core_web.png"},
	inventory_image = "mcl_core_web.png",
	move_resistance = 10,
	paramtype = "light",
  sunlight_propagates = true,
	walkable = false,
  pointable = false,
	selection_box = {type = "regular"},
	groups = {snappy = 3, flammable = 3, cobweb = 1},
	is_ground_content = false,
	sounds = mg_media.node_sound_leaves_defaults()
})

minetest.register_node("mg_mapgen:cobweb", {
	description = "Cobweb",
	drawtype = "plantlike",
	paramtype2 = "degrotate",
	visual_scale = 1.1,
	tiles = {"mcl_core_web.png"},
	inventory_image = "mcl_core_web.png",
	paramtype = "light",
	liquid_viscosity = 14,
	liquidtype = "source",
	liquid_alternative_flowing = "mg_mapgen:cobweb",
	liquid_alternative_source = "mg_mapgen:cobweb",
	liquid_renewable = false,
	liquid_range = 0,
	walkable = false,
  pointable = false,
	groups = {snappy = 3, flammable = 3, cobweb = 1},
	sounds = mg_media.node_sound_leaves_defaults()
})

minetest.register_node("mg_mapgen:rock_1",{
  description = "boulder",
  drawtype = "mesh",
  --mesh = "nodes_nature_boulder.obj",
  mesh = "nodes_nature_cobble1.obj",
  tiles = {"mapgen_stone.png"},
  paramtype = "light",
  paramtype2 = "facedir",
  groups = {cracky = 1, falling_node = 1, boulder = 1},
	walkable = false,
	pointable = false,
  selection_box = {
    type = "fixed",
    fixed = {-7/16, -8/16, -7/16, 7/16, 7/16, 7/16},
  },
  collision_box = {
    type = "fixed",
    fixed = {-7/16, -8/16, -7/16, 7/16, 7/16, 7/16},
  },
  --sounds = mg_media.node_sound_stone_defaults(),
})

minetest.register_node("mg_mapgen:rock_2",{
  description = "Boulder",
  drawtype = "mesh",
  --mesh = "nodes_nature_boulder.obj",
  mesh = "nodes_nature_cobble2.obj",
  tiles = {"mapgen_stone.png"},
  paramtype = "light",
  paramtype2 = "facedir",
  groups = {cracky = 1, falling_node = 1, boulder = 1},
	walkable = false,
	pointable = false,
  selection_box = {
    type = "fixed",
    fixed = {-7/16, -8/16, -7/16, 7/16, 7/16, 7/16},
  },
  collision_box = {
    type = "fixed",
    fixed = {-7/16, -8/16, -7/16, 7/16, 7/16, 7/16},
  },
  --sounds = mg_media.node_sound_stone_defaults(),
})

minetest.register_node("mg_mapgen:rock_3",{
  description = "Boulder",
  drawtype = "mesh",
  --mesh = "nodes_nature_boulder.obj",
  mesh = "nodes_nature_cobble3.obj",
  tiles = {"mapgen_stone.png"},
  paramtype = "light",
  paramtype2 = "facedir",
  groups = {cracky = 1, falling_node = 1, boulder = 1},
	walkable = false,
	pointable = false,
  selection_box = {
    type = "fixed",
    fixed = {-7/16, -8/16, -7/16, 7/16, 7/16, 7/16},
  },
  collision_box = {
    type = "fixed",
    fixed = {-7/16, -8/16, -7/16, 7/16, 7/16, 7/16},
  },
  --sounds = mg_media.node_sound_stone_defaults(),
})

