minetest.register_entity("mg_mobs:vampire_bat",{
	physical = true,
	stepheight = 0.1,				--EVIL!
	collide_with_objects = true,
	collisionbox = {-0.3, -0.15 + 0.25, -0.3, 0.3, 0.15 + 0.25, 0.3},
	visual = "mesh",
	mesh = "animalia_bat.b3d",
	textures = {"animalia_bat_1.png"},
	visual_size = {x = 10, y = 10},
	static_save = true,
	makes_footstep_sound = true,
	on_step = mobkit.stepfunc,	-- required
	on_activate = mobkit.actfunc,		-- required
  physics = mg_mobs.fly_physics,
	get_staticdata = mobkit.statfunc,
											-- api props
	springiness=0,
	buoyancy = 0.9,
	max_speed = 10,
	jump_height = 1.26,
	view_range = 24,
	lung_capacity = 10,			-- seconds
	max_hp = 10,
  regen = 20,
  defense = 25,
  accuracy = 100,
	attack={range=1.2, damage_groups={fleshy=2, fleshy_max=6}},
	sounds = {
		scared='animalia_bat_1',
		hurt = 'animalia_bat_2',
  },
	animation = {
    run={range={x=51,y=69},speed=60,loop=true},
    walk={range={x=51,y=69},speed=30,loop=true},
    stand={range={x=1,y=40},speed=10,loop=true},
    fly={range={x=81,y=99},speed=80,loop=true},
    cling={range={x=110,y=110},speed=80,loop=true},
	},

	brainfunc = mg_mobs.mg_brain,

  bolts = { },
  behaviors = {
    flies = 1,
    flits = 1
  },
  abilities = {
    transference = 1
  },

	on_punch= mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:vampire_bat", "Vampire Bat", 1);
