-- Defined effects that can happen to the map
-- when reading a scroll, throwing a potion, or using a charm

local crystal = "mg_effects:crystal"
minetest.register_node(crystal ,{
	description = "Tinted Glass",
	tiles = {"mcl_amethyst_tinted_glass.png"},
	drawtype = "glasslike",
	use_texture_alpha = "blend",
	sunlight_propagates = false,
	groups = {handy = 1, building_block = 1, deco_block = 1},
	is_ground_content = false,
	light_source = 4
})

-- Use an ABM to get rid of the crystal
-- only if its exposed to air
core.register_abm({
  nodenames = {crystal},
  neighbors = {"air"},
  interval = 2,
  chance = 10,
  action = function(pos)
    core.set_node(pos, {name = "air"})
  end
})

-- TODO use MT groups for this
local to_crystal_list = {
  "mg_mapgen:sand",
  "mg_mapgen:stone",
  "mg_torch:light",
  "mg_mapgen:blackstone",
  "mg_mapgen:chasm_edge",
  "mg_mapgen:stone_block",
  "mg_mapgen:cobble",
  "mg_mapgen:mossycobble",
  crystal
}

local ignore_list = {
  "mg_ladder:ladder_wood",
  "mg_mapgen:water_source",
  "mg_mapgen:magma_source",
  'mg_chest:chest',
  'mg_mapgen:goldblock',
  'mg_mapgen:gold_pile_1',
  'mg_arch:crystal',
  'mg_game:crystal',
}

local function some(tbl, f)
  for _,v in ipairs(tbl) do
    if f(v) then
      return true
    end
  end
  return false
end


local function shattering(params)
  local radius = params.radius or 5
  local pos = params.pos or {x = 0, y = 0, z = 0}

  print('shatter radius '..radius)
  print('at x: '..params.pos.x..', y: '..params.pos.y..', z: '..(params.pos.z or 0))

  -- Turns walls, doors into glowing green crystals
  -- Could use that purplse stuff from librevox

  for i = 1, radius*2 do
    for j = 1, radius*2 do
      local x = i + pos.x - radius
      local z = j + pos.z - radius
      local baseY = pos.y

      local ti = i - radius - 1
      local tj = j - radius - 1
      if (ti*ti + tj*tj < radius * radius) then

        local list = {
          { x = x, y = baseY + 0, z = z },
          { x = x, y = baseY + 1, z = z },
          { x = x, y = baseY + 2, z = z },
          { x = x, y = baseY + 3, z = z },
          { x = x, y = baseY + 4, z = z },
        }

        for li = 1, #list do
          local node = core.get_node(list[li])
          local to_crystal = some(to_crystal_list, function(test_name)
            return test_name == node.name
          end)
          local ignore = some(ignore_list, function(test_name)
            return test_name == node.name
          end)
          if to_crystal then
            core.set_node(list[li], {name=crystal})
          elseif not ignore then
            -- Stuff like grass and stones
            core.set_node(list[li], {name='air'})
          end
        end
      end

    end
  end
end

local function fireball(params)
  local radius = params.radius or 5
  local pos = params.pos or {x = 0, y = 0, z = 0}

  for i = 1, radius*2 do
    for j = 1, radius*2 do
      local x = i + pos.x - radius
      local z = j + pos.z - radius
      local baseY = pos.y

      local ti = i - radius
      local tj = j - radius
      if (ti*ti + tj*tj < radius * radius) then

        local list = {
          { x = x, y = baseY + 3, z = z },
          { x = x, y = baseY + 2, z = z },
          { x = x, y = baseY + 1, z = z },
          { x = x, y = baseY + 0, z = z },
          { x = x, y = baseY - 1, z = z },
          { x = x, y = baseY - 2, z = z },
        }

        for li = 1, #list do
          local node = core.get_node(list[li])
          local nodedef = core.registered_nodes[node.name]
          if
            (node.name == 'air' or nodedef.drawtype == "airlike")
          then
            core.set_node(list[li], {name='fire:basic_flame'})
          end
        end
      end

    end
  end
end

local function descent(params)
  local radius = params.radius or 6
  local upper_radius = params.upper_radius or radius
  local pos = params.pos or {x = 0, y = 0, z = 0}
  local time_offset = 5

  for i = 1, upper_radius*2 do
    for j = 1, upper_radius*2 do
      local x = i + pos.x - upper_radius
      local z = j + pos.z - upper_radius
      local baseY = pos.y

      local ti = i - upper_radius
      local tj = j - upper_radius
      if (ti*ti + tj*tj < upper_radius * upper_radius) then

        local list = {
          { x = x, y = baseY + 3, z = z },
          { x = x, y = baseY + 2, z = z },
          { x = x, y = baseY + 1, z = z },
          { x = x, y = baseY + 0, z = z },
          { x = x, y = baseY - 1, z = z },
          { x = x, y = baseY - 2, z = z },
          { x = x, y = baseY - 3, z = z },
        }

        for li = 1, #list do
          local node = core.get_node(list[li])
          local oldNodeName = node.name
          local oldParam2 = node.param2
          -- I'll set a timeout and restore starting from the outside
          local time = (radius*radius - (ti*ti + tj*tj)) / radius + time_offset
          --local time = 5
          -- in the old nodes
          if node.name ~= 'air' then
            core.set_node(list[li], {name='air'})
            core.after(time, function()
              core.set_node(list[li], {name=oldNodeName, param2 = oldParam2})
            end)
          end
        end
      end

    end
  end

  for i = 1, radius*2 do
    for j = 1, radius*2 do
      local x = i + pos.x - radius
      local z = j + pos.z - radius
      local baseY = pos.y

      local ti = i - radius
      local tj = j - radius
      if (ti*ti + tj*tj < radius * radius) then

        local list = {
          { x = x, y = baseY - 4, z = z },
          { x = x, y = baseY - 5, z = z },
          { x = x, y = baseY - 6, z = z },
          { x = x, y = baseY - 7, z = z },
          { x = x, y = baseY - 8, z = z },
          { x = x, y = baseY - 9, z = z },
        }

        for li = 1, #list do
          local node = core.get_node(list[li])
          local oldNodeName = node.name
          -- I'll set a timeout and restore starting from the outside
          local time = (radius*radius - (ti*ti + tj*tj)) / radius + time_offset
          --local time = 5
          -- in the old nodes
          core.set_node(list[li], {name='air'})
          core.after(time, function()
            core.set_node(list[li], {name=oldNodeName})
          end)
        end
      end

    end
  end
end

local function lichen(params)
  local pos = params.pos or {x = 0, y = 0, z = 0}

  local node = core.get_node(pos)
  local y = pos.y
  while node.name == 'air' or core.get_item_group(node.name, 'replaced_by_lichen') > 0 do
    y = y - 1
    node = core.get_node({x = pos.x, y = y, z = pos.z})
  end
  -- lichen only grows on rocks
  if core.get_item_group(node.name, 'cracky') > 0 then
    local new_pos = {x = pos.x, y = y + 1, z = pos.z}
    core.set_node(new_pos, {name='mg_mapgen:deadly_lichen'})
    minetest.get_node_timer(new_pos):start(math.random(5, 10))
  end
end

local function obstruction(params)
  local radius = params.radius or 2
  local pos = params.pos or {x = 0, y = 0, z = 0}

  for i = 1, radius*2 do
    for j = 1, radius*2 do
      local x = i + pos.x - radius
      local z = j + pos.z - radius
      local baseY = pos.y

      local ti = i - radius
      local tj = j - radius
      if (ti*ti + tj*tj < radius * radius) then

        local list = {
          { x = x, y = baseY + 3, z = z },
          { x = x, y = baseY + 2, z = z },
          { x = x, y = baseY + 1, z = z },
          { x = x, y = baseY + 0, z = z },
          { x = x, y = baseY - 1, z = z },
          { x = x, y = baseY - 2, z = z },
          { x = x, y = baseY - 3, z = z },
          { x = x, y = baseY - 4, z = z },
        }

        for li = 1, #list do
          local node = core.get_node(list[li])
          local oldNodeName = node.name
          -- should use an lbm / abm instead like fire
          if(oldNodeName == 'air' or core.get_item_group(oldNodeName, 'replaced_by_lichen') > 0) then
            core.set_node(list[li], {name=crystal})
          end
        end
      end
    end
  end
end

local SMOKE_GRENADE_TIME = 30

local function poison_explode(pos)
  local duration_multiplier = 1
  -- it gets multiplied with the default duration

  local hiss = minetest.sound_play("grenades_hiss", {
    pos = pos,
    gain = 1.0,
    loop = true,
    max_hear_distance = 32,
  })
  local stop = false

  local function damage_fn()
    local radius = 6
    for _, v in pairs(minetest.get_objects_inside_radius(pos, radius)) do
      if v:is_player() and v:get_hp() > 0 and v:get_properties().pointable then
        local hp = v:get_hp()
        if hp > 0 then
          v:set_hp(hp - 1, {_mcl_reason = {type = "poison"}})
        end
      end
      if not v:is_player() and v:get_hp() > 0 then
        local mob = v:get_luaentity()
        print('poison mob ' .. (mob.hp or -1))
        if (mob.hp or -1) > 0 then
          mobkit.make_sound(mob,'hurt')
          mobkit.hurt(mob, 1)
          mobkit.hq_runfrom_pos(mob, 10, pos)
        end
      end
    end

    if not stop then
      minetest.after(1, damage_fn)
    end
  end
  damage_fn()

  minetest.after(SMOKE_GRENADE_TIME * duration_multiplier, function()
    minetest.sound_stop(hiss)
    stop = true
  end)

  local particletexture = "toxicgas.png"

  for _ = 0, 5, 1 do
    minetest.add_particlespawner({
      amount = 40,
      time = (SMOKE_GRENADE_TIME * duration_multiplier) + 1,
      minpos = vector.subtract(pos, 2),
      maxpos = vector.add(pos, 2),
      minvel = {x = 0, y = 2, z = 0},
      maxvel = {x = 0, y = 3, z = 0},
      minacc = {x = 1, y = 0.2, z = 1},
      maxacc = {x = 1, y = 0.2, z = 1},
      minexptime = 1,
      maxexptime = 1,
      minsize = 125,
      maxsize = 140,
      collisiondetection = false,
      collision_removal = false,
      vertical = false,
      texture = particletexture,
    })
  end
end

local passableArcCount = mg_arch.passableArcCount
local tt = mg_arch.tileType
local startY = 0

local function teleport(obj)
  -- get the level the player is on
  local pos = obj:get_pos()
  local depth = math.floor((pos.y - startY - 10) / (-11) + 1)

  if depth < 1 then
    return
  end

  local pmap = mg_arch.dungeon.pmaps[depth]
  local height = -11 * (depth - 1) + startY + 6
  -- get the dungeon from the pmap array
  -- get y pos floor

  local x, y, loc
  repeat
    loc = mg_arch.randomMatchingLocation(pmap, tt.FLOOR, tt.NOTHING, -1)
    x = loc.x
    y = loc.y
  until passableArcCount(pmap, loc.x, loc.y) <= 1 -- not in a hallway

  obj:set_pos({x = x, y = height, z = y})
end


-- The worst
local mod_path = minetest.get_modpath("mg_effects")
local df = dofile(mod_path.."/spawn_df.lua")

mg_effects = {}
mg_effects.shattering = shattering
mg_effects.descent = descent
mg_effects.fireball = fireball
mg_effects.lichen = lichen
mg_effects.obstruction = obstruction
mg_effects.poison_explode = poison_explode
mg_effects.teleport = teleport
mg_effects.net = df.net
mg_effects.flood = df.flood

dofile(mod_path.."/cobwebs.lua")
dofile(mod_path.."/suffocation.lua")

