minetest.register_entity("mg_mobs:squid",{
  physical = true,
  stepheight = 0.1,				--EVIL!
  collide_with_objects = true,
  collisionbox = {-0.2, 0.1, -0.2, 0.2, 0.5, 0.2},
  visual = "mesh",
  mesh = "mobs_mc_squid.b3d",
  textures = {"mobs_mc_squid.png"},
  visual_size = {x = 1.5, y = 1.5},
  static_save = true,
  makes_footstep_sound = false,
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.98,					-- portion of hitbox submerged
  max_speed = 1,
  jump_height = 1.26,
  view_range = 24,
  --	lung_capacity = 0, 		-- seconds
  max_hp = 18,
  regen = 5,
  defense = 27,
  accuracy = 100,
  timeout=600,
  attack={range=0.2,damage_groups={fleshy=3, fleshy_max=7, clump=2}},
  sounds = {
    warn = 'mobs_mc_squid_flop',
    hurt = 'mobs_mc_squid_hurt',
  },
  animation = {
    def={range={x=1,y=60},speed=40,loop=true},
    fast={range={x=1,y=60},speed=80,loop=true},
    back={range={x=60,y=1},speed=-15,loop=false},
  },

  abilities = { },
  behaviors = {
    restricted_to_liquid = 1,
    immune_to_water = 1,
    submerges = 1,
    flits = 1,
    never_sleeps = 1
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch= mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:squid", "Squid", 1);

minetest.register_entity("mg_mobs:bog_monster",{
  physical = true,
  stepheight = 0.1,				--EVIL!
  collide_with_objects = true,
  collisionbox = {-0.4, 0.0, -0.4, 0.4, 0.9, 0.4},
  visual = "mesh",
  mesh = "mobs_mc_squid.b3d",
  textures = {"mobs_mc_glow_squid.png"},
  visual_size = {x = 1.5, y = 1.5},
  static_save = true,
  makes_footstep_sound = false,
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.98,					-- portion of hitbox submerged
  max_speed = 1,
  jump_height = 1.26,
  view_range = 24,
  --	lung_capacity = 0, 		-- seconds
  max_hp = 55,
  regen = 3,
  defense = 60,
  accuracy = 5000,
  attack={range=0.2,damage_groups={fleshy=3, fleshy_max=4}},
  sounds = {
    -- attack='sharkattack',
  },
  animation = {
    def={range={x=1,y=60},speed=40,loop=true},
    fast={range={x=1,y=60},speed=80,loop=true},
    back={range={x=60,y=1},speed=-15,loop=false},
  },

  bolts = { },
  behaviors = {
    restricted_to_liquid = 1,
    submerges = 1,
    flits = 1,
    flees_near_death = 1
  },
  abilities = {
    seizes = 1
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch= mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:bog_monster", "Bog Monster", 1);
