minetest.register_entity("mg_mobs:wraith",{
  -- common props
  physical = true,
  stepheight = 0.1,				--EVIL!
  collide_with_objects = true,
  collisionbox = {-0.3, -0.01, -0.3, 0.3, 1.98, 0.3},
  visual = "mesh",
  mesh = "mobs_mc_stray.b3d",
  textures = { "mobs_mc_stray.png^mobs_mc_stray_overlay.png" },
  visual_size = {x = 3, y = 3},
  static_save = true,
  makes_footstep_sound = true,
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.75,					-- portion of hitbox submerged
  max_speed = 10,
  jump_height = 1.26,
  view_range = 24,
  lung_capacity = 10, 		-- seconds
  max_hp = 50,
  regen=5,
  defense = 60,
  accuracy = 120,
  attack={
    range=1,
    damage_groups={
      fleshy=6,
      fleshy_max=13,
      clump=2
    }
  },
  sounds = {
    attack='mob_mc_skeleton_random',
    warn='mob_mc_skeleton_random',
    hurt = 'mobs_mc_skeleton_hurt',
    death='mob_mc_skeleton_death',
  },
  animation = {
    run={range={x=40,y=60},speed=30,loop=true},
    walk={range={x=40,y=60},speed=15,loop=true},
    stand={range={x=0,y=40},speed=40,loop=true},
    death={range={x=160,y=170},speed=15,loop=false},
  },

  bolts = {},
  behaviors = {
    flees_near_death = 1
  },
  abilities = {
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch = mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:wraith", "Wraith", 1);
