
local on_hit_remove = function(self, hit_type)

  minetest.sound_play(
  bows.registered_arrows[self.name].on_hit_sound, {
    pos = self.object:get_pos(),
    gain = 1.0,
    max_hear_distance = 12
  }, true)

  -- chance of dropping arrow
  local chance = minetest.registered_items[self.name].drop_chance or 50
  local pos = self.object:get_pos()

  local drop_result = math.random(0, 100) < chance

  -- always drop if hit a node
  -- chance to drop if hit an entity
  if pos and (hit_type == "node" or (hit_type == "object" and drop_result)) then
    pos.y = pos.y + 0.5
    minetest.add_item(pos, self.name)
  end

  self.object:remove()

  return self
end


local on_hit_object = function(self, target, user, lastpos)
  target:punch(user, 0.1, {
    full_punch_interval = 0.1,
    damage_groups = {fleshy = self.dmg, fleshy_max = self.dmg_max},
  }, nil)

  if bows.registered_arrows[self.name].on_hit_object then
    print('callbacl for on hit object')

    bows.registered_arrows[self.name].on_hit_object(
    self, target, 1, user, lastpos)
  end

  on_hit_remove(self, "object")

  return self
end


minetest.register_entity("bows:arrow",{

  initial_properties = {
    hp_max = 10,
    visual = "wielditem",
    visual_size = {x = .20, y = .20},
    collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},
    physical = false,
    textures = {"air"}
  },

  _is_arrow = true,
  timer = 10,

  on_activate = function(self, _staticdata)

    if not self then
      self.object:remove()
      return
    end

    if bows.tmp and bows.tmp.arrow ~= nil then

      self.arrow = bows.tmp.arrow
      self.user = bows.tmp.user
      self.name = bows.tmp.name
      self.dmg = bows.registered_arrows[self.name].damage
      self.dmg_max = bows.registered_arrows[self.name].damage_max or self.dmg

      bows.tmp = nil

      self.object:set_properties({textures = {self.arrow}})
    else
      -- I think this would be called if the game was
      -- restarted while an arrow was in the middle of the air
      self.object:remove()
    end
  end,

  mass = 1.0,  -- kg
  drag_coefficient = 1,  -- kg/m

  calculate_drag_acceleration = function(self, velocity)
    local speed = vector.length(velocity)
    if speed < 0.001 then
      return {x=0, y=0, z=0}
    end
    local drag_magnitude = -self.drag_coefficient * speed * speed / self.mass
    return vector.divide(velocity, speed * drag_magnitude)
  end,

  on_step = function(self, dtime)
    self.timer = self.timer - dtime
    if self.timer < 0 then
      self.object:remove()
      return
    end

    local pos = self.object:get_pos()
    local velocity = self.object:get_velocity()
    local drag_acc = self:calculate_drag_acceleration(velocity)
    local total_acc = vector.add(drag_acc, {x=0, y=-9.81, z=0})
    local new_velocity = vector.add(
        velocity,
        vector.multiply(total_acc, dtime)
    )

    self.object:set_acceleration(total_acc)
    self.object:set_velocity(new_velocity)

    self.oldpos = self.oldpos or pos
    local cast = minetest.raycast(self.oldpos, pos, true, true)
    local thing = cast:next()
    local ok = true

    -- loop through things
    while thing do

      -- ignore the object that is the arrow
      if thing.type == "object" and thing.ref ~= self.object then

        -- add entity name to thing table (if not player)
        if not thing.ref:is_player() then
          thing.name = thing.ref:get_luaentity() and thing.ref:get_luaentity().name
        end

        -- check if dropped item or yourself
        if thing.name == "__builtin:item"
          or (not thing.name
          and thing.ref:get_player_name() == self.user:get_player_name()) then
          ok = false
        end

        -- can we hit entity ?
        if ok then
          on_hit_object(self, thing.ref, self.user, {x = pos.x, y = pos.y, z = pos.z})
          return self
        end

        -- are we inside a node ?
      elseif thing.type == "node" then

        self.node = minetest.get_node(pos)

        local def = minetest.registered_nodes[self.node.name]

        if def and def.walkable then

          --print("-- hit node", self.node.name)

          if bows.registered_arrows[self.name].on_hit_node then

            bows.registered_arrows[self.name].on_hit_node(
            self, pos, self.user, self.oldpos)
          end

          on_hit_remove(self, "node")

          return self
        end
      end

      thing = cast:next()
    end

    self.oldpos = pos
  end
})
