minetest.register_entity("mg_mobs:pink_jelly",{
  physical = true,
  stepheight = 0.1,				--EVIL!
  collide_with_objects = true,
  collisionbox = {-0.49, -0.01, -0.49, 0.49, 1.00, 0.49},
  visual_size = {x=6.25, y=6.25},
  visual = "mesh",
  mesh = "mobs_mc_slime.b3d",
  textures = {"pink.png"},
  static_save = true,
  makes_footstep_sound = true,
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.9,
  max_speed = 5,
  jump_height = 1.26,
  view_range = 24,
  lung_capacity = 10,			-- seconds
  max_hp = 50,
  regen = 0, -- no regen
  defense = 0,
  accuracy = 85,
  attack={range=0.5,damage_groups={fleshy=1, fleshy_max=3}},
  sounds = {
    jump = "green_slime_jump",
    death = "green_slime_death",
    hurt = "green_slime_damage",
    attack = "green_slime_attack",
  },
  animation = {
    jump={range={x=1,y=20},speed=17, loop=true},
    run={range={x=1,y=20},speed=17,  loop=true},
    walk={range={x=1,y=20},speed=17, loop=true},
    stand={range={x=1,y=20},speed=17,loop=true},
  },

  bolts = { },
  behaviors = {
    never_sleeps = 1
  },
  abilities = {
    clone_self_on_defend = 1
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch= mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:pink_jelly", "Pink Jelly", 1);

minetest.register_entity("mg_mobs:acid_mound",{
  physical = true,
  stepheight = 0.1,				--EVIL!
  collide_with_objects = true,
  collisionbox = {-0.49, -0.01, -0.49, 0.49, 1.00, 0.49},
  visual_size = {x=4.25, y=4.25},
  visual = "mesh",
  mesh = "mobs_mc_slime.b3d",
  textures = {"mobs_mc_slime.png"},
  static_save = true,
  makes_footstep_sound = true,
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.9,
  max_speed = 5,
  jump_height = 1.26,
  view_range = 24,
  lung_capacity = 10,			-- seconds
  max_hp = 15,
  regen = 5,
  defense = 10,
  accuracy = 70,
  attack={range=1,damage_groups={fleshy=1, fleshy_max=3}},
  sounds = {
    jump = "green_slime_jump",
    death = "green_slime_death",
    hurt = "green_slime_damage",
    attack = "green_slime_attack",
  },
  animation = {
    jump={range={x=1,y=20},speed=17, loop=true},
    run={range={x=1,y=20},speed=17,  loop=true},
    walk={range={x=1,y=20},speed=17, loop=true},
    stand={range={x=1,y=20},speed=17,loop=true},
  },

  bolts = { },
  behaviors = {
    defend_degrade_weapon = 1
  },
  abilities = {
    hit_degrade_armor = 1
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch= mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:acid_mound", "Acid Mound", 1);

minetest.register_entity("mg_mobs:acidic_jelly",{
  physical = true,
  stepheight = 0.1,				--EVIL!
  collide_with_objects = true,
  collisionbox = {-0.49, -0.01, -0.49, 0.49, 1.00, 0.49},
  visual_size = {x=6.25, y=6.25},
  visual = "mesh",
  mesh = "mobs_mc_slime.b3d",
  textures = {"mobs_mc_slime.png"},
  static_save = true,
  makes_footstep_sound = true,
  on_step = mobkit.stepfunc,	-- required
  on_activate = mobkit.actfunc,		-- required
  get_staticdata = mobkit.statfunc,
  -- api props
  springiness=0,
  buoyancy = 0.9,
  max_speed = 5,
  jump_height = 1.26,
  view_range = 24,
  lung_capacity = 10,			-- seconds
  max_hp = 60,
  regen = 0, -- no regen
  defense = 0,
  accuracy = 115,
  attack={range=0.5,damage_groups={fleshy=1, fleshy_max=3}},
  sounds = {
    jump = "green_slime_jump",
    death = "green_slime_death",
    hurt = "green_slime_damage",
    attack = "green_slime_attack",
  },
  animation = {
    jump={range={x=1,y=20},speed=17, loop=true},
    run={range={x=1,y=20},speed=17,  loop=true},
    walk={range={x=1,y=20},speed=17, loop=true},
    stand={range={x=1,y=20},speed=17,loop=true},
  },

  bolts = { },

  behaviors = {
    never_sleeps = 1,
    defend_degrade_weapon = 1
  },
  abilities = {
    hit_degrade_armor = 1,
    clone_self_on_defend = 1
  },

  brainfunc = mg_mobs.mg_brain,
  on_punch= mg_mobs.handle_on_punch,
})

mg_mobs.register_egg("mg_mobs:acidic_jelly", "Acidic Jelly", 1);
