local abr = minetest.get_mapgen_setting('active_block_range')

local mod_path = minetest.get_modpath("mg_mobs")
local spawn = dofile(mod_path.."/spawn.lua")
local bolts = dofile(mod_path.."/ai_bolts.lua")

local pi = math.pi
local random=math.random

local function clamp(x, low, high)
  return math.min(high, math.max(x, low))
end

local function rand_percent(percent)
  return math.random(0,99) < clamp(percent, 0, 100)
end

local function get_yaw_to_pos(self,tpos)
	if not self then return 0 end
	local pos = mobkit.get_stand_pos(self)
	local tyaw = minetest.dir_to_yaw(vector.direction(pos, tpos))
    return tyaw
end

local function is_fly_node(node)
  if not node then
    return false
  end
  if node.name == 'air' then
    return true
  end
  if node.walkable == false then
    return true
  end
  return false
end

local function is_in_air(target)
	if not target then return false end
	local nodepos = mobkit.get_stand_pos(target)
	local node1 = mobkit.nodeatpos(nodepos)
	nodepos.y=nodepos.y+1
	local node2 = mobkit.nodeatpos(nodepos)
	nodepos.y=nodepos.y-2
	local node3 = mobkit.nodeatpos(nodepos)
	if node1 and node2 and node3 and node1.drawtype=='liquid' and (node2.drawtype=='liquid' or node3.drawtype=='liquid') then
		return true
	end
end

local function fly_radar_dumb(pos,yaw,range,reverse,shallow)
	range = range or 4
	local function okpos(p)
		local node = mobkit.nodeatpos(p)
		if node then
			if is_fly_node(node) then
				if shallow then
					return true
				end
				local nodeu = mobkit.nodeatpos(mobkit.pos_shift(p,{y=1}))
				local noded = mobkit.nodeatpos(mobkit.pos_shift(p,{y=-1}))
				if is_fly_node(nodeu) or is_fly_node(noded) then
						return true
				else
					return false
				end
			else
				local h = mobkit.get_terrain_height(p)
				if h then
					local node2 = mobkit.nodeatpos({x=p.x,y=h+1.99,z=p.z})
					if is_fly_node(node2) then return true, h end
				else
					return false
				end
			end
		else
			return false
		end
	end
	local fpos = mobkit.pos_translate2d(pos,yaw,range)
	local ok,h = okpos(fpos)
	if not ok then
		local ffrom, fto, fstep
		if reverse then
			ffrom, fto, fstep = 3,1,-1
		else
			ffrom, fto, fstep = 1,3,1
		end
		for i=ffrom, fto, fstep  do
			local ok,h = okpos(mobkit.pos_translate2d(pos,yaw+i,range))
			if ok then return yaw+i,h end
			ok,h = okpos(mobkit.pos_translate2d(pos,yaw-i,range))
			if ok then return yaw-i,h end
		end
		return yaw+pi,h
	else
		return yaw, h
	end
end

local function can_punch(mob_pos, target_pos, target)
  -- only nodes - no object or liques
  local cast = core.raycast(mob_pos, target_pos, true, false)
  local thing = cast:next()
  while thing do
    if thing.type == "node" then
      local node = core.get_node(thing.intersection_point)
      local def = minetest.registered_nodes[node.name]
      -- A walkable node is a solid node
      if def and def.walkable then
        return false
      end
    end
    if thing.type == "object" and thing.ref == target then
      return true
    end
    thing = cast:next()
  end
  return false
end

function mg_mobs.hq_fly_attack(self,tgtobj,prty,speed)
	local anim = "fly"
	local selfbox = self.object:get_properties().collisionbox
	local tgtbox = tgtobj:get_properties().collisionbox
	if not speed then speed = 1 end
	local init = true

  local timer = 0

	local func = function(self)
    timer = timer + self.dtime

		if init then
			mobkit.animate(self,anim)
			init = false
		end

    if not mobkit.is_alive(self) or not mobkit.is_alive(tgtobj) or
      tgtobj:get_attach() ~= nil then
        return true
    end
    local pos = self.object:get_pos()
    local endpos = tgtobj:get_pos()


    local dist = vector.distance(pos,endpos)
    local stealth_range = mg_stealth.get_stealth(tgtobj)

    -- need to have an attack speed here...
    -- TODO move logic together
    if timer > 1 then
      timer = 0
      -- 3 percent chance for the monster to loose the player
      if dist >= stealth_range * 2 and rand_percent(3) then
        return true
      end
      if dist > stealth_range * 3 then
        return true
      end

      local did_shoot = false
      if self.bolts and #self.bolts > 0 then
        -- TODO - if cast spells slowly, then only cast every other turn
        -- instead of every turn as it is now
        did_shoot = bolts.shoot_bolts(self)
        if did_shoot then
          mobkit.make_sound(self,'warn')
        end
      end
      -- if monster didn't shoot and they can summon, let them try that now
      if self.abilities and self.abilities.cast_summon and not did_shoot then
        spawn.summon_horde(self)
      end

    end


    local self_middle_y = (selfbox[5] - selfbox[2])/2
    local tgt_middle_y = (tgtbox[5] - tgtbox[2])/2

    local yaw = get_yaw_to_pos(self,endpos)

    -- This if statement makes no sense
    -- really should be if collision boxes are close enough
    -- right now this gets messed up if collision box of mob is too big
    if dist > self.attack.range then
      -- they bounce up and down - should have a middle ground
      -- that sets to 0
      -- flying ai mobs should have some sort of floating mechanics for the ground
      -- like they float 2 blocks or 1.5 blocks off ground intead of
      -- just going up and up - but I want to look into other mob libraries
      -- before making too many modifications to this
      if endpos.y + tgt_middle_y > pos.y + self_middle_y then
        local vel = vector.add(self.object:get_velocity(),{x=0,y=0.25,z=0})
        self.object:set_velocity(vel)
      end
      if endpos.y + tgt_middle_y < pos.y + self_middle_y then
        local vel = vector.add(self.object:get_velocity(),{x=0,y=-0.25,z=0})
        self.object:set_velocity(vel)
      end
      mobkit.hq_aqua_turn(self,prty+5,yaw,speed)
    else
      local current_yaw = self.object:get_yaw()
      local attack_pos = mobkit.pos_translate2d(pos, current_yaw, self.attack.range)

      if mobkit.is_alive(tgtobj) and
        self.punch_timer > self.max_speed / 10 and
        can_punch(pos, attack_pos, tgtobj)
      then
        tgtobj:punch(self.object,1,self.attack)
        self.punch_timer = 0
        local dir = minetest.yaw_to_dir(current_yaw)
        local vy = self.object:get_velocity().y
        self.object:set_velocity({x=dir.x*-3,y=vy + 0.5,z=dir.z*-3})
        -- play attack sound if defined
        mobkit.make_sound(self,'attack')
      end
    end
	end
	mobkit.queue_high(self,func,prty)
end

function mg_mobs.hq_fly_roam(self,prty,speed,anim)
	if not anim then anim = "def" end
	local tyaw = 0
	local init = true
	local prvscanpos = {x=0,y=0,z=0}
	local center = self.object:get_pos()
	local func = function(self)
		if init then
			mobkit.animate(self,anim)
			init = false
		end
		if mobkit.timer(self,1) and self.isonground then
			return true
		end
		local pos = mobkit.get_stand_pos(self)
		local yaw = self.object:get_yaw()
		local scanpos = mobkit.get_node_pos(mobkit.pos_translate2d(pos,yaw,speed))
		if not vector.equals(prvscanpos,scanpos) then
			prvscanpos=scanpos
			local nyaw,height = fly_radar_dumb(pos,yaw,speed,false,true)
			if height and height > pos.y then
				local vel = self.object:get_velocity()
				vel.y = vel.y+1
				self.object:set_velocity(vel)
			end
			if yaw ~= nyaw then
				tyaw=nyaw
				mobkit.hq_aqua_turn(self,prty + 1,tyaw,speed)
				return true
			end
		end
		if mobkit.timer(self,1) then
			if vector.distance(pos,center) > abr*16*0.5 then
				tyaw = minetest.dir_to_yaw(vector.direction(
					pos,{x=center.x+random()*10-5,y=center.y,
					z=center.z+random()*10-5}))
			else
				if random(10)>=9 then tyaw=tyaw+random()*pi - pi*0.5 end
			end
		end

		mobkit.turn2yaw(self,tyaw,3)
		mobkit.go_forward_horizontal(self,speed)
	end
	mobkit.queue_high(self,func,prty)
end

function mg_mobs.fly_physics (self)
  local vel=self.object:get_velocity()
  local vnew = vector.new(vel)

  if self.isonground and not self.isinliquid then
    vnew = {x= vel.x> 0.2 and vel.x*mobkit.friction or 0,
    y=vel.y,
    z=vel.z > 0.2 and vel.z*mobkit.friction or 0}
  end

	local spos = mobkit.get_stand_pos(self)
	spos.y = spos.y+0.01
	local surfnode = mobkit.nodeatpos(spos)

  self.object:set_velocity(vnew)
  if self.hp <= 0 then
		mobkit.set_acceleration(self.object, {x=0,y=mobkit.gravity,z=0})
  elseif surfnode and surfnode.name == "mg_mapgen:cobweb" then
		mobkit.set_acceleration(self.object,
			{x=-vel.x*self.net_drag, y=-vel.y*self.net_drag, z=-vel.z*self.net_drag})
  else
		mobkit.set_acceleration(self.object, {x=0,y=0,z=0})
  end
end
