local abr = minetest.get_mapgen_setting('active_block_range')

local pi = math.pi
local random=math.random

function mg_mobs.get_yaw_to_pos(self,tpos)
	if not self then return 0 end
	local pos = mobkit.get_stand_pos(self)
	local tyaw = minetest.dir_to_yaw(vector.direction(pos, tpos))
    return tyaw
end

function mg_mobs.aqua_radar_dumb(pos,yaw,range,reverse,shallow)
	range = range or 4
	local function okpos(p)
		local node = mobkit.nodeatpos(p)
		if node then
			if node.drawtype == 'liquid' then
				if shallow then
					return true
				end
				local nodeu = mobkit.nodeatpos(mobkit.pos_shift(p,{y=1}))
				local noded = mobkit.nodeatpos(mobkit.pos_shift(p,{y=-1}))
				if ((nodeu and nodeu.drawtype == 'liquid') or (noded and
					noded.drawtype == 'liquid')) then
						return true
				else
					return false
				end
			else
				local h = mobkit.get_terrain_height(p)
				if h then
					local node2 = mobkit.nodeatpos({x=p.x,y=h+1.99,z=p.z})
					if node2 and node2.drawtype == 'liquid' then return true, h end
				else
					return false
				end
			end
		else
			return false
		end
	end
	local fpos = mobkit.pos_translate2d(pos,yaw,range)
	local ok,h = okpos(fpos)
	if not ok then
		local ffrom, fto, fstep
		if reverse then
			ffrom, fto, fstep = 3,1,-1
		else
			ffrom, fto, fstep = 1,3,1
		end
		for i=ffrom, fto, fstep  do
			local ok,h = okpos(mobkit.pos_translate2d(pos,yaw+i,range))
			if ok then return yaw+i,h end
			ok,h = okpos(mobkit.pos_translate2d(pos,yaw-i,range))
			if ok then return yaw-i,h end
		end
		return yaw+pi,h
	else 
		return yaw, h
	end
end

function mg_mobs.hq_water_attack(self,tgtobj,prty,speed,shallow)
	local selfbox = self.object:get_properties().collisionbox
	local tgtbox = tgtobj:get_properties().collisionbox
	if not speed then speed = 1 end
	local func = function(self)
    if not mobkit.is_alive(self) or not mobkit.is_alive(tgtobj) or 
      tgtobj:get_attach() ~= nil then
        return true
    end
    local pos = self.object:get_pos()
    local endpos = tgtobj:get_pos()
    if not shallow then
      if not mobkit.is_in_deep(tgtobj) and vector.distance (pos,endpos) > 2 then 
        return true
      end
    else
      if not mobkit.is_in_water(tgtobj) and vector.distance (pos,endpos) > 2 then
        return true
      end
    end
    local yaw = mg_mobs.get_yaw_to_pos(self,endpos)

    if vector.distance(pos,endpos) > tgtbox[5] then
      if endpos.y > pos.y+selfbox[5] then
        local vel = vector.add(self.object:get_velocity(),{x=0,y=0.5,z=0})
        self.object:set_velocity(vel)
      end
      if endpos.y < pos.y-selfbox[5]  then
        local vel = vector.add(self.object:get_velocity(),{x=0,y=-0.5,z=0})
        self.object:set_velocity(vel)
      end
      mobkit.hq_aqua_turn(self,prty+5,yaw,speed)
    else
      -- TODO make sure water mobs can only hurt if they are facing the player
      -- EI - they are biting them!
      if mobkit.is_alive(tgtobj) then
        tgtobj:punch(self.object,1,self.attack)
        return true
      else
        return true
      end
    end
	end
	mobkit.queue_high(self,func,prty)
end

function mg_mobs.hq_aqua_roam(self,prty,speed,anim)
	if not anim then anim = "def" end
	local tyaw = 0
	local init = true
	local prvscanpos = {x=0,y=0,z=0}
	local center = self.object:get_pos()
	local func = function(self)
		if init then
			mobkit.animate(self,anim)
			init = false
		end
		if mobkit.timer(self,1) and self.isonground then
			return true
		end
		local pos = mobkit.get_stand_pos(self)
		local yaw = self.object:get_yaw()
		local scanpos = mobkit.get_node_pos(mobkit.pos_translate2d(pos,yaw,speed))
		if not vector.equals(prvscanpos,scanpos) then
			prvscanpos=scanpos
			local nyaw,height = mg_mobs.aqua_radar_dumb(pos,yaw,speed,false,true)
			if height and height > pos.y then
				local vel = self.object:get_velocity()
				vel.y = vel.y+1
				self.object:set_velocity(vel)
			end	
			if yaw ~= nyaw then
				tyaw=nyaw
				mobkit.hq_aqua_turn(self,prty + 1,tyaw,speed)
				return true
			end
		end
		if mobkit.timer(self,1) then
			if vector.distance(pos,center) > abr*16*0.5 then
				tyaw = minetest.dir_to_yaw(vector.direction(
					pos,{x=center.x+random()*10-5,y=center.y,
					z=center.z+random()*10-5}))
			else
				if random(10)>=9 then tyaw=tyaw+random()*pi - pi*0.5 end
			end
		end
		
		mobkit.turn2yaw(self,tyaw,3)
		mobkit.go_forward_horizontal(self,speed)
	end
	mobkit.queue_high(self,func,prty)
end
