local seed
seed = os.time()
seed = 1749816903 
math.randomseed(seed)
print('seed: ' .. seed)

json = require './mg_arch/json'
require './mg_arch/globals'
require './mg_arch/grid'
require './mg_arch/dijkstra'
require './mg_arch/arch'
require './mg_arch/fov'
require './mg_arch/items'
require './mg_arch/monsters'

require './mg_dungeon_registration/items'

local worldData = mg_arch.generateWorldData()
local levels = mg_arch.makeLevels()
local tf = mg_arch.terrainFlags

for k=3, 4 do
  math.randomseed(seed - 1 + k)
  local pmap = mg_arch.digDungeon(k, levels)

  local levelItems = mg_arch.populateItems(pmap, worldData, k, levels[k].upStair.x, levels[k].upStair.y)
  levels[k].items = levelItems


  local xLoc = levels[k].upStair.x
  local yLoc = levels[k].upStair.y
  mg_arch.mark_upstairs_fov(pmap, xLoc, yLoc)
  local monsters = mg_arch.monsters.populateMonsters(k, pmap)

  mg_arch.printPmap(pmap, false, levelItems, monsters)
end



