mg_arch.monsters = {}

local DROWS = mg_arch.DROWS
local DCOLS = mg_arch.DCOLS
local AMULET_LEVEL = mg_arch.AMULET_LEVEL
local rand_percent = mg_arch.rand_percent
local rand_range = mg_arch.rand_range
local passableArcCount = mg_arch.passableArcCount

local min = mg_arch.min
local max = mg_arch.max
local tt = mg_arch.tileType
local coordinatesAreInMap = mg_arch.coordinatesAreInMap
local cellHasTerrainType = mg_arch.cellHasTerrainType
local hasAllFlags = mg_arch.hasAllFlags
local hasAnyFlags = mg_arch.hasAnyFlags

local function mkMonster(i, name, hp, def, acc, damage, reg, move, attack)
  return {
    i = i,
    n = name,
    name = name,
    hp = hp,
    defense = def,
    accuracy = acc,
    damage = damage,
    regenerationSpeed = reg,
    movementSpeed = move,
    attackSpeed = attack
  }
end

-- For now I have hp, damage, accuracy, defense, damage frequency on the mob registration
local MK = {
  RAT             = mkMonster( 1, 'rat'),
  KOBOLD          = mkMonster( 2, 'chicken'),
  JACKEL          = mkMonster( 3, 'wolf'),
  EEL             = mkMonster( 4, 'squid'),
  MONKEY          = mkMonster( 5, 'monkey'),
  BLOAT           = {i = 6, n ='bloat'},
  PIT_BLOAT       = {i = 7, n ='pit_bloat'},
  GOBLIN          = {i = 8, n ='goblin'},
  GOBLIN_CONJURER = {i = 9, n ='goblin_conjurer'},
  GOBLIN_MYSTIC   = {i = 10, n='goblin_mystic'},
  --GOBLIN_TOTEM    = {i = 11, n='goblin_totem'},
  PINK_JELLY      = {i = 12, n='pink_jelly'},
  TOAD            = {i = 13, n='toad'},
  VAMPIRE_BAT     = {i = 14, n='vampire_bat'},
  --ARROW_TURRET    = {i = 15, n='arrow_turret'},
  ACID_MOUND      = {i = 16, n='acid_mound'},
  CENTIPEDE       = {i = 17, n='centipede'},
  OGRE            = {i = 18, n='ogre'},
  BOG_MONSTER     = {i = 19, n='bog_monster'},
  --ORGE_TOTEM      = {i = 20, n='ogre_totem'},
  SPIDER          = {i = 21, n='spider'},
  --SPARK_TURRET    = {i = 22, n='spark_turret'},
  WISP            = {i = 23, n='wisp'},
  WRAITH          = {i = 24, n='wraith'},
  --ZOMBIE          = {i = 25, n='zombie'},
  --TROLL           = {i = 26, n='troll'},
  --OGRE_SHAMAN     = {i = 27, n='orge_shaman'},
  --NAGA            = {i = 28, n='naga'},
  --SALAMANDER      = {i = 29, n='salamander'},
  --EXPLOSIVE_BLOAT = {i = 30, n='explosive_bloat'},
  DAR_BLADEMASTER = {i = 31, n='dar_blademaster'},
  --DAR_PRIESTESS   = {i = 32, n='dar_priestess'},
  --DAR_BATTLEMAGE  = {i = 33, n='dar_battlemage'},
  ACIDIC_JELLY    = {i = 34, n='acidic_jelly'},
  PILLAGER = {i = 35, n='pillager'},
  SPECTRAL_BLADE = {i = 36, n='spectral_blade'},
}


local function mkMember (name, count)
  return {name=name, count=count}
end
local function mkHordeCat (leader, members, minL, maxL, freq, spawnsIn, machine, flags)
  return {
    leader = leader,
    members = members,
    minLevel = minL,
    maxLevel = maxL,
    frequency = freq,
    spawnsIn = spawnsIn or -1,
    machine = machine or 0,
    flags = flags or {}
  }
end

-- TODO revisit on Mob revamp
-- Levels 1-10 to start
-- and basic hordes
local hordeCatalog = {
  mkHordeCat(MK.RAT.n, {}, 1, 5, 150),
  mkHordeCat(MK.KOBOLD.n, {}, 1, 6, 150),
  mkHordeCat(MK.JACKEL.n, {}, 1, 3, 100),
  mkHordeCat(MK.JACKEL.n, {mkMember(MK.JACKEL.n, {1,3,1})}, 3, 7, 50),
  mkHordeCat(MK.EEL.n, {}, 2, 17, 100, tt.DEEP_WATER),
  mkHordeCat(MK.MONKEY.n, {}, 2, 9, 50),
  mkHordeCat(MK.BLOAT.n, {}, 2, 13, 30),
  mkHordeCat(MK.PIT_BLOAT.n, {}, 2, 13, 10),
  mkHordeCat(MK.BLOAT.n, {mkMember(MK.BLOAT.n, {0,2,1})}, 14, 26, 30),
  mkHordeCat(MK.PIT_BLOAT.n, {mkMember(MK.PIT_BLOAT.n, {0,2,1})}, 14, 26, 10),
  --mkHordeCat(MK.EXPLOSIVE_BLOAT.n, {}, 10, 26, 10),
  mkHordeCat(MK.GOBLIN.n, {}, 3, 10, 100),
  mkHordeCat(MK.GOBLIN_CONJURER.n, {}, 3, 10, 60),
  mkHordeCat(MK.TOAD.n, {}, 4, 11, 100),
  mkHordeCat(MK.PINK_JELLY.n, {}, 4, 13, 100),
  --mkHordeCat(MK.GOBLIN_TOTEM.n, {mkMember(MK.GOBLIN, {2,4,1})}, 5, 13, 100),
  mkHordeCat(MK.MONKEY.n, {mkMember(MK.MONKEY.n, {2,4,1})}, 5, 13, 20),
  mkHordeCat(MK.VAMPIRE_BAT.n, {}, 6, 13, 30),
  mkHordeCat(MK.VAMPIRE_BAT.n, {mkMember(MK.VAMPIRE_BAT.n, {1,2,1})}, 6, 13, 70, -1, 0, {hordeNeverOod = 1}),
  mkHordeCat(MK.ACID_MOUND.n, {}, 6, 13, 100),
  mkHordeCat(
    MK.GOBLIN.n, {
      mkMember(MK.GOBLIN.n, {2,3,1}),
      mkMember(MK.GOBLIN_MYSTIC.n, {1,2,1}),
      mkMember(MK.JACKEL.n, {1,2,1}),
    }, 6, 12, 40),
  mkHordeCat(
    MK.GOBLIN_CONJURER.n, {
      mkMember(MK.GOBLIN_CONJURER.n, {0,1,1}),
      mkMember(MK.GOBLIN_MYSTIC.n, {1,1,1}),
    }, 7, 15, 40),
  mkHordeCat(MK.CENTIPEDE.n, {}, 7, 14, 100),
  mkHordeCat(MK.BOG_MONSTER.n, {}, 7, 14, 80, tt.DEEP_WATER, 0, {hordeNeverOod = 1}),
  mkHordeCat(MK.OGRE.n, {}, 7, 13, 100),
  mkHordeCat(MK.EEL.n, {mkMember(MK.EEL.n, {2,4,1})}, 8, 22, 77, tt.DEEP_WATER),
  mkHordeCat(MK.ACID_MOUND.n, {mkMember(MK.ACID_MOUND.n, {2,4,1})}, 9, 13, 30),
  mkHordeCat(MK.SPIDER.n, {}, 9, 16, 100),
  mkHordeCat(MK.DAR_BLADEMASTER.n, {mkMember(MK.DAR_BLADEMASTER.n, {0,1,1})}, 10, 14, 100),
  mkHordeCat(MK.WISP.n, {}, 10, 17, 100),
  mkHordeCat(MK.WRAITH.n, {}, 10, 17, 100),
  mkHordeCat(MK.ACIDIC_JELLY.n, {}, 14, 21, 100),

  mkHordeCat(MK.PILLAGER.n, {mkMember(MK.PILLAGER.n, {1,1,1})}, 14, 21, 100),


  -- Summons
  mkHordeCat(
    MK.GOBLIN_CONJURER.n,
    {mkMember(MK.SPECTRAL_BLADE.n, {3,5,1})},
    0, 0, 100, 0, 0,
    {horde_is_summoned = 1, horde_dies_on_leader_death = 1}
  ),
}

local function allocMonster()
  return {
    monsterType = nil,
    monsterId = '',
    hp = 0,
    movementSpeed = 0,
    attackSpeed = 0,
    regenerationSpeed = 0,
    defense = 0,
    accuracy = 0,
    bloodType = '',
    depth = 0,
    leaderId = ''
  }
end

local function randClumpRange(lowerBound, upperBound, clumpFactor)
    if upperBound <= lowerBound then
      return lowerBound
    end
    if clumpFactor <= 1 then
      return rand_range(lowerBound, upperBound)
    end

    local total = 0
    local numSides = (upperBound - lowerBound) / clumpFactor

    for _=1, (upperBound - lowerBound) % clumpFactor do
        total = total + rand_range(0, numSides + 1)
      end

    for _=1, clumpFactor do
      total = total + rand_range(0, numSides)
    end

    return (total + lowerBound);
end

local function uuid()
  local template ='xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'
  return string.gsub(template, '[xy]', function (c)
    local v = (c == 'x') and math.random(0, 0xf) or math.random(8, 0xb)
    return string.format('%x', v)
  end)
end

local function generateMonster (monsterType)
  local monster = allocMonster()
  monster.monsterType = monsterType
  monster.monsterId = uuid()
  return monster
end

local function testLoc (pmap, x, y, dungeonType, liquidType, terrainType)
   return (terrainType >= 0 and cellHasTerrainType(pmap, x, y, terrainType))
       or (terrainType < 0 and (dungeonType < 0 or pmap[x][y].layers.dungeon == dungeonType)
                           and (liquidType < 0 or pmap[x][y].layers.liquid == liquidType)
                           and pmap[x][y].flags.hasMonster ~= 1)
end

-- In Brogue it finds the nearest location via path finding
-- I really don't care about that right now so I just do the
-- radial search out starting form the leader location which
-- seems to be good enough for now
local function findNearLeaderLoc (pmap, x, y, hordeType)
  local candidateLocs = 0
  local k = 1
  while k < max(DROWS, DCOLS) and candidateLocs == 0 do
    for i=x-k, x+k do
      for j=y-k, y+k do
        if coordinatesAreInMap(i, j) and
           (i == x-k or i == x+k or j == y-k or j == y+k) and
           testLoc(pmap, i, j, tt.FLOOR, tt.NOTHING, hordeType.spawnsIn)
         then
           candidateLocs = candidateLocs + 1
         end
      end
    end
    k = k+1
  end


  if candidateLocs == 0 then
    return {
      match = true,
      x = 0,
      y = 0
    }
  end

  local randIndex = rand_range(1, candidateLocs)

  for k = 1, max(DROWS, DCOLS) do
    for i=x-k, x+k do
      for j=y-k, y+k do
        if coordinatesAreInMap(i, j) and
           (i == x-k or i == x+k or j == y-k or j == y+k) and
           testLoc(pmap, i, j, tt.FLOOR, tt.NOTHING, hordeType.spawnsIn)
         then
           randIndex = randIndex - 1
           if randIndex == 0 then
             return {
               match = true,
               x = i,
               y = j
             }
           end
         end
      end
    end
  end

  return {
    match = true,
    x = 0,
    y = 0
  }
end


local function spawnMinions (pmap, leaderHorde, leader, _, _)
  local minions = {}
  for _, member in pairs(leaderHorde.members) do
    local count = randClumpRange(member.count[1], member.count[2], member.count[3])
    for _=1, count do
      local monst = generateMonster(member.name)
      monst.leaderId = leader.monsterId
      local loc = findNearLeaderLoc(pmap, leader.x, leader.y, leaderHorde)
      monst.leader = leader
      monst.x = loc.x
      monst.y = loc.y
      pmap[loc.x][loc.y].flags.hasMonster = 1
      print('spawn minion ' .. member.name .. ' at '..loc.x..', '..loc.y.. ' id: ' .. monst.monsterId)
      table.insert(minions, monst)
    end
  end
  return minions
end

local function pickHordeType(depth, forbiddenFlags, requiredFlags, summoner)
  if depth < 0 then
    depth = 1
  end
  local filteredCat = {}
  local possCount = 0
  for i,horde in pairs(hordeCatalog) do
    if false == hasAnyFlags(forbiddenFlags, horde.flags)
      and hasAllFlags(requiredFlags, horde.flags)
      and horde.minLevel <= depth
      and horde.maxLevel >= depth
      and not summoner
    then
      horde.i = i
      table.insert(filteredCat, horde)
      possCount = possCount + horde.frequency
    end

    if hasAllFlags(requiredFlags, horde.flags) and
      summoner == horde.leader
    then
      horde.i = i
      table.insert(filteredCat, horde)
      possCount = possCount + horde.frequency
    end
  end

  if possCount == 0 then
    return
  end

  local index = rand_range(1, possCount)

  for _,horde in pairs(filteredCat) do
    if index <= horde.frequency then
      return horde
    end
    index = index - horde.frequency
  end

  return
end

-- summoner = {
--   monsterId: str
--   name: str
--   x: int
--   y: int
-- }
local function summonMinions (pmap, summoner)
  local horde = pickHordeType(0, {}, {horde_is_summoned = 1}, summoner.name)

  if not horde then
    print('didnt find horde to summon for summoner ' .. summoner.name)
    return {}
  end
  print('summon minions ' .. horde.leader .. ' ' .. horde.i .. ' with members: ' .. #horde.members ..
         ' at ' .. summoner.x..', '.. summoner.y..'. spawns in '..horde.spawnsIn)
  return spawnMinions(pmap, horde, summoner)
end




-- If hordeID is 0, it's randomly assigned based on the depth,
-- with a 10% chance of an out-of-depth spawn from 1-5 levels deeper.
-- If x is negative, location is random.
-- Returns a pointer to the leader.
local function spawnHorde(depth, pmap, hordeID, x, y, forbiddenFlags, requiredFlags)
  if depth > 1 and rand_percent(10) then
    depth = depth + rand_range(1, min(5, depth))
    if depth > AMULET_LEVEL then
      depth = max(depth, AMULET_LEVEL)
    end
    forbiddenFlags.hordeNeverOod = 1
  end

  local horde

  if hordeID <= 0 then
    local failSafe = 50
    local tryAgain
    -- TODO this loop really doesn't do anything
    repeat
      tryAgain = false

      horde = pickHordeType(depth,  forbiddenFlags, requiredFlags)
      if x > 0 and y > 0 then
        print('TODO - add code to handle x and y')
        --TODO add stuff
      end


      failSafe = failSafe - 1
    until tryAgain == false or failSafe < 0
  end

  if x < 0 or y < 0 then
    local failSafe = 50
    local outOfSight
    repeat
      local loc = mg_arch.randomMatchingLocation(pmap, tt.FLOOR, tt.NOTHING, horde.spawnsIn)
      failSafe = failSafe - 1
      x = loc.x
      y = loc.y

      outOfSight = not (loc.match and pmap[x][y].flags.in_field_of_view)

      if not outOfSight then
        --print('monster in stair FOV - spawn somewhere else')
      end
      -- TODO spawn monsters out of sight from the upstairs
      -- right now I've gotten ambushed when coming down
      -- evidently that should be precalculated on the pmap
    until (loc.match == true and passableArcCount(pmap, loc.x, loc.y) <= 1 and outOfSight)
          or failSafe < 0
  end

  print('spawn horde ' .. horde.leader .. ' ' .. horde.i .. ' with members: ' .. #horde.members ..
         ' at ' .. x..', '..y..'. spawns in '..horde.spawnsIn)

  local leader = generateMonster(horde.leader, true, true)
  if x > 0 and y > 0 then
    leader.x = x
    leader.y = y
    pmap[leader.x][leader.y].flags.hasMonster = 1
    leader.leaderId = leader.monsterId
    local minions = spawnMinions(pmap, horde, leader, false, true)

    table.insert(minions, leader)
    return minions
  end
  print('!!!!!! couldnt place monster')
  return {}
end




local function populateMonsters(depth, pmap)
  local numberOfMonsters = min(20, 6 + 3 * max(0, depth - AMULET_LEVEL))

  while rand_percent(60) do
    numberOfMonsters = numberOfMonsters + 1
  end

  print('spawn ' .. numberOfMonsters .. ' hordes for depth ' .. depth)

  local monsters = {}
  local forbiddenFlags = {hord_is_summoned = 1, horde_machine_only = 1}
  for _=1, numberOfMonsters do
    local horde = spawnHorde(depth, pmap, 0, -1, -1, forbiddenFlags, {})
    for _,mon in pairs(horde) do
      table.insert(monsters, mon)
    end
  end
  return monsters
end



-- For polymorph
local monster_name_list = {}
for _, monster in pairs(MK) do
  table.insert(monster_name_list, monster.n)
end

mg_arch.monsters.populateMonsters = populateMonsters
mg_arch.monsters.name_list = monster_name_list
mg_arch.monsters.spawn_horde = spawnHorde
mg_arch.monsters.summon_minions = summonMinions
