-- Need to figure out how to remove cobweb if player has been in it for more than 2 seconds
-- like mcl burning - could check to see if is in cobweb node, - need pos of node, then 
-- I'm going

-- To remove cobwebs
-- I'm doing this the lazy way for now
-- the right way would be like burning is done
-- keep track of every node your touching
-- put a timer on it and remove it
-- sounds hard so I just do the node your feet
-- are mostly in :-)
local mg_cobwebs = {}

local cb_timer = 0
core.register_globalstep(function(dtime)
  cb_timer = cb_timer + dtime
  -- Dont run every step to save on CPU cycles
  if cb_timer < 0.25 then
    return
  end

	for _, player in pairs(core.get_connected_players()) do
    local name = player:get_player_name()
    local pos = player:get_pos()
    local vel = player:get_velocity()
    local vel_abs = math.abs(vel.x) + math.abs(vel.y) + math.abs(vel.z)

    local floor_node_pos = {
      x=math.floor(pos.x + 0.5),
      y=math.floor(pos.y + 0.5),
      z=math.floor(pos.z + 0.5)
    }

    local floor_node = core.get_node(floor_node_pos)


    if floor_node.name ~= "mg_mapgen:cobweb" then
      mg_cobwebs[name] = nil
      return
    end


    local id = core.hash_node_position(floor_node_pos)
    local player_cob = mg_cobwebs[name]

    -- Was the player previously stuck in the same cobweb?
    if player_cob and player_cob.id and player_cob.id == id then
      -- only tick down the timer if the player is moving
      if vel_abs > 0 then
        player_cob.timer = player_cob.timer - cb_timer
      end
      -- This might be why it wasn't working for william
      mg_cobwebs[name] = player_cob

      -- They were stuck for long enought - unstick them
      if player_cob.timer < 0 then
        core.set_node(floor_node_pos, {name="air"})
        mg_cobwebs[name] = nil
      end
    else
      -- If in a new cobweb, then set a timer
      mg_cobwebs[name] = {
        id = id,
        pos = floor_node_pos,
        timer = 1
      }
    end
  end
  cb_timer = 0
end)

