grenades.register_grenade("mg_potions:descent", {
  description = "A potion of descent",
  mg_help = "Throwing this will open the floor to the next level and drop whatever is on it down to the next level.  A great way to get rid of a monster.",
  image = "mg_potions_descent.png",
	on_collide = function()
		return true
	end,
  on_explode = function(_def, _obj, pos, _name)
    minetest.sound_play("grenades_glasslike_break", {
      pos = pos,
      gain = 1.0,
      max_hear_distance = 32,
    })
    mg_effects.descent({pos = pos, radius = 5})
  end
})

grenades.register_grenade("mg_potions:incineration", {
  description = "A potion of incineration",
  image = "mg_potions_incineration.png",
  mg_help = "Throwing this will result in a giant ball of fire where ever it shatters.",
	on_collide = function()
		return true
	end,
  on_explode = function(_def, _obj, pos, _name)
    minetest.sound_play("grenades_glasslike_break", {
      pos = pos,
      gain = 1.0,
      max_hear_distance = 32,
    })
    mg_effects.fireball({pos = pos, radius = 5})
  end
})


grenades.register_grenade("mg_potions:deadly_lichen", {
  description = "A potion of deadly lichen",
  image = "mg_potions_lichen.png",
  mg_help = "Throwing this will result in a plant of deadly lichen.  The lichen will poison whatever it touchs and slowly spread over the level.  Only fire will purge this deadly plant.",
	on_collide = function()
		return true
	end,
  on_explode = function(_def, _obj, pos, _name)
    minetest.sound_play("grenades_glasslike_break", {
      pos = pos,
      gain = 1.0,
      max_hear_distance = 32,
    })
    mg_effects.lichen({pos = pos})
  end
})

grenades.register_grenade("mg_potions:caustic_gas", {
	description = "Potion of caustic gas (Generates a poisonous cloud when it breaks)",
  image = "mg_potions_caustic_gas.png",
  mg_help = "Throwing this will result in a cloud of caustic gas.  It causes damage to what ever is in the cloud.",
	on_collide = function()
		return true
	end,
  on_explode = function(_def, _obj, pos, _name)
    minetest.sound_play("grenades_glasslike_break", {
      pos = pos,
      gain = 1.0,
      max_hear_distance = 32,
    })
    mg_effects.poison_explode(pos)
  end
})
