minetest.register_craftitem("mg_scrolls:shattering", {
  description = "A scroll of shattering",
  inventory_image = "spelltest_spell_blue.png",
  stack_max = 1,
  range = 1.5,
  mg_help = "Reading this scroll will turn the rock around the player into purple crystal that dispates over time, creating air where rock used to be.",
  on_use = function(itemstack, user, _pointed_thing)
    itemstack:set_wear(itemstack:get_wear() + 65535*2)
    local pos = user:getpos()
    mg_effects.shattering({pos = pos, radius = 5})
    return itemstack
  end
})


minetest.register_craftitem("mg_scrolls:recharging", {
  description = "A scroll of recharging (recharges staves and charms)",
  mg_help = "Reading this scroll will fully recharge all your staves and charms",
  inventory_image = "spelltest_spell_yellow.png",
  stack_max = 1,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    itemstack:set_wear(itemstack:get_wear() + 65535*2)
    mg_bolts.recharge_staves(user)
    mg_bolts.recharge_charms(user)
    return itemstack
  end
})

minetest.register_craftitem("mg_scrolls:teleport", {
  description = "A scroll of teleportation",
  mg_help = "Reading this scroll will teleport you to a random place in the level of the current depth.  Great for quick escapes!",
  inventory_image = "voxeldungeon_item_scroll_gyfu.png",
  stack_max = 1,
  range = 1.5,
  on_use = function(itemstack, user, _pointed_thing)
    itemstack:set_wear(itemstack:get_wear() + 65535*2)
    mg_effects.teleport(user)
    return itemstack
  end
})

local mod_path = minetest.get_modpath("mg_scrolls")
dofile(mod_path .. "/item_enhancement.lua")
